// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.transfer.model



public class CreateProfileRequest private constructor(builder: Builder) {
    /**
     * The `As2Id` is the *AS2-name*, as defined in the defined in the [RFC 4130](https://datatracker.ietf.org/doc/html/rfc4130). For inbound transfers, this is the `AS2-From` header for the AS2 messages sent from the partner. For outbound connectors, this is the `AS2-To` header for the AS2 messages sent to the partner using the `StartFileTransfer` API operation. This ID cannot include spaces.
     */
    public val as2Id: kotlin.String? = builder.as2Id
    /**
     * An array of identifiers for the imported certificates. You use this identifier for working with profiles and partner profiles.
     */
    public val certificateIds: List<String>? = builder.certificateIds
    /**
     * Indicates whether to list only `LOCAL` type profiles or only `PARTNER` type profiles. If not supplied in the request, the command lists all types of profiles.
     */
    public val profileType: aws.sdk.kotlin.services.transfer.model.ProfileType? = builder.profileType
    /**
     * Key-value pairs that can be used to group and search for AS2 profiles.
     */
    public val tags: List<Tag>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.transfer.model.CreateProfileRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateProfileRequest(")
        append("as2Id=$as2Id,")
        append("certificateIds=$certificateIds,")
        append("profileType=$profileType,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = as2Id?.hashCode() ?: 0
        result = 31 * result + (certificateIds?.hashCode() ?: 0)
        result = 31 * result + (profileType?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateProfileRequest

        if (as2Id != other.as2Id) return false
        if (certificateIds != other.certificateIds) return false
        if (profileType != other.profileType) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.transfer.model.CreateProfileRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The `As2Id` is the *AS2-name*, as defined in the defined in the [RFC 4130](https://datatracker.ietf.org/doc/html/rfc4130). For inbound transfers, this is the `AS2-From` header for the AS2 messages sent from the partner. For outbound connectors, this is the `AS2-To` header for the AS2 messages sent to the partner using the `StartFileTransfer` API operation. This ID cannot include spaces.
         */
        public var as2Id: kotlin.String? = null
        /**
         * An array of identifiers for the imported certificates. You use this identifier for working with profiles and partner profiles.
         */
        public var certificateIds: List<String>? = null
        /**
         * Indicates whether to list only `LOCAL` type profiles or only `PARTNER` type profiles. If not supplied in the request, the command lists all types of profiles.
         */
        public var profileType: aws.sdk.kotlin.services.transfer.model.ProfileType? = null
        /**
         * Key-value pairs that can be used to group and search for AS2 profiles.
         */
        public var tags: List<Tag>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.transfer.model.CreateProfileRequest) : this() {
            this.as2Id = x.as2Id
            this.certificateIds = x.certificateIds
            this.profileType = x.profileType
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.transfer.model.CreateProfileRequest = CreateProfileRequest(this)
    }
}
