// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.transfer.model



/**
 * Describes the properties of an agreement.
 */
public class DescribedAgreement private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the Identity and Access Management (IAM) role that grants access to at least the `HomeDirectory` of your users' Amazon S3 buckets.
     */
    public val accessRole: kotlin.String? = builder.accessRole
    /**
     * A unique identifier for the agreement. This identifier is returned when you create an agreement.
     */
    public val agreementId: kotlin.String? = builder.agreementId
    /**
     * The unique Amazon Resource Name (ARN) for the agreement.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The landing directory (folder) for files that are transferred by using the AS2 protocol.
     */
    public val baseDirectory: kotlin.String? = builder.baseDirectory
    /**
     * The name or short description that's used to identify the agreement.
     */
    public val description: kotlin.String? = builder.description
    /**
     * A unique identifier for the AS2 process.
     */
    public val localProfileId: kotlin.String? = builder.localProfileId
    /**
     * A unique identifier for the partner in the agreement.
     */
    public val partnerProfileId: kotlin.String? = builder.partnerProfileId
    /**
     * A system-assigned unique identifier for a server instance. This identifier indicates the specific server that the agreement uses.
     */
    public val serverId: kotlin.String? = builder.serverId
    /**
     * The current status of the agreement, either `ACTIVE` or `INACTIVE`.
     */
    public val status: aws.sdk.kotlin.services.transfer.model.AgreementStatusType? = builder.status
    /**
     * Key-value pairs that can be used to group and search for agreements.
     */
    public val tags: List<Tag>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.transfer.model.DescribedAgreement = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribedAgreement(")
        append("accessRole=$accessRole,")
        append("agreementId=$agreementId,")
        append("arn=$arn,")
        append("baseDirectory=$baseDirectory,")
        append("description=$description,")
        append("localProfileId=$localProfileId,")
        append("partnerProfileId=$partnerProfileId,")
        append("serverId=$serverId,")
        append("status=$status,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = accessRole?.hashCode() ?: 0
        result = 31 * result + (agreementId?.hashCode() ?: 0)
        result = 31 * result + (arn?.hashCode() ?: 0)
        result = 31 * result + (baseDirectory?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (localProfileId?.hashCode() ?: 0)
        result = 31 * result + (partnerProfileId?.hashCode() ?: 0)
        result = 31 * result + (serverId?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribedAgreement

        if (accessRole != other.accessRole) return false
        if (agreementId != other.agreementId) return false
        if (arn != other.arn) return false
        if (baseDirectory != other.baseDirectory) return false
        if (description != other.description) return false
        if (localProfileId != other.localProfileId) return false
        if (partnerProfileId != other.partnerProfileId) return false
        if (serverId != other.serverId) return false
        if (status != other.status) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.transfer.model.DescribedAgreement = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the Identity and Access Management (IAM) role that grants access to at least the `HomeDirectory` of your users' Amazon S3 buckets.
         */
        public var accessRole: kotlin.String? = null
        /**
         * A unique identifier for the agreement. This identifier is returned when you create an agreement.
         */
        public var agreementId: kotlin.String? = null
        /**
         * The unique Amazon Resource Name (ARN) for the agreement.
         */
        public var arn: kotlin.String? = null
        /**
         * The landing directory (folder) for files that are transferred by using the AS2 protocol.
         */
        public var baseDirectory: kotlin.String? = null
        /**
         * The name or short description that's used to identify the agreement.
         */
        public var description: kotlin.String? = null
        /**
         * A unique identifier for the AS2 process.
         */
        public var localProfileId: kotlin.String? = null
        /**
         * A unique identifier for the partner in the agreement.
         */
        public var partnerProfileId: kotlin.String? = null
        /**
         * A system-assigned unique identifier for a server instance. This identifier indicates the specific server that the agreement uses.
         */
        public var serverId: kotlin.String? = null
        /**
         * The current status of the agreement, either `ACTIVE` or `INACTIVE`.
         */
        public var status: aws.sdk.kotlin.services.transfer.model.AgreementStatusType? = null
        /**
         * Key-value pairs that can be used to group and search for agreements.
         */
        public var tags: List<Tag>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.transfer.model.DescribedAgreement) : this() {
            this.accessRole = x.accessRole
            this.agreementId = x.agreementId
            this.arn = x.arn
            this.baseDirectory = x.baseDirectory
            this.description = x.description
            this.localProfileId = x.localProfileId
            this.partnerProfileId = x.partnerProfileId
            this.serverId = x.serverId
            this.status = x.status
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.transfer.model.DescribedAgreement = DescribedAgreement(this)
    }
}
