// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.transfer.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes the properties of a certificate.
 */
public class DescribedCertificate private constructor(builder: Builder) {
    /**
     * An optional date that specifies when the certificate becomes active.
     */
    public val activeDate: aws.smithy.kotlin.runtime.time.Instant? = builder.activeDate
    /**
     * The unique Amazon Resource Name (ARN) for the certificate.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The file name for the certificate.
     */
    public val certificate: kotlin.String? = builder.certificate
    /**
     * The list of certificates that make up the chain for the certificate.
     */
    public val certificateChain: kotlin.String? = builder.certificateChain
    /**
     * An array of identifiers for the imported certificates. You use this identifier for working with profiles and partner profiles.
     */
    public val certificateId: kotlin.String? = builder.certificateId
    /**
     * The name or description that's used to identity the certificate.
     */
    public val description: kotlin.String? = builder.description
    /**
     * An optional date that specifies when the certificate becomes inactive.
     */
    public val inactiveDate: aws.smithy.kotlin.runtime.time.Instant? = builder.inactiveDate
    /**
     * The final date that the certificate is valid.
     */
    public val notAfterDate: aws.smithy.kotlin.runtime.time.Instant? = builder.notAfterDate
    /**
     * The earliest date that the certificate is valid.
     */
    public val notBeforeDate: aws.smithy.kotlin.runtime.time.Instant? = builder.notBeforeDate
    /**
     * The serial number for the certificate.
     */
    public val serial: kotlin.String? = builder.serial
    /**
     * The certificate can be either `ACTIVE`, `PENDING_ROTATION`, or `INACTIVE`. `PENDING_ROTATION` means that this certificate will replace the current certificate when it expires.
     */
    public val status: aws.sdk.kotlin.services.transfer.model.CertificateStatusType? = builder.status
    /**
     * Key-value pairs that can be used to group and search for certificates.
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * If a private key has been specified for the certificate, its type is `CERTIFICATE_WITH_PRIVATE_KEY`. If there is no private key, the type is `CERTIFICATE`.
     */
    public val type: aws.sdk.kotlin.services.transfer.model.CertificateType? = builder.type
    /**
     * Specifies whether this certificate is used for signing or encryption.
     */
    public val usage: aws.sdk.kotlin.services.transfer.model.CertificateUsageType? = builder.usage

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.transfer.model.DescribedCertificate = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribedCertificate(")
        append("activeDate=$activeDate,")
        append("arn=$arn,")
        append("certificate=*** Sensitive Data Redacted ***,")
        append("certificateChain=*** Sensitive Data Redacted ***,")
        append("certificateId=$certificateId,")
        append("description=$description,")
        append("inactiveDate=$inactiveDate,")
        append("notAfterDate=$notAfterDate,")
        append("notBeforeDate=$notBeforeDate,")
        append("serial=$serial,")
        append("status=$status,")
        append("tags=$tags,")
        append("type=$type,")
        append("usage=$usage)")
    }

    override fun hashCode(): kotlin.Int {
        var result = activeDate?.hashCode() ?: 0
        result = 31 * result + (arn?.hashCode() ?: 0)
        result = 31 * result + (certificate?.hashCode() ?: 0)
        result = 31 * result + (certificateChain?.hashCode() ?: 0)
        result = 31 * result + (certificateId?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (inactiveDate?.hashCode() ?: 0)
        result = 31 * result + (notAfterDate?.hashCode() ?: 0)
        result = 31 * result + (notBeforeDate?.hashCode() ?: 0)
        result = 31 * result + (serial?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        result = 31 * result + (usage?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribedCertificate

        if (activeDate != other.activeDate) return false
        if (arn != other.arn) return false
        if (certificate != other.certificate) return false
        if (certificateChain != other.certificateChain) return false
        if (certificateId != other.certificateId) return false
        if (description != other.description) return false
        if (inactiveDate != other.inactiveDate) return false
        if (notAfterDate != other.notAfterDate) return false
        if (notBeforeDate != other.notBeforeDate) return false
        if (serial != other.serial) return false
        if (status != other.status) return false
        if (tags != other.tags) return false
        if (type != other.type) return false
        if (usage != other.usage) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.transfer.model.DescribedCertificate = Builder(this).apply(block).build()

    public class Builder {
        /**
         * An optional date that specifies when the certificate becomes active.
         */
        public var activeDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The unique Amazon Resource Name (ARN) for the certificate.
         */
        public var arn: kotlin.String? = null
        /**
         * The file name for the certificate.
         */
        public var certificate: kotlin.String? = null
        /**
         * The list of certificates that make up the chain for the certificate.
         */
        public var certificateChain: kotlin.String? = null
        /**
         * An array of identifiers for the imported certificates. You use this identifier for working with profiles and partner profiles.
         */
        public var certificateId: kotlin.String? = null
        /**
         * The name or description that's used to identity the certificate.
         */
        public var description: kotlin.String? = null
        /**
         * An optional date that specifies when the certificate becomes inactive.
         */
        public var inactiveDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The final date that the certificate is valid.
         */
        public var notAfterDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The earliest date that the certificate is valid.
         */
        public var notBeforeDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The serial number for the certificate.
         */
        public var serial: kotlin.String? = null
        /**
         * The certificate can be either `ACTIVE`, `PENDING_ROTATION`, or `INACTIVE`. `PENDING_ROTATION` means that this certificate will replace the current certificate when it expires.
         */
        public var status: aws.sdk.kotlin.services.transfer.model.CertificateStatusType? = null
        /**
         * Key-value pairs that can be used to group and search for certificates.
         */
        public var tags: List<Tag>? = null
        /**
         * If a private key has been specified for the certificate, its type is `CERTIFICATE_WITH_PRIVATE_KEY`. If there is no private key, the type is `CERTIFICATE`.
         */
        public var type: aws.sdk.kotlin.services.transfer.model.CertificateType? = null
        /**
         * Specifies whether this certificate is used for signing or encryption.
         */
        public var usage: aws.sdk.kotlin.services.transfer.model.CertificateUsageType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.transfer.model.DescribedCertificate) : this() {
            this.activeDate = x.activeDate
            this.arn = x.arn
            this.certificate = x.certificate
            this.certificateChain = x.certificateChain
            this.certificateId = x.certificateId
            this.description = x.description
            this.inactiveDate = x.inactiveDate
            this.notAfterDate = x.notAfterDate
            this.notBeforeDate = x.notBeforeDate
            this.serial = x.serial
            this.status = x.status
            this.tags = x.tags
            this.type = x.type
            this.usage = x.usage
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.transfer.model.DescribedCertificate = DescribedCertificate(this)
    }
}
