// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.transfer.model



/**
 * The details for an execution object.
 */
public class DescribedExecution private constructor(builder: Builder) {
    /**
     * A unique identifier for the execution of a workflow.
     */
    public val executionId: kotlin.String? = builder.executionId
    /**
     * The IAM role associated with the execution.
     */
    public val executionRole: kotlin.String? = builder.executionRole
    /**
     * A structure that describes the Amazon S3 or EFS file location. This is the file location when the execution begins: if the file is being copied, this is the initial (as opposed to destination) file location.
     */
    public val initialFileLocation: aws.sdk.kotlin.services.transfer.model.FileLocation? = builder.initialFileLocation
    /**
     * The IAM logging role associated with the execution.
     */
    public val loggingConfiguration: aws.sdk.kotlin.services.transfer.model.LoggingConfiguration? = builder.loggingConfiguration
    /**
     * The full POSIX identity, including user ID (`Uid`), group ID (`Gid`), and any secondary groups IDs (`SecondaryGids`), that controls your users' access to your Amazon EFS file systems. The POSIX permissions that are set on files and directories in your file system determine the level of access your users get when transferring files into and out of your Amazon EFS file systems.
     */
    public val posixProfile: aws.sdk.kotlin.services.transfer.model.PosixProfile? = builder.posixProfile
    /**
     * A structure that describes the execution results. This includes a list of the steps along with the details of each step, error type and message (if any), and the `OnExceptionSteps` structure.
     */
    public val results: aws.sdk.kotlin.services.transfer.model.ExecutionResults? = builder.results
    /**
     * A container object for the session details that are associated with a workflow.
     */
    public val serviceMetadata: aws.sdk.kotlin.services.transfer.model.ServiceMetadata? = builder.serviceMetadata
    /**
     * The status is one of the execution. Can be in progress, completed, exception encountered, or handling the exception.
     */
    public val status: aws.sdk.kotlin.services.transfer.model.ExecutionStatus? = builder.status

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.transfer.model.DescribedExecution = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribedExecution(")
        append("executionId=$executionId,")
        append("executionRole=$executionRole,")
        append("initialFileLocation=$initialFileLocation,")
        append("loggingConfiguration=$loggingConfiguration,")
        append("posixProfile=$posixProfile,")
        append("results=$results,")
        append("serviceMetadata=$serviceMetadata,")
        append("status=$status)")
    }

    override fun hashCode(): kotlin.Int {
        var result = executionId?.hashCode() ?: 0
        result = 31 * result + (executionRole?.hashCode() ?: 0)
        result = 31 * result + (initialFileLocation?.hashCode() ?: 0)
        result = 31 * result + (loggingConfiguration?.hashCode() ?: 0)
        result = 31 * result + (posixProfile?.hashCode() ?: 0)
        result = 31 * result + (results?.hashCode() ?: 0)
        result = 31 * result + (serviceMetadata?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribedExecution

        if (executionId != other.executionId) return false
        if (executionRole != other.executionRole) return false
        if (initialFileLocation != other.initialFileLocation) return false
        if (loggingConfiguration != other.loggingConfiguration) return false
        if (posixProfile != other.posixProfile) return false
        if (results != other.results) return false
        if (serviceMetadata != other.serviceMetadata) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.transfer.model.DescribedExecution = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A unique identifier for the execution of a workflow.
         */
        public var executionId: kotlin.String? = null
        /**
         * The IAM role associated with the execution.
         */
        public var executionRole: kotlin.String? = null
        /**
         * A structure that describes the Amazon S3 or EFS file location. This is the file location when the execution begins: if the file is being copied, this is the initial (as opposed to destination) file location.
         */
        public var initialFileLocation: aws.sdk.kotlin.services.transfer.model.FileLocation? = null
        /**
         * The IAM logging role associated with the execution.
         */
        public var loggingConfiguration: aws.sdk.kotlin.services.transfer.model.LoggingConfiguration? = null
        /**
         * The full POSIX identity, including user ID (`Uid`), group ID (`Gid`), and any secondary groups IDs (`SecondaryGids`), that controls your users' access to your Amazon EFS file systems. The POSIX permissions that are set on files and directories in your file system determine the level of access your users get when transferring files into and out of your Amazon EFS file systems.
         */
        public var posixProfile: aws.sdk.kotlin.services.transfer.model.PosixProfile? = null
        /**
         * A structure that describes the execution results. This includes a list of the steps along with the details of each step, error type and message (if any), and the `OnExceptionSteps` structure.
         */
        public var results: aws.sdk.kotlin.services.transfer.model.ExecutionResults? = null
        /**
         * A container object for the session details that are associated with a workflow.
         */
        public var serviceMetadata: aws.sdk.kotlin.services.transfer.model.ServiceMetadata? = null
        /**
         * The status is one of the execution. Can be in progress, completed, exception encountered, or handling the exception.
         */
        public var status: aws.sdk.kotlin.services.transfer.model.ExecutionStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.transfer.model.DescribedExecution) : this() {
            this.executionId = x.executionId
            this.executionRole = x.executionRole
            this.initialFileLocation = x.initialFileLocation
            this.loggingConfiguration = x.loggingConfiguration
            this.posixProfile = x.posixProfile
            this.results = x.results
            this.serviceMetadata = x.serviceMetadata
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.transfer.model.DescribedExecution = DescribedExecution(this)

        /**
         * construct an [aws.sdk.kotlin.services.transfer.model.FileLocation] inside the given [block]
         */
        public fun initialFileLocation(block: aws.sdk.kotlin.services.transfer.model.FileLocation.Builder.() -> kotlin.Unit) {
            this.initialFileLocation = aws.sdk.kotlin.services.transfer.model.FileLocation.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.transfer.model.LoggingConfiguration] inside the given [block]
         */
        public fun loggingConfiguration(block: aws.sdk.kotlin.services.transfer.model.LoggingConfiguration.Builder.() -> kotlin.Unit) {
            this.loggingConfiguration = aws.sdk.kotlin.services.transfer.model.LoggingConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.transfer.model.PosixProfile] inside the given [block]
         */
        public fun posixProfile(block: aws.sdk.kotlin.services.transfer.model.PosixProfile.Builder.() -> kotlin.Unit) {
            this.posixProfile = aws.sdk.kotlin.services.transfer.model.PosixProfile.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.transfer.model.ExecutionResults] inside the given [block]
         */
        public fun results(block: aws.sdk.kotlin.services.transfer.model.ExecutionResults.Builder.() -> kotlin.Unit) {
            this.results = aws.sdk.kotlin.services.transfer.model.ExecutionResults.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.transfer.model.ServiceMetadata] inside the given [block]
         */
        public fun serviceMetadata(block: aws.sdk.kotlin.services.transfer.model.ServiceMetadata.Builder.() -> kotlin.Unit) {
            this.serviceMetadata = aws.sdk.kotlin.services.transfer.model.ServiceMetadata.invoke(block)
        }
    }
}
