// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.transfer.model



/**
 * Describes the properties of a file transfer protocol-enabled server that was specified.
 */
public class DescribedServer private constructor(builder: Builder) {
    /**
     * Specifies the unique Amazon Resource Name (ARN) of the server.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * Specifies the ARN of the Amazon Web ServicesCertificate Manager (ACM) certificate. Required when `Protocols` is set to `FTPS`.
     */
    public val certificate: kotlin.String? = builder.certificate
    /**
     * Specifies the domain of the storage system that is used for file transfers.
     */
    public val domain: aws.sdk.kotlin.services.transfer.model.Domain? = builder.domain
    /**
     * The virtual private cloud (VPC) endpoint settings that are configured for your server. When you host your endpoint within your VPC, you can make your endpoint accessible only to resources within your VPC, or you can attach Elastic IP addresses and make your endpoint accessible to clients over the internet. Your VPC's default security groups are automatically assigned to your endpoint.
     */
    public val endpointDetails: aws.sdk.kotlin.services.transfer.model.EndpointDetails? = builder.endpointDetails
    /**
     * Defines the type of endpoint that your server is connected to. If your server is connected to a VPC endpoint, your server isn't accessible over the public internet.
     */
    public val endpointType: aws.sdk.kotlin.services.transfer.model.EndpointType? = builder.endpointType
    /**
     * Specifies the Base64-encoded SHA256 fingerprint of the server's host key. This value is equivalent to the output of the `ssh-keygen -l -f my-new-server-key` command.
     */
    public val hostKeyFingerprint: kotlin.String? = builder.hostKeyFingerprint
    /**
     * Specifies information to call a customer-supplied authentication API. This field is not populated when the `IdentityProviderType` of a server is `AWS_DIRECTORY_SERVICE` or `SERVICE_MANAGED`.
     */
    public val identityProviderDetails: aws.sdk.kotlin.services.transfer.model.IdentityProviderDetails? = builder.identityProviderDetails
    /**
     * The mode of authentication for a server. The default value is `SERVICE_MANAGED`, which allows you to store and access user credentials within the Transfer Family service.
     *
     * Use `AWS_DIRECTORY_SERVICE` to provide access to Active Directory groups in Directory Service for Microsoft Active Directory or Microsoft Active Directory in your on-premises environment or in Amazon Web Services using AD Connector. This option also requires you to provide a Directory ID by using the `IdentityProviderDetails` parameter.
     *
     * Use the `API_GATEWAY` value to integrate with an identity provider of your choosing. The `API_GATEWAY` setting requires you to provide an Amazon API Gateway endpoint URL to call for authentication by using the `IdentityProviderDetails` parameter.
     *
     * Use the `AWS_LAMBDA` value to directly use an Lambda function as your identity provider. If you choose this value, you must specify the ARN for the Lambda function in the `Function` parameter or the `IdentityProviderDetails` data type.
     */
    public val identityProviderType: aws.sdk.kotlin.services.transfer.model.IdentityProviderType? = builder.identityProviderType
    /**
     * The Amazon Resource Name (ARN) of the Identity and Access Management (IAM) role that allows a server to turn on Amazon CloudWatch logging for Amazon S3 or Amazon EFSevents. When set, you can view user activity in your CloudWatch logs.
     */
    public val loggingRole: kotlin.String? = builder.loggingRole
    /**
     * Specifies a string to display when users connect to a server. This string is displayed after the user authenticates.
     *
     * The SFTP protocol does not support post-authentication display banners.
     */
    public val postAuthenticationLoginBanner: kotlin.String? = builder.postAuthenticationLoginBanner
    /**
     * Specifies a string to display when users connect to a server. This string is displayed before the user authenticates. For example, the following banner displays details about using the system:
     *
     * `This system is for the use of authorized users only. Individuals using this computer system without authority, or in excess of their authority, are subject to having all of their activities on this system monitored and recorded by system personnel.`
     */
    public val preAuthenticationLoginBanner: kotlin.String? = builder.preAuthenticationLoginBanner
    /**
     * The protocol settings that are configured for your server.
     *
     *  Use the `PassiveIp` parameter to indicate passive mode. Enter a single IPv4 address, such as the public IP address of a firewall, router, or load balancer.
     */
    public val protocolDetails: aws.sdk.kotlin.services.transfer.model.ProtocolDetails? = builder.protocolDetails
    /**
     * Specifies the file transfer protocol or protocols over which your file transfer protocol client can connect to your server's endpoint. The available protocols are:
     * + `SFTP` (Secure Shell (SSH) File Transfer Protocol): File transfer over SSH
     * + `FTPS` (File Transfer Protocol Secure): File transfer with TLS encryption
     * + `FTP` (File Transfer Protocol): Unencrypted file transfer
     */
    public val protocols: List<Protocol>? = builder.protocols
    /**
     * Specifies the name of the security policy that is attached to the server.
     */
    public val securityPolicyName: kotlin.String? = builder.securityPolicyName
    /**
     * Specifies the unique system-assigned identifier for a server that you instantiate.
     */
    public val serverId: kotlin.String? = builder.serverId
    /**
     * The condition of the server that was described. A value of `ONLINE` indicates that the server can accept jobs and transfer files. A `State` value of `OFFLINE` means that the server cannot perform file transfer operations.
     *
     * The states of `STARTING` and `STOPPING` indicate that the server is in an intermediate state, either not fully able to respond, or not fully offline. The values of `START_FAILED` or `STOP_FAILED` can indicate an error condition.
     */
    public val state: aws.sdk.kotlin.services.transfer.model.State? = builder.state
    /**
     * Specifies the key-value pairs that you can use to search for and group servers that were assigned to the server that was described.
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * Specifies the number of users that are assigned to a server you specified with the `ServerId`.
     */
    public val userCount: kotlin.Int? = builder.userCount
    /**
     * Specifies the workflow ID for the workflow to assign and the execution role that's used for executing the workflow.
     */
    public val workflowDetails: aws.sdk.kotlin.services.transfer.model.WorkflowDetails? = builder.workflowDetails

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.transfer.model.DescribedServer = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribedServer(")
        append("arn=$arn,")
        append("certificate=$certificate,")
        append("domain=$domain,")
        append("endpointDetails=$endpointDetails,")
        append("endpointType=$endpointType,")
        append("hostKeyFingerprint=$hostKeyFingerprint,")
        append("identityProviderDetails=$identityProviderDetails,")
        append("identityProviderType=$identityProviderType,")
        append("loggingRole=$loggingRole,")
        append("postAuthenticationLoginBanner=$postAuthenticationLoginBanner,")
        append("preAuthenticationLoginBanner=$preAuthenticationLoginBanner,")
        append("protocolDetails=$protocolDetails,")
        append("protocols=$protocols,")
        append("securityPolicyName=$securityPolicyName,")
        append("serverId=$serverId,")
        append("state=$state,")
        append("tags=$tags,")
        append("userCount=$userCount,")
        append("workflowDetails=$workflowDetails)")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (certificate?.hashCode() ?: 0)
        result = 31 * result + (domain?.hashCode() ?: 0)
        result = 31 * result + (endpointDetails?.hashCode() ?: 0)
        result = 31 * result + (endpointType?.hashCode() ?: 0)
        result = 31 * result + (hostKeyFingerprint?.hashCode() ?: 0)
        result = 31 * result + (identityProviderDetails?.hashCode() ?: 0)
        result = 31 * result + (identityProviderType?.hashCode() ?: 0)
        result = 31 * result + (loggingRole?.hashCode() ?: 0)
        result = 31 * result + (postAuthenticationLoginBanner?.hashCode() ?: 0)
        result = 31 * result + (preAuthenticationLoginBanner?.hashCode() ?: 0)
        result = 31 * result + (protocolDetails?.hashCode() ?: 0)
        result = 31 * result + (protocols?.hashCode() ?: 0)
        result = 31 * result + (securityPolicyName?.hashCode() ?: 0)
        result = 31 * result + (serverId?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (userCount ?: 0)
        result = 31 * result + (workflowDetails?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribedServer

        if (arn != other.arn) return false
        if (certificate != other.certificate) return false
        if (domain != other.domain) return false
        if (endpointDetails != other.endpointDetails) return false
        if (endpointType != other.endpointType) return false
        if (hostKeyFingerprint != other.hostKeyFingerprint) return false
        if (identityProviderDetails != other.identityProviderDetails) return false
        if (identityProviderType != other.identityProviderType) return false
        if (loggingRole != other.loggingRole) return false
        if (postAuthenticationLoginBanner != other.postAuthenticationLoginBanner) return false
        if (preAuthenticationLoginBanner != other.preAuthenticationLoginBanner) return false
        if (protocolDetails != other.protocolDetails) return false
        if (protocols != other.protocols) return false
        if (securityPolicyName != other.securityPolicyName) return false
        if (serverId != other.serverId) return false
        if (state != other.state) return false
        if (tags != other.tags) return false
        if (userCount != other.userCount) return false
        if (workflowDetails != other.workflowDetails) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.transfer.model.DescribedServer = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Specifies the unique Amazon Resource Name (ARN) of the server.
         */
        public var arn: kotlin.String? = null
        /**
         * Specifies the ARN of the Amazon Web ServicesCertificate Manager (ACM) certificate. Required when `Protocols` is set to `FTPS`.
         */
        public var certificate: kotlin.String? = null
        /**
         * Specifies the domain of the storage system that is used for file transfers.
         */
        public var domain: aws.sdk.kotlin.services.transfer.model.Domain? = null
        /**
         * The virtual private cloud (VPC) endpoint settings that are configured for your server. When you host your endpoint within your VPC, you can make your endpoint accessible only to resources within your VPC, or you can attach Elastic IP addresses and make your endpoint accessible to clients over the internet. Your VPC's default security groups are automatically assigned to your endpoint.
         */
        public var endpointDetails: aws.sdk.kotlin.services.transfer.model.EndpointDetails? = null
        /**
         * Defines the type of endpoint that your server is connected to. If your server is connected to a VPC endpoint, your server isn't accessible over the public internet.
         */
        public var endpointType: aws.sdk.kotlin.services.transfer.model.EndpointType? = null
        /**
         * Specifies the Base64-encoded SHA256 fingerprint of the server's host key. This value is equivalent to the output of the `ssh-keygen -l -f my-new-server-key` command.
         */
        public var hostKeyFingerprint: kotlin.String? = null
        /**
         * Specifies information to call a customer-supplied authentication API. This field is not populated when the `IdentityProviderType` of a server is `AWS_DIRECTORY_SERVICE` or `SERVICE_MANAGED`.
         */
        public var identityProviderDetails: aws.sdk.kotlin.services.transfer.model.IdentityProviderDetails? = null
        /**
         * The mode of authentication for a server. The default value is `SERVICE_MANAGED`, which allows you to store and access user credentials within the Transfer Family service.
         *
         * Use `AWS_DIRECTORY_SERVICE` to provide access to Active Directory groups in Directory Service for Microsoft Active Directory or Microsoft Active Directory in your on-premises environment or in Amazon Web Services using AD Connector. This option also requires you to provide a Directory ID by using the `IdentityProviderDetails` parameter.
         *
         * Use the `API_GATEWAY` value to integrate with an identity provider of your choosing. The `API_GATEWAY` setting requires you to provide an Amazon API Gateway endpoint URL to call for authentication by using the `IdentityProviderDetails` parameter.
         *
         * Use the `AWS_LAMBDA` value to directly use an Lambda function as your identity provider. If you choose this value, you must specify the ARN for the Lambda function in the `Function` parameter or the `IdentityProviderDetails` data type.
         */
        public var identityProviderType: aws.sdk.kotlin.services.transfer.model.IdentityProviderType? = null
        /**
         * The Amazon Resource Name (ARN) of the Identity and Access Management (IAM) role that allows a server to turn on Amazon CloudWatch logging for Amazon S3 or Amazon EFSevents. When set, you can view user activity in your CloudWatch logs.
         */
        public var loggingRole: kotlin.String? = null
        /**
         * Specifies a string to display when users connect to a server. This string is displayed after the user authenticates.
         *
         * The SFTP protocol does not support post-authentication display banners.
         */
        public var postAuthenticationLoginBanner: kotlin.String? = null
        /**
         * Specifies a string to display when users connect to a server. This string is displayed before the user authenticates. For example, the following banner displays details about using the system:
         *
         * `This system is for the use of authorized users only. Individuals using this computer system without authority, or in excess of their authority, are subject to having all of their activities on this system monitored and recorded by system personnel.`
         */
        public var preAuthenticationLoginBanner: kotlin.String? = null
        /**
         * The protocol settings that are configured for your server.
         *
         *  Use the `PassiveIp` parameter to indicate passive mode. Enter a single IPv4 address, such as the public IP address of a firewall, router, or load balancer.
         */
        public var protocolDetails: aws.sdk.kotlin.services.transfer.model.ProtocolDetails? = null
        /**
         * Specifies the file transfer protocol or protocols over which your file transfer protocol client can connect to your server's endpoint. The available protocols are:
         * + `SFTP` (Secure Shell (SSH) File Transfer Protocol): File transfer over SSH
         * + `FTPS` (File Transfer Protocol Secure): File transfer with TLS encryption
         * + `FTP` (File Transfer Protocol): Unencrypted file transfer
         */
        public var protocols: List<Protocol>? = null
        /**
         * Specifies the name of the security policy that is attached to the server.
         */
        public var securityPolicyName: kotlin.String? = null
        /**
         * Specifies the unique system-assigned identifier for a server that you instantiate.
         */
        public var serverId: kotlin.String? = null
        /**
         * The condition of the server that was described. A value of `ONLINE` indicates that the server can accept jobs and transfer files. A `State` value of `OFFLINE` means that the server cannot perform file transfer operations.
         *
         * The states of `STARTING` and `STOPPING` indicate that the server is in an intermediate state, either not fully able to respond, or not fully offline. The values of `START_FAILED` or `STOP_FAILED` can indicate an error condition.
         */
        public var state: aws.sdk.kotlin.services.transfer.model.State? = null
        /**
         * Specifies the key-value pairs that you can use to search for and group servers that were assigned to the server that was described.
         */
        public var tags: List<Tag>? = null
        /**
         * Specifies the number of users that are assigned to a server you specified with the `ServerId`.
         */
        public var userCount: kotlin.Int? = null
        /**
         * Specifies the workflow ID for the workflow to assign and the execution role that's used for executing the workflow.
         */
        public var workflowDetails: aws.sdk.kotlin.services.transfer.model.WorkflowDetails? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.transfer.model.DescribedServer) : this() {
            this.arn = x.arn
            this.certificate = x.certificate
            this.domain = x.domain
            this.endpointDetails = x.endpointDetails
            this.endpointType = x.endpointType
            this.hostKeyFingerprint = x.hostKeyFingerprint
            this.identityProviderDetails = x.identityProviderDetails
            this.identityProviderType = x.identityProviderType
            this.loggingRole = x.loggingRole
            this.postAuthenticationLoginBanner = x.postAuthenticationLoginBanner
            this.preAuthenticationLoginBanner = x.preAuthenticationLoginBanner
            this.protocolDetails = x.protocolDetails
            this.protocols = x.protocols
            this.securityPolicyName = x.securityPolicyName
            this.serverId = x.serverId
            this.state = x.state
            this.tags = x.tags
            this.userCount = x.userCount
            this.workflowDetails = x.workflowDetails
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.transfer.model.DescribedServer = DescribedServer(this)

        /**
         * construct an [aws.sdk.kotlin.services.transfer.model.EndpointDetails] inside the given [block]
         */
        public fun endpointDetails(block: aws.sdk.kotlin.services.transfer.model.EndpointDetails.Builder.() -> kotlin.Unit) {
            this.endpointDetails = aws.sdk.kotlin.services.transfer.model.EndpointDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.transfer.model.IdentityProviderDetails] inside the given [block]
         */
        public fun identityProviderDetails(block: aws.sdk.kotlin.services.transfer.model.IdentityProviderDetails.Builder.() -> kotlin.Unit) {
            this.identityProviderDetails = aws.sdk.kotlin.services.transfer.model.IdentityProviderDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.transfer.model.ProtocolDetails] inside the given [block]
         */
        public fun protocolDetails(block: aws.sdk.kotlin.services.transfer.model.ProtocolDetails.Builder.() -> kotlin.Unit) {
            this.protocolDetails = aws.sdk.kotlin.services.transfer.model.ProtocolDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.transfer.model.WorkflowDetails] inside the given [block]
         */
        public fun workflowDetails(block: aws.sdk.kotlin.services.transfer.model.WorkflowDetails.Builder.() -> kotlin.Unit) {
            this.workflowDetails = aws.sdk.kotlin.services.transfer.model.WorkflowDetails.invoke(block)
        }
    }
}
