// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.transfer.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes the properties of a certificate.
 */
public class ListedCertificate private constructor(builder: Builder) {
    /**
     * An optional date that specifies when the certificate becomes active.
     */
    public val activeDate: aws.smithy.kotlin.runtime.time.Instant? = builder.activeDate
    /**
     * The Amazon Resource Name (ARN) of the specified certificate.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * An array of identifiers for the imported certificates. You use this identifier for working with profiles and partner profiles.
     */
    public val certificateId: kotlin.String? = builder.certificateId
    /**
     * The name or short description that's used to identify the certificate.
     */
    public val description: kotlin.String? = builder.description
    /**
     * An optional date that specifies when the certificate becomes inactive.
     */
    public val inactiveDate: aws.smithy.kotlin.runtime.time.Instant? = builder.inactiveDate
    /**
     * The certificate can be either `ACTIVE`, `PENDING_ROTATION`, or `INACTIVE`. `PENDING_ROTATION` means that this certificate will replace the current certificate when it expires.
     */
    public val status: aws.sdk.kotlin.services.transfer.model.CertificateStatusType? = builder.status
    /**
     * The type for the certificate. If a private key has been specified for the certificate, its type is `CERTIFICATE_WITH_PRIVATE_KEY`. If there is no private key, the type is `CERTIFICATE`.
     */
    public val type: aws.sdk.kotlin.services.transfer.model.CertificateType? = builder.type
    /**
     * Specifies whether this certificate is used for signing or encryption.
     */
    public val usage: aws.sdk.kotlin.services.transfer.model.CertificateUsageType? = builder.usage

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.transfer.model.ListedCertificate = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListedCertificate(")
        append("activeDate=$activeDate,")
        append("arn=$arn,")
        append("certificateId=$certificateId,")
        append("description=$description,")
        append("inactiveDate=$inactiveDate,")
        append("status=$status,")
        append("type=$type,")
        append("usage=$usage)")
    }

    override fun hashCode(): kotlin.Int {
        var result = activeDate?.hashCode() ?: 0
        result = 31 * result + (arn?.hashCode() ?: 0)
        result = 31 * result + (certificateId?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (inactiveDate?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        result = 31 * result + (usage?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListedCertificate

        if (activeDate != other.activeDate) return false
        if (arn != other.arn) return false
        if (certificateId != other.certificateId) return false
        if (description != other.description) return false
        if (inactiveDate != other.inactiveDate) return false
        if (status != other.status) return false
        if (type != other.type) return false
        if (usage != other.usage) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.transfer.model.ListedCertificate = Builder(this).apply(block).build()

    public class Builder {
        /**
         * An optional date that specifies when the certificate becomes active.
         */
        public var activeDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Amazon Resource Name (ARN) of the specified certificate.
         */
        public var arn: kotlin.String? = null
        /**
         * An array of identifiers for the imported certificates. You use this identifier for working with profiles and partner profiles.
         */
        public var certificateId: kotlin.String? = null
        /**
         * The name or short description that's used to identify the certificate.
         */
        public var description: kotlin.String? = null
        /**
         * An optional date that specifies when the certificate becomes inactive.
         */
        public var inactiveDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The certificate can be either `ACTIVE`, `PENDING_ROTATION`, or `INACTIVE`. `PENDING_ROTATION` means that this certificate will replace the current certificate when it expires.
         */
        public var status: aws.sdk.kotlin.services.transfer.model.CertificateStatusType? = null
        /**
         * The type for the certificate. If a private key has been specified for the certificate, its type is `CERTIFICATE_WITH_PRIVATE_KEY`. If there is no private key, the type is `CERTIFICATE`.
         */
        public var type: aws.sdk.kotlin.services.transfer.model.CertificateType? = null
        /**
         * Specifies whether this certificate is used for signing or encryption.
         */
        public var usage: aws.sdk.kotlin.services.transfer.model.CertificateUsageType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.transfer.model.ListedCertificate) : this() {
            this.activeDate = x.activeDate
            this.arn = x.arn
            this.certificateId = x.certificateId
            this.description = x.description
            this.inactiveDate = x.inactiveDate
            this.status = x.status
            this.type = x.type
            this.usage = x.usage
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.transfer.model.ListedCertificate = ListedCertificate(this)
    }
}
