// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.transfer.model



/**
 * Returns properties of a file transfer protocol-enabled server that was specified.
 */
public class ListedServer private constructor(builder: Builder) {
    /**
     * Specifies the unique Amazon Resource Name (ARN) for a server to be listed.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * Specifies the domain of the storage system that is used for file transfers.
     */
    public val domain: aws.sdk.kotlin.services.transfer.model.Domain? = builder.domain
    /**
     * Specifies the type of VPC endpoint that your server is connected to. If your server is connected to a VPC endpoint, your server isn't accessible over the public internet.
     */
    public val endpointType: aws.sdk.kotlin.services.transfer.model.EndpointType? = builder.endpointType
    /**
     * The mode of authentication for a server. The default value is `SERVICE_MANAGED`, which allows you to store and access user credentials within the Transfer Family service.
     *
     * Use `AWS_DIRECTORY_SERVICE` to provide access to Active Directory groups in Directory Service for Microsoft Active Directory or Microsoft Active Directory in your on-premises environment or in Amazon Web Services using AD Connector. This option also requires you to provide a Directory ID by using the `IdentityProviderDetails` parameter.
     *
     * Use the `API_GATEWAY` value to integrate with an identity provider of your choosing. The `API_GATEWAY` setting requires you to provide an Amazon API Gateway endpoint URL to call for authentication by using the `IdentityProviderDetails` parameter.
     *
     * Use the `AWS_LAMBDA` value to directly use an Lambda function as your identity provider. If you choose this value, you must specify the ARN for the Lambda function in the `Function` parameter or the `IdentityProviderDetails` data type.
     */
    public val identityProviderType: aws.sdk.kotlin.services.transfer.model.IdentityProviderType? = builder.identityProviderType
    /**
     * The Amazon Resource Name (ARN) of the Identity and Access Management (IAM) role that allows a server to turn on Amazon CloudWatch logging for Amazon S3 or Amazon EFSevents. When set, you can view user activity in your CloudWatch logs.
     */
    public val loggingRole: kotlin.String? = builder.loggingRole
    /**
     * Specifies the unique system assigned identifier for the servers that were listed.
     */
    public val serverId: kotlin.String? = builder.serverId
    /**
     * The condition of the server that was described. A value of `ONLINE` indicates that the server can accept jobs and transfer files. A `State` value of `OFFLINE` means that the server cannot perform file transfer operations.
     *
     * The states of `STARTING` and `STOPPING` indicate that the server is in an intermediate state, either not fully able to respond, or not fully offline. The values of `START_FAILED` or `STOP_FAILED` can indicate an error condition.
     */
    public val state: aws.sdk.kotlin.services.transfer.model.State? = builder.state
    /**
     * Specifies the number of users that are assigned to a server you specified with the `ServerId`.
     */
    public val userCount: kotlin.Int? = builder.userCount

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.transfer.model.ListedServer = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListedServer(")
        append("arn=$arn,")
        append("domain=$domain,")
        append("endpointType=$endpointType,")
        append("identityProviderType=$identityProviderType,")
        append("loggingRole=$loggingRole,")
        append("serverId=$serverId,")
        append("state=$state,")
        append("userCount=$userCount)")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (domain?.hashCode() ?: 0)
        result = 31 * result + (endpointType?.hashCode() ?: 0)
        result = 31 * result + (identityProviderType?.hashCode() ?: 0)
        result = 31 * result + (loggingRole?.hashCode() ?: 0)
        result = 31 * result + (serverId?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        result = 31 * result + (userCount ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListedServer

        if (arn != other.arn) return false
        if (domain != other.domain) return false
        if (endpointType != other.endpointType) return false
        if (identityProviderType != other.identityProviderType) return false
        if (loggingRole != other.loggingRole) return false
        if (serverId != other.serverId) return false
        if (state != other.state) return false
        if (userCount != other.userCount) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.transfer.model.ListedServer = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Specifies the unique Amazon Resource Name (ARN) for a server to be listed.
         */
        public var arn: kotlin.String? = null
        /**
         * Specifies the domain of the storage system that is used for file transfers.
         */
        public var domain: aws.sdk.kotlin.services.transfer.model.Domain? = null
        /**
         * Specifies the type of VPC endpoint that your server is connected to. If your server is connected to a VPC endpoint, your server isn't accessible over the public internet.
         */
        public var endpointType: aws.sdk.kotlin.services.transfer.model.EndpointType? = null
        /**
         * The mode of authentication for a server. The default value is `SERVICE_MANAGED`, which allows you to store and access user credentials within the Transfer Family service.
         *
         * Use `AWS_DIRECTORY_SERVICE` to provide access to Active Directory groups in Directory Service for Microsoft Active Directory or Microsoft Active Directory in your on-premises environment or in Amazon Web Services using AD Connector. This option also requires you to provide a Directory ID by using the `IdentityProviderDetails` parameter.
         *
         * Use the `API_GATEWAY` value to integrate with an identity provider of your choosing. The `API_GATEWAY` setting requires you to provide an Amazon API Gateway endpoint URL to call for authentication by using the `IdentityProviderDetails` parameter.
         *
         * Use the `AWS_LAMBDA` value to directly use an Lambda function as your identity provider. If you choose this value, you must specify the ARN for the Lambda function in the `Function` parameter or the `IdentityProviderDetails` data type.
         */
        public var identityProviderType: aws.sdk.kotlin.services.transfer.model.IdentityProviderType? = null
        /**
         * The Amazon Resource Name (ARN) of the Identity and Access Management (IAM) role that allows a server to turn on Amazon CloudWatch logging for Amazon S3 or Amazon EFSevents. When set, you can view user activity in your CloudWatch logs.
         */
        public var loggingRole: kotlin.String? = null
        /**
         * Specifies the unique system assigned identifier for the servers that were listed.
         */
        public var serverId: kotlin.String? = null
        /**
         * The condition of the server that was described. A value of `ONLINE` indicates that the server can accept jobs and transfer files. A `State` value of `OFFLINE` means that the server cannot perform file transfer operations.
         *
         * The states of `STARTING` and `STOPPING` indicate that the server is in an intermediate state, either not fully able to respond, or not fully offline. The values of `START_FAILED` or `STOP_FAILED` can indicate an error condition.
         */
        public var state: aws.sdk.kotlin.services.transfer.model.State? = null
        /**
         * Specifies the number of users that are assigned to a server you specified with the `ServerId`.
         */
        public var userCount: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.transfer.model.ListedServer) : this() {
            this.arn = x.arn
            this.domain = x.domain
            this.endpointType = x.endpointType
            this.identityProviderType = x.identityProviderType
            this.loggingRole = x.loggingRole
            this.serverId = x.serverId
            this.state = x.state
            this.userCount = x.userCount
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.transfer.model.ListedServer = ListedServer(this)
    }
}
