// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.transfer.model



/**
 * Returns properties of the user that you specify.
 */
public class ListedUser private constructor(builder: Builder) {
    /**
     * Provides the unique Amazon Resource Name (ARN) for the user that you want to learn about.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The landing directory (folder) for a user when they log in to the server using the client.
     *
     * A `HomeDirectory` example is `/bucket_name/home/mydirectory`.
     */
    public val homeDirectory: kotlin.String? = builder.homeDirectory
    /**
     * The type of landing directory (folder) that you want your users' home directory to be when they log in to the server. If you set it to `PATH`, the user will see the absolute Amazon S3 bucket or EFS paths as is in their file transfer protocol clients. If you set it `LOGICAL`, you need to provide mappings in the `HomeDirectoryMappings` for how you want to make Amazon S3 or Amazon EFS paths visible to your users.
     */
    public val homeDirectoryType: aws.sdk.kotlin.services.transfer.model.HomeDirectoryType? = builder.homeDirectoryType
    /**
     * The Amazon Resource Name (ARN) of the Identity and Access Management (IAM) role that controls your users' access to your Amazon S3 bucket or Amazon EFS file system. The policies attached to this role determine the level of access that you want to provide your users when transferring files into and out of your Amazon S3 bucket or Amazon EFS file system. The IAM role should also contain a trust relationship that allows the server to access your resources when servicing your users' transfer requests.
     *
     * The IAM role that controls your users' access to your Amazon S3 bucket for servers with `Domain=S3`, or your EFS file system for servers with `Domain=EFS`.
     *
     * The policies attached to this role determine the level of access you want to provide your users when transferring files into and out of your S3 buckets or EFS file systems.
     */
    public val role: kotlin.String? = builder.role
    /**
     * Specifies the number of SSH public keys stored for the user you specified.
     */
    public val sshPublicKeyCount: kotlin.Int? = builder.sshPublicKeyCount
    /**
     * Specifies the name of the user whose ARN was specified. User names are used for authentication purposes.
     */
    public val userName: kotlin.String? = builder.userName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.transfer.model.ListedUser = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListedUser(")
        append("arn=$arn,")
        append("homeDirectory=$homeDirectory,")
        append("homeDirectoryType=$homeDirectoryType,")
        append("role=$role,")
        append("sshPublicKeyCount=$sshPublicKeyCount,")
        append("userName=$userName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (homeDirectory?.hashCode() ?: 0)
        result = 31 * result + (homeDirectoryType?.hashCode() ?: 0)
        result = 31 * result + (role?.hashCode() ?: 0)
        result = 31 * result + (sshPublicKeyCount ?: 0)
        result = 31 * result + (userName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListedUser

        if (arn != other.arn) return false
        if (homeDirectory != other.homeDirectory) return false
        if (homeDirectoryType != other.homeDirectoryType) return false
        if (role != other.role) return false
        if (sshPublicKeyCount != other.sshPublicKeyCount) return false
        if (userName != other.userName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.transfer.model.ListedUser = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Provides the unique Amazon Resource Name (ARN) for the user that you want to learn about.
         */
        public var arn: kotlin.String? = null
        /**
         * The landing directory (folder) for a user when they log in to the server using the client.
         *
         * A `HomeDirectory` example is `/bucket_name/home/mydirectory`.
         */
        public var homeDirectory: kotlin.String? = null
        /**
         * The type of landing directory (folder) that you want your users' home directory to be when they log in to the server. If you set it to `PATH`, the user will see the absolute Amazon S3 bucket or EFS paths as is in their file transfer protocol clients. If you set it `LOGICAL`, you need to provide mappings in the `HomeDirectoryMappings` for how you want to make Amazon S3 or Amazon EFS paths visible to your users.
         */
        public var homeDirectoryType: aws.sdk.kotlin.services.transfer.model.HomeDirectoryType? = null
        /**
         * The Amazon Resource Name (ARN) of the Identity and Access Management (IAM) role that controls your users' access to your Amazon S3 bucket or Amazon EFS file system. The policies attached to this role determine the level of access that you want to provide your users when transferring files into and out of your Amazon S3 bucket or Amazon EFS file system. The IAM role should also contain a trust relationship that allows the server to access your resources when servicing your users' transfer requests.
         *
         * The IAM role that controls your users' access to your Amazon S3 bucket for servers with `Domain=S3`, or your EFS file system for servers with `Domain=EFS`.
         *
         * The policies attached to this role determine the level of access you want to provide your users when transferring files into and out of your S3 buckets or EFS file systems.
         */
        public var role: kotlin.String? = null
        /**
         * Specifies the number of SSH public keys stored for the user you specified.
         */
        public var sshPublicKeyCount: kotlin.Int? = null
        /**
         * Specifies the name of the user whose ARN was specified. User names are used for authentication purposes.
         */
        public var userName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.transfer.model.ListedUser) : this() {
            this.arn = x.arn
            this.homeDirectory = x.homeDirectory
            this.homeDirectoryType = x.homeDirectoryType
            this.role = x.role
            this.sshPublicKeyCount = x.sshPublicKeyCount
            this.userName = x.userName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.transfer.model.ListedUser = ListedUser(this)
    }
}
