// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.transfer.model



/**
 * The full POSIX identity, including user ID (`Uid`), group ID (`Gid`), and any secondary groups IDs (`SecondaryGids`), that controls your users' access to your Amazon EFS file systems. The POSIX permissions that are set on files and directories in your file system determine the level of access your users get when transferring files into and out of your Amazon EFS file systems.
 */
public class PosixProfile private constructor(builder: Builder) {
    /**
     * The POSIX group ID used for all EFS operations by this user.
     */
    public val gid: kotlin.Long? = builder.gid
    /**
     * The secondary POSIX group IDs used for all EFS operations by this user.
     */
    public val secondaryGids: List<Long>? = builder.secondaryGids
    /**
     * The POSIX user ID used for all EFS operations by this user.
     */
    public val uid: kotlin.Long? = builder.uid

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.transfer.model.PosixProfile = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PosixProfile(")
        append("gid=$gid,")
        append("secondaryGids=$secondaryGids,")
        append("uid=$uid)")
    }

    override fun hashCode(): kotlin.Int {
        var result = gid?.hashCode() ?: 0
        result = 31 * result + (secondaryGids?.hashCode() ?: 0)
        result = 31 * result + (uid?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PosixProfile

        if (gid != other.gid) return false
        if (secondaryGids != other.secondaryGids) return false
        if (uid != other.uid) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.transfer.model.PosixProfile = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The POSIX group ID used for all EFS operations by this user.
         */
        public var gid: kotlin.Long? = null
        /**
         * The secondary POSIX group IDs used for all EFS operations by this user.
         */
        public var secondaryGids: List<Long>? = null
        /**
         * The POSIX user ID used for all EFS operations by this user.
         */
        public var uid: kotlin.Long? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.transfer.model.PosixProfile) : this() {
            this.gid = x.gid
            this.secondaryGids = x.secondaryGids
            this.uid = x.uid
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.transfer.model.PosixProfile = PosixProfile(this)
    }
}
