// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.transfer.model



/**
 * The protocol settings that are configured for your server.
 */
public class ProtocolDetails private constructor(builder: Builder) {
    /**
     * Indicates the transport method for the AS2 messages. Currently, only HTTP is supported.
     */
    public val as2Transports: List<As2Transport>? = builder.as2Transports
    /**
     * Indicates passive mode, for FTP and FTPS protocols. Enter a single IPv4 address, such as the public IP address of a firewall, router, or load balancer. For example:
     *
     * ` aws transfer update-server --protocol-details PassiveIp=<i>0.0.0.0</i> `
     *
     * Replace ` <i>0.0.0.0</i> ` in the example above with the actual IP address you want to use.
     *
     *  If you change the `PassiveIp` value, you must stop and then restart your Transfer Family server for the change to take effect. For details on using passive mode (PASV) in a NAT environment, see [Configuring your FTPS server behind a firewall or NAT with Transfer Family](http://aws.amazon.com/blogs/storage/configuring-your-ftps-server-behind-a-firewall-or-nat-with-aws-transfer-family/).
     */
    public val passiveIp: kotlin.String? = builder.passiveIp
    /**
     * Use the `SetStatOption` to ignore the error that is generated when the client attempts to use `SETSTAT` on a file you are uploading to an S3 bucket.
     *
     * Some SFTP file transfer clients can attempt to change the attributes of remote files, including timestamp and permissions, using commands, such as `SETSTAT` when uploading the file. However, these commands are not compatible with object storage systems, such as Amazon S3. Due to this incompatibility, file uploads from these clients can result in errors even when the file is otherwise successfully uploaded.
     *
     * Set the value to `ENABLE_NO_OP` to have the Transfer Family server ignore the `SETSTAT` command, and upload files without needing to make any changes to your SFTP client. While the `SetStatOption``ENABLE_NO_OP` setting ignores the error, it does generate a log entry in Amazon CloudWatch Logs, so you can determine when the client is making a `SETSTAT` call.
     *
     * If you want to preserve the original timestamp for your file, and modify other file attributes using `SETSTAT`, you can use Amazon EFS as backend storage with Transfer Family.
     */
    public val setStatOption: aws.sdk.kotlin.services.transfer.model.SetStatOption? = builder.setStatOption
    /**
     * A property used with Transfer Family servers that use the FTPS protocol. TLS Session Resumption provides a mechanism to resume or share a negotiated secret key between the control and data connection for an FTPS session. `TlsSessionResumptionMode` determines whether or not the server resumes recent, negotiated sessions through a unique session ID. This property is available during `CreateServer` and `UpdateServer` calls. If a `TlsSessionResumptionMode` value is not specified during `CreateServer`, it is set to `ENFORCED` by default.
     * + `DISABLED`: the server does not process TLS session resumption client requests and creates a new TLS session for each request.
     * + `ENABLED`: the server processes and accepts clients that are performing TLS session resumption. The server doesn't reject client data connections that do not perform the TLS session resumption client processing.
     * + `ENFORCED`: the server processes and accepts clients that are performing TLS session resumption. The server rejects client data connections that do not perform the TLS session resumption client processing. Before you set the value to `ENFORCED`, test your clients.Not all FTPS clients perform TLS session resumption. So, if you choose to enforce TLS session resumption, you prevent any connections from FTPS clients that don't perform the protocol negotiation. To determine whether or not you can use the `ENFORCED` value, you need to test your clients.
     */
    public val tlsSessionResumptionMode: aws.sdk.kotlin.services.transfer.model.TlsSessionResumptionMode? = builder.tlsSessionResumptionMode

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.transfer.model.ProtocolDetails = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ProtocolDetails(")
        append("as2Transports=$as2Transports,")
        append("passiveIp=$passiveIp,")
        append("setStatOption=$setStatOption,")
        append("tlsSessionResumptionMode=$tlsSessionResumptionMode)")
    }

    override fun hashCode(): kotlin.Int {
        var result = as2Transports?.hashCode() ?: 0
        result = 31 * result + (passiveIp?.hashCode() ?: 0)
        result = 31 * result + (setStatOption?.hashCode() ?: 0)
        result = 31 * result + (tlsSessionResumptionMode?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ProtocolDetails

        if (as2Transports != other.as2Transports) return false
        if (passiveIp != other.passiveIp) return false
        if (setStatOption != other.setStatOption) return false
        if (tlsSessionResumptionMode != other.tlsSessionResumptionMode) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.transfer.model.ProtocolDetails = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Indicates the transport method for the AS2 messages. Currently, only HTTP is supported.
         */
        public var as2Transports: List<As2Transport>? = null
        /**
         * Indicates passive mode, for FTP and FTPS protocols. Enter a single IPv4 address, such as the public IP address of a firewall, router, or load balancer. For example:
         *
         * ` aws transfer update-server --protocol-details PassiveIp=<i>0.0.0.0</i> `
         *
         * Replace ` <i>0.0.0.0</i> ` in the example above with the actual IP address you want to use.
         *
         *  If you change the `PassiveIp` value, you must stop and then restart your Transfer Family server for the change to take effect. For details on using passive mode (PASV) in a NAT environment, see [Configuring your FTPS server behind a firewall or NAT with Transfer Family](http://aws.amazon.com/blogs/storage/configuring-your-ftps-server-behind-a-firewall-or-nat-with-aws-transfer-family/).
         */
        public var passiveIp: kotlin.String? = null
        /**
         * Use the `SetStatOption` to ignore the error that is generated when the client attempts to use `SETSTAT` on a file you are uploading to an S3 bucket.
         *
         * Some SFTP file transfer clients can attempt to change the attributes of remote files, including timestamp and permissions, using commands, such as `SETSTAT` when uploading the file. However, these commands are not compatible with object storage systems, such as Amazon S3. Due to this incompatibility, file uploads from these clients can result in errors even when the file is otherwise successfully uploaded.
         *
         * Set the value to `ENABLE_NO_OP` to have the Transfer Family server ignore the `SETSTAT` command, and upload files without needing to make any changes to your SFTP client. While the `SetStatOption``ENABLE_NO_OP` setting ignores the error, it does generate a log entry in Amazon CloudWatch Logs, so you can determine when the client is making a `SETSTAT` call.
         *
         * If you want to preserve the original timestamp for your file, and modify other file attributes using `SETSTAT`, you can use Amazon EFS as backend storage with Transfer Family.
         */
        public var setStatOption: aws.sdk.kotlin.services.transfer.model.SetStatOption? = null
        /**
         * A property used with Transfer Family servers that use the FTPS protocol. TLS Session Resumption provides a mechanism to resume or share a negotiated secret key between the control and data connection for an FTPS session. `TlsSessionResumptionMode` determines whether or not the server resumes recent, negotiated sessions through a unique session ID. This property is available during `CreateServer` and `UpdateServer` calls. If a `TlsSessionResumptionMode` value is not specified during `CreateServer`, it is set to `ENFORCED` by default.
         * + `DISABLED`: the server does not process TLS session resumption client requests and creates a new TLS session for each request.
         * + `ENABLED`: the server processes and accepts clients that are performing TLS session resumption. The server doesn't reject client data connections that do not perform the TLS session resumption client processing.
         * + `ENFORCED`: the server processes and accepts clients that are performing TLS session resumption. The server rejects client data connections that do not perform the TLS session resumption client processing. Before you set the value to `ENFORCED`, test your clients.Not all FTPS clients perform TLS session resumption. So, if you choose to enforce TLS session resumption, you prevent any connections from FTPS clients that don't perform the protocol negotiation. To determine whether or not you can use the `ENFORCED` value, you need to test your clients.
         */
        public var tlsSessionResumptionMode: aws.sdk.kotlin.services.transfer.model.TlsSessionResumptionMode? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.transfer.model.ProtocolDetails) : this() {
            this.as2Transports = x.as2Transports
            this.passiveIp = x.passiveIp
            this.setStatOption = x.setStatOption
            this.tlsSessionResumptionMode = x.tlsSessionResumptionMode
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.transfer.model.ProtocolDetails = ProtocolDetails(this)
    }
}
