// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.transfer.model



/**
 * Specifies the customer input S3 file location. If it is used inside `copyStepDetails.DestinationFileLocation`, it should be the S3 copy destination.
 *
 *  You need to provide the bucket and key. The key can represent either a path or a file. This is determined by whether or not you end the key value with the forward slash (/) character. If the final character is "/", then your file is copied to the folder, and its name does not change. If, rather, the final character is alphanumeric, your uploaded file is renamed to the path value. In this case, if a file with that name already exists, it is overwritten.
 *
 * For example, if your path is `shared-files/bob/`, your uploaded files are copied to the `shared-files/bob/`, folder. If your path is `shared-files/today`, each uploaded file is copied to the `shared-files` folder and named `today`: each upload overwrites the previous version of the *bob* file.
 */
public class S3InputFileLocation private constructor(builder: Builder) {
    /**
     * Specifies the S3 bucket for the customer input file.
     */
    public val bucket: kotlin.String? = builder.bucket
    /**
     * The name assigned to the file when it was created in Amazon S3. You use the object key to retrieve the object.
     */
    public val key: kotlin.String? = builder.key

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.transfer.model.S3InputFileLocation = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("S3InputFileLocation(")
        append("bucket=$bucket,")
        append("key=$key)")
    }

    override fun hashCode(): kotlin.Int {
        var result = bucket?.hashCode() ?: 0
        result = 31 * result + (key?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as S3InputFileLocation

        if (bucket != other.bucket) return false
        if (key != other.key) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.transfer.model.S3InputFileLocation = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Specifies the S3 bucket for the customer input file.
         */
        public var bucket: kotlin.String? = null
        /**
         * The name assigned to the file when it was created in Amazon S3. You use the object key to retrieve the object.
         */
        public var key: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.transfer.model.S3InputFileLocation) : this() {
            this.bucket = x.bucket
            this.key = x.key
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.transfer.model.S3InputFileLocation = S3InputFileLocation(this)
    }
}
