// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.transfer.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Provides information about the public Secure Shell (SSH) key that is associated with a user account for the specific file transfer protocol-enabled server (as identified by `ServerId`). The information returned includes the date the key was imported, the public key contents, and the public key ID. A user can store more than one SSH public key associated with their user name on a specific server.
 */
public class SshPublicKey private constructor(builder: Builder) {
    /**
     * Specifies the date that the public key was added to the user account.
     */
    public val dateImported: aws.smithy.kotlin.runtime.time.Instant? = builder.dateImported
    /**
     * Specifies the content of the SSH public key as specified by the `PublicKeyId`.
     *
     * Transfer Family accepts RSA, ECDSA, and ED25519 keys.
     */
    public val sshPublicKeyBody: kotlin.String? = builder.sshPublicKeyBody
    /**
     * Specifies the `SshPublicKeyId` parameter contains the identifier of the public key.
     */
    public val sshPublicKeyId: kotlin.String? = builder.sshPublicKeyId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.transfer.model.SshPublicKey = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SshPublicKey(")
        append("dateImported=$dateImported,")
        append("sshPublicKeyBody=$sshPublicKeyBody,")
        append("sshPublicKeyId=$sshPublicKeyId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = dateImported?.hashCode() ?: 0
        result = 31 * result + (sshPublicKeyBody?.hashCode() ?: 0)
        result = 31 * result + (sshPublicKeyId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SshPublicKey

        if (dateImported != other.dateImported) return false
        if (sshPublicKeyBody != other.sshPublicKeyBody) return false
        if (sshPublicKeyId != other.sshPublicKeyId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.transfer.model.SshPublicKey = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Specifies the date that the public key was added to the user account.
         */
        public var dateImported: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Specifies the content of the SSH public key as specified by the `PublicKeyId`.
         *
         * Transfer Family accepts RSA, ECDSA, and ED25519 keys.
         */
        public var sshPublicKeyBody: kotlin.String? = null
        /**
         * Specifies the `SshPublicKeyId` parameter contains the identifier of the public key.
         */
        public var sshPublicKeyId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.transfer.model.SshPublicKey) : this() {
            this.dateImported = x.dateImported
            this.sshPublicKeyBody = x.sshPublicKeyBody
            this.sshPublicKeyId = x.sshPublicKeyId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.transfer.model.SshPublicKey = SshPublicKey(this)
    }
}
