// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.transfer.model



public class UpdateConnectorRequest private constructor(builder: Builder) {
    /**
     * With AS2, you can send files by calling `StartFileTransfer` and specifying the file paths in the request parameter, `SendFilePaths`. We use the file’s parent directory (for example, for `--send-file-paths /bucket/dir/file.txt`, parent directory is `/bucket/dir/`) to temporarily store a processed AS2 message file, store the MDN when we receive them from the partner, and write a final JSON file containing relevant metadata of the transmission. So, the `AccessRole` needs to provide read and write access to the parent directory of the file location used in the `StartFileTransfer` request. Additionally, you need to provide read and write access to the parent directory of the files that you intend to send with `StartFileTransfer`.
     */
    public val accessRole: kotlin.String? = builder.accessRole
    /**
     * A structure that contains the parameters for a connector object.
     */
    public val as2Config: aws.sdk.kotlin.services.transfer.model.As2ConnectorConfig? = builder.as2Config
    /**
     * The unique identifier for the connector.
     */
    public val connectorId: kotlin.String? = builder.connectorId
    /**
     * The Amazon Resource Name (ARN) of the Identity and Access Management (IAM) role that allows a connector to turn on CloudWatch logging for Amazon S3 events. When set, you can view connector activity in your CloudWatch logs.
     */
    public val loggingRole: kotlin.String? = builder.loggingRole
    /**
     * The URL of the partner's AS2 endpoint.
     */
    public val url: kotlin.String? = builder.url

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.transfer.model.UpdateConnectorRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateConnectorRequest(")
        append("accessRole=$accessRole,")
        append("as2Config=$as2Config,")
        append("connectorId=$connectorId,")
        append("loggingRole=$loggingRole,")
        append("url=$url)")
    }

    override fun hashCode(): kotlin.Int {
        var result = accessRole?.hashCode() ?: 0
        result = 31 * result + (as2Config?.hashCode() ?: 0)
        result = 31 * result + (connectorId?.hashCode() ?: 0)
        result = 31 * result + (loggingRole?.hashCode() ?: 0)
        result = 31 * result + (url?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateConnectorRequest

        if (accessRole != other.accessRole) return false
        if (as2Config != other.as2Config) return false
        if (connectorId != other.connectorId) return false
        if (loggingRole != other.loggingRole) return false
        if (url != other.url) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.transfer.model.UpdateConnectorRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * With AS2, you can send files by calling `StartFileTransfer` and specifying the file paths in the request parameter, `SendFilePaths`. We use the file’s parent directory (for example, for `--send-file-paths /bucket/dir/file.txt`, parent directory is `/bucket/dir/`) to temporarily store a processed AS2 message file, store the MDN when we receive them from the partner, and write a final JSON file containing relevant metadata of the transmission. So, the `AccessRole` needs to provide read and write access to the parent directory of the file location used in the `StartFileTransfer` request. Additionally, you need to provide read and write access to the parent directory of the files that you intend to send with `StartFileTransfer`.
         */
        public var accessRole: kotlin.String? = null
        /**
         * A structure that contains the parameters for a connector object.
         */
        public var as2Config: aws.sdk.kotlin.services.transfer.model.As2ConnectorConfig? = null
        /**
         * The unique identifier for the connector.
         */
        public var connectorId: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the Identity and Access Management (IAM) role that allows a connector to turn on CloudWatch logging for Amazon S3 events. When set, you can view connector activity in your CloudWatch logs.
         */
        public var loggingRole: kotlin.String? = null
        /**
         * The URL of the partner's AS2 endpoint.
         */
        public var url: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.transfer.model.UpdateConnectorRequest) : this() {
            this.accessRole = x.accessRole
            this.as2Config = x.as2Config
            this.connectorId = x.connectorId
            this.loggingRole = x.loggingRole
            this.url = x.url
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.transfer.model.UpdateConnectorRequest = UpdateConnectorRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.transfer.model.As2ConnectorConfig] inside the given [block]
         */
        public fun as2Config(block: aws.sdk.kotlin.services.transfer.model.As2ConnectorConfig.Builder.() -> kotlin.Unit) {
            this.as2Config = aws.sdk.kotlin.services.transfer.model.As2ConnectorConfig.invoke(block)
        }
    }
}
