// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.transfer.model



/**
 * The basic building block of a workflow.
 */
public class WorkflowStep private constructor(builder: Builder) {
    /**
     * Details for a step that performs a file copy.
     *
     *  Consists of the following values:
     * + A description
     * + An S3 location for the destination of the file copy.
     * + A flag that indicates whether or not to overwrite an existing file of the same name. The default is `FALSE`.
     */
    public val copyStepDetails: aws.sdk.kotlin.services.transfer.model.CopyStepDetails? = builder.copyStepDetails
    /**
     * Details for a step that invokes a lambda function.
     *
     *  Consists of the lambda function name, target, and timeout (in seconds).
     */
    public val customStepDetails: aws.sdk.kotlin.services.transfer.model.CustomStepDetails? = builder.customStepDetails
    /**
     * Details for a step that deletes the file.
     */
    public val deleteStepDetails: aws.sdk.kotlin.services.transfer.model.DeleteStepDetails? = builder.deleteStepDetails
    /**
     * Details for a step that creates one or more tags.
     *
     * You specify one or more tags: each tag contains a key/value pair.
     */
    public val tagStepDetails: aws.sdk.kotlin.services.transfer.model.TagStepDetails? = builder.tagStepDetails
    /**
     * Currently, the following step types are supported.
     * + *COPY*: Copy the file to another location.
     * + *CUSTOM*: Perform a custom step with an Lambda function target.
     * + *DELETE*: Delete the file.
     * + *TAG*: Add a tag to the file.
     */
    public val type: aws.sdk.kotlin.services.transfer.model.WorkflowStepType? = builder.type

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.transfer.model.WorkflowStep = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("WorkflowStep(")
        append("copyStepDetails=$copyStepDetails,")
        append("customStepDetails=$customStepDetails,")
        append("deleteStepDetails=$deleteStepDetails,")
        append("tagStepDetails=$tagStepDetails,")
        append("type=$type)")
    }

    override fun hashCode(): kotlin.Int {
        var result = copyStepDetails?.hashCode() ?: 0
        result = 31 * result + (customStepDetails?.hashCode() ?: 0)
        result = 31 * result + (deleteStepDetails?.hashCode() ?: 0)
        result = 31 * result + (tagStepDetails?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as WorkflowStep

        if (copyStepDetails != other.copyStepDetails) return false
        if (customStepDetails != other.customStepDetails) return false
        if (deleteStepDetails != other.deleteStepDetails) return false
        if (tagStepDetails != other.tagStepDetails) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.transfer.model.WorkflowStep = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Details for a step that performs a file copy.
         *
         *  Consists of the following values:
         * + A description
         * + An S3 location for the destination of the file copy.
         * + A flag that indicates whether or not to overwrite an existing file of the same name. The default is `FALSE`.
         */
        public var copyStepDetails: aws.sdk.kotlin.services.transfer.model.CopyStepDetails? = null
        /**
         * Details for a step that invokes a lambda function.
         *
         *  Consists of the lambda function name, target, and timeout (in seconds).
         */
        public var customStepDetails: aws.sdk.kotlin.services.transfer.model.CustomStepDetails? = null
        /**
         * Details for a step that deletes the file.
         */
        public var deleteStepDetails: aws.sdk.kotlin.services.transfer.model.DeleteStepDetails? = null
        /**
         * Details for a step that creates one or more tags.
         *
         * You specify one or more tags: each tag contains a key/value pair.
         */
        public var tagStepDetails: aws.sdk.kotlin.services.transfer.model.TagStepDetails? = null
        /**
         * Currently, the following step types are supported.
         * + *COPY*: Copy the file to another location.
         * + *CUSTOM*: Perform a custom step with an Lambda function target.
         * + *DELETE*: Delete the file.
         * + *TAG*: Add a tag to the file.
         */
        public var type: aws.sdk.kotlin.services.transfer.model.WorkflowStepType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.transfer.model.WorkflowStep) : this() {
            this.copyStepDetails = x.copyStepDetails
            this.customStepDetails = x.customStepDetails
            this.deleteStepDetails = x.deleteStepDetails
            this.tagStepDetails = x.tagStepDetails
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.transfer.model.WorkflowStep = WorkflowStep(this)

        /**
         * construct an [aws.sdk.kotlin.services.transfer.model.CopyStepDetails] inside the given [block]
         */
        public fun copyStepDetails(block: aws.sdk.kotlin.services.transfer.model.CopyStepDetails.Builder.() -> kotlin.Unit) {
            this.copyStepDetails = aws.sdk.kotlin.services.transfer.model.CopyStepDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.transfer.model.CustomStepDetails] inside the given [block]
         */
        public fun customStepDetails(block: aws.sdk.kotlin.services.transfer.model.CustomStepDetails.Builder.() -> kotlin.Unit) {
            this.customStepDetails = aws.sdk.kotlin.services.transfer.model.CustomStepDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.transfer.model.DeleteStepDetails] inside the given [block]
         */
        public fun deleteStepDetails(block: aws.sdk.kotlin.services.transfer.model.DeleteStepDetails.Builder.() -> kotlin.Unit) {
            this.deleteStepDetails = aws.sdk.kotlin.services.transfer.model.DeleteStepDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.transfer.model.TagStepDetails] inside the given [block]
         */
        public fun tagStepDetails(block: aws.sdk.kotlin.services.transfer.model.TagStepDetails.Builder.() -> kotlin.Unit) {
            this.tagStepDetails = aws.sdk.kotlin.services.transfer.model.TagStepDetails.invoke(block)
        }
    }
}
