// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.transfer.paginators

import aws.sdk.kotlin.services.transfer.TransferClient
import aws.sdk.kotlin.services.transfer.model.ListAccessesRequest
import aws.sdk.kotlin.services.transfer.model.ListAccessesResponse
import aws.sdk.kotlin.services.transfer.model.ListAgreementsRequest
import aws.sdk.kotlin.services.transfer.model.ListAgreementsResponse
import aws.sdk.kotlin.services.transfer.model.ListCertificatesRequest
import aws.sdk.kotlin.services.transfer.model.ListCertificatesResponse
import aws.sdk.kotlin.services.transfer.model.ListConnectorsRequest
import aws.sdk.kotlin.services.transfer.model.ListConnectorsResponse
import aws.sdk.kotlin.services.transfer.model.ListExecutionsRequest
import aws.sdk.kotlin.services.transfer.model.ListExecutionsResponse
import aws.sdk.kotlin.services.transfer.model.ListProfilesRequest
import aws.sdk.kotlin.services.transfer.model.ListProfilesResponse
import aws.sdk.kotlin.services.transfer.model.ListSecurityPoliciesRequest
import aws.sdk.kotlin.services.transfer.model.ListSecurityPoliciesResponse
import aws.sdk.kotlin.services.transfer.model.ListServersRequest
import aws.sdk.kotlin.services.transfer.model.ListServersResponse
import aws.sdk.kotlin.services.transfer.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.transfer.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.transfer.model.ListUsersRequest
import aws.sdk.kotlin.services.transfer.model.ListUsersResponse
import aws.sdk.kotlin.services.transfer.model.ListWorkflowsRequest
import aws.sdk.kotlin.services.transfer.model.ListWorkflowsResponse
import aws.sdk.kotlin.services.transfer.model.ListedAccess
import aws.sdk.kotlin.services.transfer.model.ListedAgreement
import aws.sdk.kotlin.services.transfer.model.ListedCertificate
import aws.sdk.kotlin.services.transfer.model.ListedConnector
import aws.sdk.kotlin.services.transfer.model.ListedExecution
import aws.sdk.kotlin.services.transfer.model.ListedProfile
import aws.sdk.kotlin.services.transfer.model.ListedServer
import aws.sdk.kotlin.services.transfer.model.ListedUser
import aws.sdk.kotlin.services.transfer.model.ListedWorkflow
import aws.sdk.kotlin.services.transfer.model.Tag
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [ListAccessesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListAccessesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAccessesResponse]
 */
public fun TransferClient.listAccessesPaginated(initialRequest: ListAccessesRequest): Flow<ListAccessesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listAccessesPaginated.listAccesses(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListAccessesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAccessesResponse]
 */
public fun TransferClient.listAccessesPaginated(block: ListAccessesRequest.Builder.() -> Unit): Flow<ListAccessesResponse> =
    listAccessesPaginated(ListAccessesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listAccessesPaginated]
 * to access the nested member [ListedAccess]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListedAccess]
 */
@JvmName("listAccessesResponseListedAccess")
public fun Flow<ListAccessesResponse>.accesses(): Flow<ListedAccess> =
    transform() { response ->
        response.accesses?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListAgreementsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListAgreementsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAgreementsResponse]
 */
public fun TransferClient.listAgreementsPaginated(initialRequest: ListAgreementsRequest): Flow<ListAgreementsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listAgreementsPaginated.listAgreements(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListAgreementsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAgreementsResponse]
 */
public fun TransferClient.listAgreementsPaginated(block: ListAgreementsRequest.Builder.() -> Unit): Flow<ListAgreementsResponse> =
    listAgreementsPaginated(ListAgreementsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listAgreementsPaginated]
 * to access the nested member [ListedAgreement]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListedAgreement]
 */
@JvmName("listAgreementsResponseListedAgreement")
public fun Flow<ListAgreementsResponse>.agreements(): Flow<ListedAgreement> =
    transform() { response ->
        response.agreements?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListCertificatesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListCertificatesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListCertificatesResponse]
 */
public fun TransferClient.listCertificatesPaginated(initialRequest: ListCertificatesRequest): Flow<ListCertificatesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listCertificatesPaginated.listCertificates(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListCertificatesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListCertificatesResponse]
 */
public fun TransferClient.listCertificatesPaginated(block: ListCertificatesRequest.Builder.() -> Unit): Flow<ListCertificatesResponse> =
    listCertificatesPaginated(ListCertificatesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listCertificatesPaginated]
 * to access the nested member [ListedCertificate]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListedCertificate]
 */
@JvmName("listCertificatesResponseListedCertificate")
public fun Flow<ListCertificatesResponse>.certificates(): Flow<ListedCertificate> =
    transform() { response ->
        response.certificates?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListConnectorsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListConnectorsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListConnectorsResponse]
 */
public fun TransferClient.listConnectorsPaginated(initialRequest: ListConnectorsRequest): Flow<ListConnectorsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listConnectorsPaginated.listConnectors(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListConnectorsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListConnectorsResponse]
 */
public fun TransferClient.listConnectorsPaginated(block: ListConnectorsRequest.Builder.() -> Unit): Flow<ListConnectorsResponse> =
    listConnectorsPaginated(ListConnectorsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listConnectorsPaginated]
 * to access the nested member [ListedConnector]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListedConnector]
 */
@JvmName("listConnectorsResponseListedConnector")
public fun Flow<ListConnectorsResponse>.connectors(): Flow<ListedConnector> =
    transform() { response ->
        response.connectors?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListExecutionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListExecutionsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListExecutionsResponse]
 */
public fun TransferClient.listExecutionsPaginated(initialRequest: ListExecutionsRequest): Flow<ListExecutionsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listExecutionsPaginated.listExecutions(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListExecutionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListExecutionsResponse]
 */
public fun TransferClient.listExecutionsPaginated(block: ListExecutionsRequest.Builder.() -> Unit): Flow<ListExecutionsResponse> =
    listExecutionsPaginated(ListExecutionsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listExecutionsPaginated]
 * to access the nested member [ListedExecution]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListedExecution]
 */
@JvmName("listExecutionsResponseListedExecution")
public fun Flow<ListExecutionsResponse>.executions(): Flow<ListedExecution> =
    transform() { response ->
        response.executions?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListProfilesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListProfilesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListProfilesResponse]
 */
public fun TransferClient.listProfilesPaginated(initialRequest: ListProfilesRequest): Flow<ListProfilesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listProfilesPaginated.listProfiles(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListProfilesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListProfilesResponse]
 */
public fun TransferClient.listProfilesPaginated(block: ListProfilesRequest.Builder.() -> Unit): Flow<ListProfilesResponse> =
    listProfilesPaginated(ListProfilesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listProfilesPaginated]
 * to access the nested member [ListedProfile]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListedProfile]
 */
@JvmName("listProfilesResponseListedProfile")
public fun Flow<ListProfilesResponse>.profiles(): Flow<ListedProfile> =
    transform() { response ->
        response.profiles?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListSecurityPoliciesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListSecurityPoliciesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListSecurityPoliciesResponse]
 */
public fun TransferClient.listSecurityPoliciesPaginated(initialRequest: ListSecurityPoliciesRequest): Flow<ListSecurityPoliciesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listSecurityPoliciesPaginated.listSecurityPolicies(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListSecurityPoliciesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListSecurityPoliciesResponse]
 */
public fun TransferClient.listSecurityPoliciesPaginated(block: ListSecurityPoliciesRequest.Builder.() -> Unit): Flow<ListSecurityPoliciesResponse> =
    listSecurityPoliciesPaginated(ListSecurityPoliciesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listSecurityPoliciesPaginated]
 * to access the nested member [SecurityPolicyName]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [SecurityPolicyName]
 */
@JvmName("listSecurityPoliciesResponseSecurityPolicyName")
public fun Flow<ListSecurityPoliciesResponse>.securityPolicyNames(): Flow<String> =
    transform() { response ->
        response.securityPolicyNames?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListServersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListServersRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListServersResponse]
 */
public fun TransferClient.listServersPaginated(initialRequest: ListServersRequest): Flow<ListServersResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listServersPaginated.listServers(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListServersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListServersResponse]
 */
public fun TransferClient.listServersPaginated(block: ListServersRequest.Builder.() -> Unit): Flow<ListServersResponse> =
    listServersPaginated(ListServersRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listServersPaginated]
 * to access the nested member [ListedServer]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListedServer]
 */
@JvmName("listServersResponseListedServer")
public fun Flow<ListServersResponse>.servers(): Flow<ListedServer> =
    transform() { response ->
        response.servers?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListTagsForResourceResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListTagsForResourceRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTagsForResourceResponse]
 */
public fun TransferClient.listTagsForResourcePaginated(initialRequest: ListTagsForResourceRequest): Flow<ListTagsForResourceResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listTagsForResourcePaginated.listTagsForResource(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListTagsForResourceResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTagsForResourceResponse]
 */
public fun TransferClient.listTagsForResourcePaginated(block: ListTagsForResourceRequest.Builder.() -> Unit): Flow<ListTagsForResourceResponse> =
    listTagsForResourcePaginated(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listTagsForResourcePaginated]
 * to access the nested member [Tag]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Tag]
 */
@JvmName("listTagsForResourceResponseTag")
public fun Flow<ListTagsForResourceResponse>.tags(): Flow<Tag> =
    transform() { response ->
        response.tags?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListUsersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListUsersRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListUsersResponse]
 */
public fun TransferClient.listUsersPaginated(initialRequest: ListUsersRequest): Flow<ListUsersResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listUsersPaginated.listUsers(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListUsersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListUsersResponse]
 */
public fun TransferClient.listUsersPaginated(block: ListUsersRequest.Builder.() -> Unit): Flow<ListUsersResponse> =
    listUsersPaginated(ListUsersRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listUsersPaginated]
 * to access the nested member [ListedUser]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListedUser]
 */
@JvmName("listUsersResponseListedUser")
public fun Flow<ListUsersResponse>.users(): Flow<ListedUser> =
    transform() { response ->
        response.users?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListWorkflowsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListWorkflowsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListWorkflowsResponse]
 */
public fun TransferClient.listWorkflowsPaginated(initialRequest: ListWorkflowsRequest): Flow<ListWorkflowsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listWorkflowsPaginated.listWorkflows(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListWorkflowsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListWorkflowsResponse]
 */
public fun TransferClient.listWorkflowsPaginated(block: ListWorkflowsRequest.Builder.() -> Unit): Flow<ListWorkflowsResponse> =
    listWorkflowsPaginated(ListWorkflowsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listWorkflowsPaginated]
 * to access the nested member [ListedWorkflow]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListedWorkflow]
 */
@JvmName("listWorkflowsResponseListedWorkflow")
public fun Flow<ListWorkflowsResponse>.workflows(): Flow<ListedWorkflow> =
    transform() { response ->
        response.workflows?.forEach {
            emit(it)
        }
    }
