// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.transfer.transform

import aws.sdk.kotlin.services.transfer.model.As2ConnectorConfig
import aws.sdk.kotlin.services.transfer.model.CreateConnectorRequest
import aws.sdk.kotlin.services.transfer.model.Tag
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateConnectorOperationSerializer: HttpSerialize<CreateConnectorRequest> {
    override suspend fun serialize(context: ExecutionContext, input: CreateConnectorRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path = "/"
        }

        val payload = serializeCreateConnectorOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/x-amz-json-1.1")
        }
        return builder
    }
}

private fun serializeCreateConnectorOperationBody(context: ExecutionContext, input: CreateConnectorRequest): ByteArray {
    val serializer = JsonSerializer()
    val ACCESSROLE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("AccessRole"))
    val AS2CONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("As2Config"))
    val LOGGINGROLE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("LoggingRole"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Tags"))
    val URL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Url"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ACCESSROLE_DESCRIPTOR)
        field(AS2CONFIG_DESCRIPTOR)
        field(LOGGINGROLE_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
        field(URL_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.accessRole?.let { field(ACCESSROLE_DESCRIPTOR, it) }
        input.as2Config?.let { field(AS2CONFIG_DESCRIPTOR, it, ::serializeAs2ConnectorConfigDocument) }
        input.loggingRole?.let { field(LOGGINGROLE_DESCRIPTOR, it) }
        if (input.tags != null) {
            listField(TAGS_DESCRIPTOR) {
                for (el0 in input.tags) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeTagDocument))
                }
            }
        }
        input.url?.let { field(URL_DESCRIPTOR, it) }
    }
    return serializer.toByteArray()
}
