// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.transfer.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.transfer.model.ListExecutionsResponse
import aws.sdk.kotlin.services.transfer.model.ListedExecution
import aws.sdk.kotlin.services.transfer.model.TransferException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class ListExecutionsOperationDeserializer: HttpDeserialize<ListExecutionsResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): ListExecutionsResponse {
        if (!response.status.isSuccess()) {
            throwListExecutionsError(context, response)
        }
        val builder = ListExecutionsResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeListExecutionsOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwListExecutionsError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw TransferException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalServiceError" -> InternalServiceErrorDeserializer().deserialize(context, wrappedResponse)
        "InvalidNextTokenException" -> InvalidNextTokenExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ServiceUnavailableException" -> ServiceUnavailableExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> TransferException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeListExecutionsOperationBody(builder: ListExecutionsResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val EXECUTIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Executions"))
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("NextToken"))
    val WORKFLOWID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("WorkflowId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(EXECUTIONS_DESCRIPTOR)
        field(NEXTTOKEN_DESCRIPTOR)
        field(WORKFLOWID_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                EXECUTIONS_DESCRIPTOR.index -> builder.executions =
                    deserializer.deserializeList(EXECUTIONS_DESCRIPTOR) {
                        val col0 = mutableListOf<ListedExecution>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeListedExecutionDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                NEXTTOKEN_DESCRIPTOR.index -> builder.nextToken = deserializeString()
                WORKFLOWID_DESCRIPTOR.index -> builder.workflowId = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
