// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.transfer.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.transfer.model.TransferException
import aws.sdk.kotlin.services.transfer.model.UpdateAgreementResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class UpdateAgreementOperationDeserializer: HttpDeserialize<UpdateAgreementResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): UpdateAgreementResponse {
        if (!response.status.isSuccess()) {
            throwUpdateAgreementError(context, response)
        }
        val builder = UpdateAgreementResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeUpdateAgreementOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwUpdateAgreementError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw TransferException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalServiceError" -> InternalServiceErrorDeserializer().deserialize(context, wrappedResponse)
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceExistsException" -> ResourceExistsExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ServiceUnavailableException" -> ServiceUnavailableExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> TransferException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeUpdateAgreementOperationBody(builder: UpdateAgreementResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val AGREEMENTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("AgreementId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(AGREEMENTID_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                AGREEMENTID_DESCRIPTOR.index -> builder.agreementId = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
