// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.transfer.transform

import aws.sdk.kotlin.services.transfer.model.EndpointDetails
import aws.sdk.kotlin.services.transfer.model.EndpointType
import aws.sdk.kotlin.services.transfer.model.IdentityProviderDetails
import aws.sdk.kotlin.services.transfer.model.Protocol
import aws.sdk.kotlin.services.transfer.model.ProtocolDetails
import aws.sdk.kotlin.services.transfer.model.UpdateServerRequest
import aws.sdk.kotlin.services.transfer.model.WorkflowDetails
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class UpdateServerOperationSerializer: HttpSerialize<UpdateServerRequest> {
    override suspend fun serialize(context: ExecutionContext, input: UpdateServerRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path = "/"
        }

        val payload = serializeUpdateServerOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/x-amz-json-1.1")
        }
        return builder
    }
}

private fun serializeUpdateServerOperationBody(context: ExecutionContext, input: UpdateServerRequest): ByteArray {
    val serializer = JsonSerializer()
    val CERTIFICATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Certificate"))
    val ENDPOINTDETAILS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("EndpointDetails"))
    val ENDPOINTTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("EndpointType"))
    val HOSTKEY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("HostKey"))
    val IDENTITYPROVIDERDETAILS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("IdentityProviderDetails"))
    val LOGGINGROLE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("LoggingRole"))
    val POSTAUTHENTICATIONLOGINBANNER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("PostAuthenticationLoginBanner"))
    val PREAUTHENTICATIONLOGINBANNER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("PreAuthenticationLoginBanner"))
    val PROTOCOLDETAILS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ProtocolDetails"))
    val PROTOCOLS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Protocols"))
    val SECURITYPOLICYNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("SecurityPolicyName"))
    val SERVERID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ServerId"))
    val WORKFLOWDETAILS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("WorkflowDetails"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CERTIFICATE_DESCRIPTOR)
        field(ENDPOINTDETAILS_DESCRIPTOR)
        field(ENDPOINTTYPE_DESCRIPTOR)
        field(HOSTKEY_DESCRIPTOR)
        field(IDENTITYPROVIDERDETAILS_DESCRIPTOR)
        field(LOGGINGROLE_DESCRIPTOR)
        field(POSTAUTHENTICATIONLOGINBANNER_DESCRIPTOR)
        field(PREAUTHENTICATIONLOGINBANNER_DESCRIPTOR)
        field(PROTOCOLDETAILS_DESCRIPTOR)
        field(PROTOCOLS_DESCRIPTOR)
        field(SECURITYPOLICYNAME_DESCRIPTOR)
        field(SERVERID_DESCRIPTOR)
        field(WORKFLOWDETAILS_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.certificate?.let { field(CERTIFICATE_DESCRIPTOR, it) }
        input.endpointDetails?.let { field(ENDPOINTDETAILS_DESCRIPTOR, it, ::serializeEndpointDetailsDocument) }
        input.endpointType?.let { field(ENDPOINTTYPE_DESCRIPTOR, it.value) }
        input.hostKey?.let { field(HOSTKEY_DESCRIPTOR, it) }
        input.identityProviderDetails?.let { field(IDENTITYPROVIDERDETAILS_DESCRIPTOR, it, ::serializeIdentityProviderDetailsDocument) }
        input.loggingRole?.let { field(LOGGINGROLE_DESCRIPTOR, it) }
        input.postAuthenticationLoginBanner?.let { field(POSTAUTHENTICATIONLOGINBANNER_DESCRIPTOR, it) }
        input.preAuthenticationLoginBanner?.let { field(PREAUTHENTICATIONLOGINBANNER_DESCRIPTOR, it) }
        input.protocolDetails?.let { field(PROTOCOLDETAILS_DESCRIPTOR, it, ::serializeProtocolDetailsDocument) }
        if (input.protocols != null) {
            listField(PROTOCOLS_DESCRIPTOR) {
                for (el0 in input.protocols) {
                    serializeString(el0.value)
                }
            }
        }
        input.securityPolicyName?.let { field(SECURITYPOLICYNAME_DESCRIPTOR, it) }
        input.serverId?.let { field(SERVERID_DESCRIPTOR, it) }
        input.workflowDetails?.let { field(WORKFLOWDETAILS_DESCRIPTOR, it, ::serializeWorkflowDetailsDocument) }
    }
    return serializer.toByteArray()
}
