// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.transfer.waiters

import aws.sdk.kotlin.services.transfer.TransferClient
import aws.sdk.kotlin.services.transfer.model.DescribeServerRequest
import aws.sdk.kotlin.services.transfer.model.DescribeServerResponse
import aws.smithy.kotlin.runtime.retries.Outcome
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategyOptions
import aws.smithy.kotlin.runtime.retries.delay.ExponentialBackoffWithJitter
import aws.smithy.kotlin.runtime.retries.delay.ExponentialBackoffWithJitterOptions
import aws.smithy.kotlin.runtime.retries.delay.InfiniteTokenBucket
import aws.smithy.kotlin.runtime.retries.policy.Acceptor
import aws.smithy.kotlin.runtime.retries.policy.AcceptorRetryPolicy
import aws.smithy.kotlin.runtime.retries.policy.OutputAcceptor
import aws.smithy.kotlin.runtime.retries.policy.RetryDirective
import kotlin.time.Duration.Companion.milliseconds


public suspend fun TransferClient.waitUntilServerOffline(request: DescribeServerRequest): Outcome<DescribeServerResponse> {
    val strategy = run {
        val delayOptions = ExponentialBackoffWithJitterOptions(
            initialDelay = 30_000.milliseconds,
            scaleFactor = 1.5,
            jitter = 1.0,
            maxBackoff = 120_000.milliseconds,
        )
        val delay = ExponentialBackoffWithJitter(delayOptions)

        val waiterOptions = StandardRetryStrategyOptions(maxAttempts = 20)
        StandardRetryStrategy(waiterOptions, InfiniteTokenBucket, delay)
    }

    val acceptors = listOf<Acceptor<DescribeServerRequest, DescribeServerResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val server = it?.server
            val state = server?.state
            state?.toString() == "OFFLINE"
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val server = it?.server
            val state = server?.state
            state?.toString() == "STOP_FAILED"
        },
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeServer(request) }
}

public suspend fun TransferClient.waitUntilServerOffline(block: DescribeServerRequest.Builder.() -> Unit): Outcome<DescribeServerResponse> =
    waitUntilServerOffline(DescribeServerRequest.Builder().apply(block).build())

public suspend fun TransferClient.waitUntilServerOnline(request: DescribeServerRequest): Outcome<DescribeServerResponse> {
    val strategy = run {
        val delayOptions = ExponentialBackoffWithJitterOptions(
            initialDelay = 30_000.milliseconds,
            scaleFactor = 1.5,
            jitter = 1.0,
            maxBackoff = 120_000.milliseconds,
        )
        val delay = ExponentialBackoffWithJitter(delayOptions)

        val waiterOptions = StandardRetryStrategyOptions(maxAttempts = 20)
        StandardRetryStrategy(waiterOptions, InfiniteTokenBucket, delay)
    }

    val acceptors = listOf<Acceptor<DescribeServerRequest, DescribeServerResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val server = it?.server
            val state = server?.state
            state?.toString() == "ONLINE"
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val server = it?.server
            val state = server?.state
            state?.toString() == "START_FAILED"
        },
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeServer(request) }
}

public suspend fun TransferClient.waitUntilServerOnline(block: DescribeServerRequest.Builder.() -> Unit): Outcome<DescribeServerResponse> =
    waitUntilServerOnline(DescribeServerRequest.Builder().apply(block).build())
