// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.transfer.model



class CreateServerRequest private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the Amazon Web Services Certificate Manager (ACM) certificate. Required
     * when Protocols is set to FTPS.
     * To request a new public certificate, see <a href="https://docs.aws.amazon.com/acm/latest/userguide/gs-acm-request-public.html">Request a public certificate
     * in the  Amazon Web Services Certificate Manager User Guide.
     * To import an existing certificate into ACM, see <a href="https://docs.aws.amazon.com/acm/latest/userguide/import-certificate.html">Importing certificates into ACM
     * in the  Amazon Web Services Certificate Manager User Guide.
     * To request a private certificate to use FTPS through private IP addresses, see <a href="https://docs.aws.amazon.com/acm/latest/userguide/gs-acm-request-private.html">Request a
     * private certificate in the  Amazon Web Services Certificate Manager User
     * Guide.
     * Certificates with the following cryptographic algorithms and key sizes are
     * supported:
     * 2048-bit RSA (RSA_2048)
     * 4096-bit RSA (RSA_4096)
     * Elliptic Prime Curve 256 bit (EC_prime256v1)
     * Elliptic Prime Curve 384 bit (EC_secp384r1)
     * Elliptic Prime Curve 521 bit (EC_secp521r1)
     * The certificate must be a valid SSL/TLS X.509 version 3 certificate with FQDN or IP
     * address specified and information about the issuer.
     */
    val certificate: kotlin.String? = builder.certificate
    /**
     * The domain of the storage system that is used for file transfers. There are two domains
     * available: Amazon Simple Storage Service (Amazon S3) and Amazon Elastic File System (Amazon EFS). The
     * default value is S3.
     * After the server is created, the domain cannot be changed.
     */
    val domain: aws.sdk.kotlin.services.transfer.model.Domain? = builder.domain
    /**
     * The virtual private cloud (VPC) endpoint settings that are configured for your server.
     * When you host your endpoint within your VPC, you can make it accessible only to resources
     * within your VPC, or you can attach Elastic IP addresses and make it accessible to clients over
     * the internet. Your VPC's default security groups are automatically assigned to your
     * endpoint.
     */
    val endpointDetails: aws.sdk.kotlin.services.transfer.model.EndpointDetails? = builder.endpointDetails
    /**
     * The type of endpoint that you want your server to use. You can choose to make your server's endpoint publicly accessible (PUBLIC)
     * or host it inside your VPC. With an endpoint that is hosted in a VPC, you can restrict access to your server and
     * resources only within your VPC or choose to make it internet facing by attaching Elastic IP addresses directly to it.
     * After May 19, 2021, you won't be able to create a server using
     * EndpointType=VPC_ENDPOINT in your Amazon Web Services account if your account hasn't already
     * done so before May 19, 2021. If you have already created servers with
     * EndpointType=VPC_ENDPOINT in your Amazon Web Services account on or before May 19, 2021,
     * you will not be affected. After this date, use
     * EndpointType=VPC.
     * For more information, see
     * https://docs.aws.amazon.com/transfer/latest/userguide/create-server-in-vpc.html#deprecate-vpc-endpoint.
     * It is recommended that you use VPC as the EndpointType. With
     * this endpoint type, you have the option to directly associate up to three Elastic IPv4
     * addresses (BYO IP included) with your server's endpoint and use VPC security groups to
     * restrict traffic by the client's public IP address. This is not possible with
     * EndpointType set to VPC_ENDPOINT.
     */
    val endpointType: aws.sdk.kotlin.services.transfer.model.EndpointType? = builder.endpointType
    /**
     * The RSA private key as generated by the ssh-keygen -N "" -m PEM -f
     * my-new-server-key command.
     * If you aren't planning to migrate existing users from an existing SFTP-enabled
     * server to a new server, don't update the host key. Accidentally changing a
     * server's host key can be disruptive.
     * For more information, see <a href="https://docs.aws.amazon.com/transfer/latest/userguide/edit-server-config.html#configuring-servers-change-host-key">Change the host key for your SFTP-enabled server in the Amazon Web Services Transfer
     * Family User Guide.
     */
    val hostKey: kotlin.String? = builder.hostKey
    /**
     * Required when IdentityProviderType is set to
     * AWS_DIRECTORY_SERVICE or API_GATEWAY. Accepts an array containing
     * all of the information required to use a directory in AWS_DIRECTORY_SERVICE or
     * invoke a customer-supplied authentication API, including the API Gateway URL. Not required
     * when IdentityProviderType is set to SERVICE_MANAGED.
     */
    val identityProviderDetails: aws.sdk.kotlin.services.transfer.model.IdentityProviderDetails? = builder.identityProviderDetails
    /**
     * Specifies the mode of authentication for a server. The default value is
     * SERVICE_MANAGED, which allows you to store and access user credentials within
     * the Amazon Web Services Transfer Family service.
     * Use AWS_DIRECTORY_SERVICE to provide access to
     * Active Directory groups in Amazon Web Services Managed Active Directory or Microsoft Active Directory in your
     * on-premises environment or in Amazon Web Services using AD Connectors. This option also requires you to
     * provide a Directory ID using the IdentityProviderDetails parameter.
     * Use the API_GATEWAY value to integrate with an identity provider of your choosing. The
     * API_GATEWAY setting requires you to provide an API Gateway endpoint URL to call
     * for authentication using the IdentityProviderDetails parameter.
     * Use the AWS_LAMBDA value to directly use a Lambda function as your identity provider. If you choose this value,
     * you must specify the ARN for the lambda function in the Function parameter for the IdentityProviderDetails data type.
     */
    val identityProviderType: aws.sdk.kotlin.services.transfer.model.IdentityProviderType? = builder.identityProviderType
    /**
     * Specifies the Amazon Resource Name (ARN) of the Amazon Web Services Identity and Access Management (IAM) role that allows a server to turn
     * on Amazon CloudWatch logging for Amazon S3 or Amazon EFS events. When set, user activity can be viewed in
     * your CloudWatch logs.
     */
    val loggingRole: kotlin.String? = builder.loggingRole
    /**
     * The protocol settings that are configured for your server.
     * Use the PassiveIp parameter to indicate passive mode (for FTP and FTPS protocols).
     * Enter a single dotted-quad IPv4 address, such as the external IP address of a firewall, router, or load balancer.
     * Use the TlsSessionResumptionMode parameter to determine whether or not your Transfer server
     * resumes recent, negotiated sessions through a unique session ID.
     */
    val protocolDetails: aws.sdk.kotlin.services.transfer.model.ProtocolDetails? = builder.protocolDetails
    /**
     * Specifies the file transfer protocol or protocols over which your file transfer protocol
     * client can connect to your server's endpoint. The available protocols are:
     * SFTP (Secure Shell (SSH) File Transfer Protocol): File transfer over
     * SSH
     * FTPS (File Transfer Protocol Secure): File transfer with TLS
     * encryption
     * FTP (File Transfer Protocol): Unencrypted file transfer
     * If you select FTPS, you must choose a certificate stored in Amazon Web Services Certificate
     * Manager (ACM) which is used to identify your server when clients connect to it over
     * FTPS.
     * If Protocol includes either FTP or FTPS, then the
     * EndpointType must be VPC and the
     * IdentityProviderType must be AWS_DIRECTORY_SERVICE or API_GATEWAY.
     * If Protocol includes FTP, then
     * AddressAllocationIds cannot be associated.
     * If Protocol is set only to SFTP, the EndpointType
     * can be set to PUBLIC and the IdentityProviderType can be set to
     * SERVICE_MANAGED.
     */
    val protocols: List<Protocol>? = builder.protocols
    /**
     * Specifies the name of the security policy that is attached to the server.
     */
    val securityPolicyName: kotlin.String? = builder.securityPolicyName
    /**
     * Key-value pairs that can be used to group and search for servers.
     */
    val tags: List<Tag>? = builder.tags
    /**
     * Specifies the workflow ID for the workflow to assign and the execution role used for executing the workflow.
     */
    val workflowDetails: aws.sdk.kotlin.services.transfer.model.WorkflowDetails? = builder.workflowDetails

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.transfer.model.CreateServerRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateServerRequest(")
        append("certificate=$certificate,")
        append("domain=$domain,")
        append("endpointDetails=$endpointDetails,")
        append("endpointType=$endpointType,")
        append("hostKey=*** Sensitive Data Redacted ***,")
        append("identityProviderDetails=$identityProviderDetails,")
        append("identityProviderType=$identityProviderType,")
        append("loggingRole=$loggingRole,")
        append("protocolDetails=$protocolDetails,")
        append("protocols=$protocols,")
        append("securityPolicyName=$securityPolicyName,")
        append("tags=$tags,")
        append("workflowDetails=$workflowDetails)")
    }

    override fun hashCode(): kotlin.Int {
        var result = certificate?.hashCode() ?: 0
        result = 31 * result + (domain?.hashCode() ?: 0)
        result = 31 * result + (endpointDetails?.hashCode() ?: 0)
        result = 31 * result + (endpointType?.hashCode() ?: 0)
        result = 31 * result + (hostKey?.hashCode() ?: 0)
        result = 31 * result + (identityProviderDetails?.hashCode() ?: 0)
        result = 31 * result + (identityProviderType?.hashCode() ?: 0)
        result = 31 * result + (loggingRole?.hashCode() ?: 0)
        result = 31 * result + (protocolDetails?.hashCode() ?: 0)
        result = 31 * result + (protocols?.hashCode() ?: 0)
        result = 31 * result + (securityPolicyName?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (workflowDetails?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateServerRequest

        if (certificate != other.certificate) return false
        if (domain != other.domain) return false
        if (endpointDetails != other.endpointDetails) return false
        if (endpointType != other.endpointType) return false
        if (hostKey != other.hostKey) return false
        if (identityProviderDetails != other.identityProviderDetails) return false
        if (identityProviderType != other.identityProviderType) return false
        if (loggingRole != other.loggingRole) return false
        if (protocolDetails != other.protocolDetails) return false
        if (protocols != other.protocols) return false
        if (securityPolicyName != other.securityPolicyName) return false
        if (tags != other.tags) return false
        if (workflowDetails != other.workflowDetails) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.transfer.model.CreateServerRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The Amazon Resource Name (ARN) of the Amazon Web Services Certificate Manager (ACM) certificate. Required
         * when Protocols is set to FTPS.
         * To request a new public certificate, see <a href="https://docs.aws.amazon.com/acm/latest/userguide/gs-acm-request-public.html">Request a public certificate
         * in the  Amazon Web Services Certificate Manager User Guide.
         * To import an existing certificate into ACM, see <a href="https://docs.aws.amazon.com/acm/latest/userguide/import-certificate.html">Importing certificates into ACM
         * in the  Amazon Web Services Certificate Manager User Guide.
         * To request a private certificate to use FTPS through private IP addresses, see <a href="https://docs.aws.amazon.com/acm/latest/userguide/gs-acm-request-private.html">Request a
         * private certificate in the  Amazon Web Services Certificate Manager User
         * Guide.
         * Certificates with the following cryptographic algorithms and key sizes are
         * supported:
         * 2048-bit RSA (RSA_2048)
         * 4096-bit RSA (RSA_4096)
         * Elliptic Prime Curve 256 bit (EC_prime256v1)
         * Elliptic Prime Curve 384 bit (EC_secp384r1)
         * Elliptic Prime Curve 521 bit (EC_secp521r1)
         * The certificate must be a valid SSL/TLS X.509 version 3 certificate with FQDN or IP
         * address specified and information about the issuer.
         */
        var certificate: kotlin.String? = null
        /**
         * The domain of the storage system that is used for file transfers. There are two domains
         * available: Amazon Simple Storage Service (Amazon S3) and Amazon Elastic File System (Amazon EFS). The
         * default value is S3.
         * After the server is created, the domain cannot be changed.
         */
        var domain: aws.sdk.kotlin.services.transfer.model.Domain? = null
        /**
         * The virtual private cloud (VPC) endpoint settings that are configured for your server.
         * When you host your endpoint within your VPC, you can make it accessible only to resources
         * within your VPC, or you can attach Elastic IP addresses and make it accessible to clients over
         * the internet. Your VPC's default security groups are automatically assigned to your
         * endpoint.
         */
        var endpointDetails: aws.sdk.kotlin.services.transfer.model.EndpointDetails? = null
        /**
         * The type of endpoint that you want your server to use. You can choose to make your server's endpoint publicly accessible (PUBLIC)
         * or host it inside your VPC. With an endpoint that is hosted in a VPC, you can restrict access to your server and
         * resources only within your VPC or choose to make it internet facing by attaching Elastic IP addresses directly to it.
         * After May 19, 2021, you won't be able to create a server using
         * EndpointType=VPC_ENDPOINT in your Amazon Web Services account if your account hasn't already
         * done so before May 19, 2021. If you have already created servers with
         * EndpointType=VPC_ENDPOINT in your Amazon Web Services account on or before May 19, 2021,
         * you will not be affected. After this date, use
         * EndpointType=VPC.
         * For more information, see
         * https://docs.aws.amazon.com/transfer/latest/userguide/create-server-in-vpc.html#deprecate-vpc-endpoint.
         * It is recommended that you use VPC as the EndpointType. With
         * this endpoint type, you have the option to directly associate up to three Elastic IPv4
         * addresses (BYO IP included) with your server's endpoint and use VPC security groups to
         * restrict traffic by the client's public IP address. This is not possible with
         * EndpointType set to VPC_ENDPOINT.
         */
        var endpointType: aws.sdk.kotlin.services.transfer.model.EndpointType? = null
        /**
         * The RSA private key as generated by the ssh-keygen -N "" -m PEM -f
         * my-new-server-key command.
         * If you aren't planning to migrate existing users from an existing SFTP-enabled
         * server to a new server, don't update the host key. Accidentally changing a
         * server's host key can be disruptive.
         * For more information, see <a href="https://docs.aws.amazon.com/transfer/latest/userguide/edit-server-config.html#configuring-servers-change-host-key">Change the host key for your SFTP-enabled server in the Amazon Web Services Transfer
         * Family User Guide.
         */
        var hostKey: kotlin.String? = null
        /**
         * Required when IdentityProviderType is set to
         * AWS_DIRECTORY_SERVICE or API_GATEWAY. Accepts an array containing
         * all of the information required to use a directory in AWS_DIRECTORY_SERVICE or
         * invoke a customer-supplied authentication API, including the API Gateway URL. Not required
         * when IdentityProviderType is set to SERVICE_MANAGED.
         */
        var identityProviderDetails: aws.sdk.kotlin.services.transfer.model.IdentityProviderDetails? = null
        /**
         * Specifies the mode of authentication for a server. The default value is
         * SERVICE_MANAGED, which allows you to store and access user credentials within
         * the Amazon Web Services Transfer Family service.
         * Use AWS_DIRECTORY_SERVICE to provide access to
         * Active Directory groups in Amazon Web Services Managed Active Directory or Microsoft Active Directory in your
         * on-premises environment or in Amazon Web Services using AD Connectors. This option also requires you to
         * provide a Directory ID using the IdentityProviderDetails parameter.
         * Use the API_GATEWAY value to integrate with an identity provider of your choosing. The
         * API_GATEWAY setting requires you to provide an API Gateway endpoint URL to call
         * for authentication using the IdentityProviderDetails parameter.
         * Use the AWS_LAMBDA value to directly use a Lambda function as your identity provider. If you choose this value,
         * you must specify the ARN for the lambda function in the Function parameter for the IdentityProviderDetails data type.
         */
        var identityProviderType: aws.sdk.kotlin.services.transfer.model.IdentityProviderType? = null
        /**
         * Specifies the Amazon Resource Name (ARN) of the Amazon Web Services Identity and Access Management (IAM) role that allows a server to turn
         * on Amazon CloudWatch logging for Amazon S3 or Amazon EFS events. When set, user activity can be viewed in
         * your CloudWatch logs.
         */
        var loggingRole: kotlin.String? = null
        /**
         * The protocol settings that are configured for your server.
         * Use the PassiveIp parameter to indicate passive mode (for FTP and FTPS protocols).
         * Enter a single dotted-quad IPv4 address, such as the external IP address of a firewall, router, or load balancer.
         * Use the TlsSessionResumptionMode parameter to determine whether or not your Transfer server
         * resumes recent, negotiated sessions through a unique session ID.
         */
        var protocolDetails: aws.sdk.kotlin.services.transfer.model.ProtocolDetails? = null
        /**
         * Specifies the file transfer protocol or protocols over which your file transfer protocol
         * client can connect to your server's endpoint. The available protocols are:
         * SFTP (Secure Shell (SSH) File Transfer Protocol): File transfer over
         * SSH
         * FTPS (File Transfer Protocol Secure): File transfer with TLS
         * encryption
         * FTP (File Transfer Protocol): Unencrypted file transfer
         * If you select FTPS, you must choose a certificate stored in Amazon Web Services Certificate
         * Manager (ACM) which is used to identify your server when clients connect to it over
         * FTPS.
         * If Protocol includes either FTP or FTPS, then the
         * EndpointType must be VPC and the
         * IdentityProviderType must be AWS_DIRECTORY_SERVICE or API_GATEWAY.
         * If Protocol includes FTP, then
         * AddressAllocationIds cannot be associated.
         * If Protocol is set only to SFTP, the EndpointType
         * can be set to PUBLIC and the IdentityProviderType can be set to
         * SERVICE_MANAGED.
         */
        var protocols: List<Protocol>? = null
        /**
         * Specifies the name of the security policy that is attached to the server.
         */
        var securityPolicyName: kotlin.String? = null
        /**
         * Key-value pairs that can be used to group and search for servers.
         */
        var tags: List<Tag>? = null
        /**
         * Specifies the workflow ID for the workflow to assign and the execution role used for executing the workflow.
         */
        var workflowDetails: aws.sdk.kotlin.services.transfer.model.WorkflowDetails? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.transfer.model.CreateServerRequest) : this() {
            this.certificate = x.certificate
            this.domain = x.domain
            this.endpointDetails = x.endpointDetails
            this.endpointType = x.endpointType
            this.hostKey = x.hostKey
            this.identityProviderDetails = x.identityProviderDetails
            this.identityProviderType = x.identityProviderType
            this.loggingRole = x.loggingRole
            this.protocolDetails = x.protocolDetails
            this.protocols = x.protocols
            this.securityPolicyName = x.securityPolicyName
            this.tags = x.tags
            this.workflowDetails = x.workflowDetails
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.transfer.model.CreateServerRequest = CreateServerRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.transfer.model.EndpointDetails] inside the given [block]
         */
        fun endpointDetails(block: aws.sdk.kotlin.services.transfer.model.EndpointDetails.Builder.() -> kotlin.Unit) {
            this.endpointDetails = aws.sdk.kotlin.services.transfer.model.EndpointDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.transfer.model.IdentityProviderDetails] inside the given [block]
         */
        fun identityProviderDetails(block: aws.sdk.kotlin.services.transfer.model.IdentityProviderDetails.Builder.() -> kotlin.Unit) {
            this.identityProviderDetails = aws.sdk.kotlin.services.transfer.model.IdentityProviderDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.transfer.model.ProtocolDetails] inside the given [block]
         */
        fun protocolDetails(block: aws.sdk.kotlin.services.transfer.model.ProtocolDetails.Builder.() -> kotlin.Unit) {
            this.protocolDetails = aws.sdk.kotlin.services.transfer.model.ProtocolDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.transfer.model.WorkflowDetails] inside the given [block]
         */
        fun workflowDetails(block: aws.sdk.kotlin.services.transfer.model.WorkflowDetails.Builder.() -> kotlin.Unit) {
            this.workflowDetails = aws.sdk.kotlin.services.transfer.model.WorkflowDetails.invoke(block)
        }
    }
}
