// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.transfer.model



class CreateWorkflowRequest private constructor(builder: Builder) {
    /**
     * A textual description for the workflow.
     */
    val description: kotlin.String? = builder.description
    /**
     * Specifies the steps (actions) to take if errors are encountered during execution of the workflow.
     * For custom steps, the lambda function needs to send FAILURE to the call
     * back API to kick off the exception steps. Additionally, if the lambda does not send
     * SUCCESS before it times out, the exception steps are executed.
     */
    val onExceptionSteps: List<WorkflowStep>? = builder.onExceptionSteps
    /**
     * Specifies the details for the steps that are in the specified workflow.
     * The TYPE specifies which of the following actions is being taken for this step.
     * Copy: copy the file to another location
     * Custom: custom step with a lambda target
     * Delete: delete the file
     * Tag: add a tag to the file
     * Currently, copying and tagging are supported only on S3.
     * For file location, you specify either the S3 bucket and key, or the EFS filesystem ID and path.
     */
    val steps: List<WorkflowStep>? = builder.steps
    /**
     * Key-value pairs that can be used to group and search for workflows. Tags are metadata attached
     * to workflows for any purpose.
     */
    val tags: List<Tag>? = builder.tags

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.transfer.model.CreateWorkflowRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateWorkflowRequest(")
        append("description=$description,")
        append("onExceptionSteps=$onExceptionSteps,")
        append("steps=$steps,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = description?.hashCode() ?: 0
        result = 31 * result + (onExceptionSteps?.hashCode() ?: 0)
        result = 31 * result + (steps?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateWorkflowRequest

        if (description != other.description) return false
        if (onExceptionSteps != other.onExceptionSteps) return false
        if (steps != other.steps) return false
        if (tags != other.tags) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.transfer.model.CreateWorkflowRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * A textual description for the workflow.
         */
        var description: kotlin.String? = null
        /**
         * Specifies the steps (actions) to take if errors are encountered during execution of the workflow.
         * For custom steps, the lambda function needs to send FAILURE to the call
         * back API to kick off the exception steps. Additionally, if the lambda does not send
         * SUCCESS before it times out, the exception steps are executed.
         */
        var onExceptionSteps: List<WorkflowStep>? = null
        /**
         * Specifies the details for the steps that are in the specified workflow.
         * The TYPE specifies which of the following actions is being taken for this step.
         * Copy: copy the file to another location
         * Custom: custom step with a lambda target
         * Delete: delete the file
         * Tag: add a tag to the file
         * Currently, copying and tagging are supported only on S3.
         * For file location, you specify either the S3 bucket and key, or the EFS filesystem ID and path.
         */
        var steps: List<WorkflowStep>? = null
        /**
         * Key-value pairs that can be used to group and search for workflows. Tags are metadata attached
         * to workflows for any purpose.
         */
        var tags: List<Tag>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.transfer.model.CreateWorkflowRequest) : this() {
            this.description = x.description
            this.onExceptionSteps = x.onExceptionSteps
            this.steps = x.steps
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.transfer.model.CreateWorkflowRequest = CreateWorkflowRequest(this)
    }
}
