// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.transfer.model



/**
 * Represents an object that contains entries and targets for
 * HomeDirectoryMappings.
 * The following is an Entry and Target pair example for chroot.
 * &#91; { "Entry:": "/", "Target": "/bucket_name/home/mydirectory" } &#93;
 * If the target of a logical directory entry does not exist in Amazon S3 or EFS, the entry is
 * ignored. As a workaround, you can use the Amazon S3 API or EFS API to create 0 byte objects as place
 * holders for your directory. If using the CLI, use the s3api or efsapi call instead of
 * s3 or efs so you can use the put-object operation. For example, you use the
 * following: aws s3api put-object --bucket bucketname --key path/to/folder/. Make
 * sure that the end of the key name ends in a / for it to be considered a folder.
 */
class HomeDirectoryMapEntry private constructor(builder: Builder) {
    /**
     * Represents an entry for HomeDirectoryMappings.
     */
    val entry: kotlin.String? = builder.entry
    /**
     * Represents the map target that is used in a HomeDirectorymapEntry.
     */
    val target: kotlin.String? = builder.target

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.transfer.model.HomeDirectoryMapEntry = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("HomeDirectoryMapEntry(")
        append("entry=$entry,")
        append("target=$target)")
    }

    override fun hashCode(): kotlin.Int {
        var result = entry?.hashCode() ?: 0
        result = 31 * result + (target?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as HomeDirectoryMapEntry

        if (entry != other.entry) return false
        if (target != other.target) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.transfer.model.HomeDirectoryMapEntry = Builder(this).apply(block).build()

    class Builder {
        /**
         * Represents an entry for HomeDirectoryMappings.
         */
        var entry: kotlin.String? = null
        /**
         * Represents the map target that is used in a HomeDirectorymapEntry.
         */
        var target: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.transfer.model.HomeDirectoryMapEntry) : this() {
            this.entry = x.entry
            this.target = x.target
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.transfer.model.HomeDirectoryMapEntry = HomeDirectoryMapEntry(this)
    }
}
