// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.transfer.model



class ListTagsForResourceRequest private constructor(builder: Builder) {
    /**
     * Requests the tags associated with a particular Amazon Resource Name (ARN). An ARN is an
     * identifier for a specific Amazon Web Services resource, such as a server, user, or role.
     */
    val arn: kotlin.String? = builder.arn
    /**
     * Specifies the number of tags to return as a response to the
     * ListTagsForResource request.
     */
    val maxResults: kotlin.Int? = builder.maxResults
    /**
     * When you request additional results from the ListTagsForResource operation, a
     * NextToken parameter is returned in the input. You can then pass in a subsequent
     * command to the NextToken parameter to continue listing additional tags.
     */
    val nextToken: kotlin.String? = builder.nextToken

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.transfer.model.ListTagsForResourceRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListTagsForResourceRequest(")
        append("arn=$arn,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken)")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListTagsForResourceRequest

        if (arn != other.arn) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.transfer.model.ListTagsForResourceRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * Requests the tags associated with a particular Amazon Resource Name (ARN). An ARN is an
         * identifier for a specific Amazon Web Services resource, such as a server, user, or role.
         */
        var arn: kotlin.String? = null
        /**
         * Specifies the number of tags to return as a response to the
         * ListTagsForResource request.
         */
        var maxResults: kotlin.Int? = null
        /**
         * When you request additional results from the ListTagsForResource operation, a
         * NextToken parameter is returned in the input. You can then pass in a subsequent
         * command to the NextToken parameter to continue listing additional tags.
         */
        var nextToken: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.transfer.model.ListTagsForResourceRequest) : this() {
            this.arn = x.arn
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.transfer.model.ListTagsForResourceRequest = ListTagsForResourceRequest(this)
    }
}
