// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.transfer.model



/**
 * Returns properties of the user that you specify.
 */
class ListedUser private constructor(builder: Builder) {
    /**
     * Provides the unique Amazon Resource Name (ARN) for the user that you want to learn
     * about.
     */
    val arn: kotlin.String? = builder.arn
    /**
     * The landing directory (folder) for a user when they log in to the server using the client.
     * A HomeDirectory example is /bucket_name/home/mydirectory.
     */
    val homeDirectory: kotlin.String? = builder.homeDirectory
    /**
     * The type of landing directory (folder) you want your users' home directory to be when they log into the server.
     * If you set it to PATH, the user will see the absolute Amazon S3 bucket or EFS paths as is in their file transfer protocol clients.
     * If you set it LOGICAL, you need to provide mappings in the HomeDirectoryMappings for how you want to make Amazon
     * S3 or EFS paths visible to your users.
     */
    val homeDirectoryType: aws.sdk.kotlin.services.transfer.model.HomeDirectoryType? = builder.homeDirectoryType
    /**
     * Specifies the Amazon Resource Name (ARN) of the IAM role that controls your users' access to your Amazon S3 bucket or EFS
     * file system. The policies attached to this role determine the level of access that you want to provide your users when transferring
     * files into and out of your Amazon S3 bucket or EFS file system. The IAM role should also contain a trust relationship that allows the
     * server to access your resources when servicing your users' transfer requests.
     * The IAM role that controls your users' access to your Amazon S3 bucket for servers with Domain=S3, or your EFS file system for servers with Domain=EFS.
     * The policies attached to this role determine the level of access you want to provide your users when
     * transferring files into and out of your S3 buckets or EFS file systems.
     */
    val role: kotlin.String? = builder.role
    /**
     * Specifies the number of SSH public keys stored for the user you specified.
     */
    val sshPublicKeyCount: kotlin.Int? = builder.sshPublicKeyCount
    /**
     * Specifies the name of the user whose ARN was specified. User names are used for
     * authentication purposes.
     */
    val userName: kotlin.String? = builder.userName

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.transfer.model.ListedUser = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListedUser(")
        append("arn=$arn,")
        append("homeDirectory=$homeDirectory,")
        append("homeDirectoryType=$homeDirectoryType,")
        append("role=$role,")
        append("sshPublicKeyCount=$sshPublicKeyCount,")
        append("userName=$userName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (homeDirectory?.hashCode() ?: 0)
        result = 31 * result + (homeDirectoryType?.hashCode() ?: 0)
        result = 31 * result + (role?.hashCode() ?: 0)
        result = 31 * result + (sshPublicKeyCount ?: 0)
        result = 31 * result + (userName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListedUser

        if (arn != other.arn) return false
        if (homeDirectory != other.homeDirectory) return false
        if (homeDirectoryType != other.homeDirectoryType) return false
        if (role != other.role) return false
        if (sshPublicKeyCount != other.sshPublicKeyCount) return false
        if (userName != other.userName) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.transfer.model.ListedUser = Builder(this).apply(block).build()

    class Builder {
        /**
         * Provides the unique Amazon Resource Name (ARN) for the user that you want to learn
         * about.
         */
        var arn: kotlin.String? = null
        /**
         * The landing directory (folder) for a user when they log in to the server using the client.
         * A HomeDirectory example is /bucket_name/home/mydirectory.
         */
        var homeDirectory: kotlin.String? = null
        /**
         * The type of landing directory (folder) you want your users' home directory to be when they log into the server.
         * If you set it to PATH, the user will see the absolute Amazon S3 bucket or EFS paths as is in their file transfer protocol clients.
         * If you set it LOGICAL, you need to provide mappings in the HomeDirectoryMappings for how you want to make Amazon
         * S3 or EFS paths visible to your users.
         */
        var homeDirectoryType: aws.sdk.kotlin.services.transfer.model.HomeDirectoryType? = null
        /**
         * Specifies the Amazon Resource Name (ARN) of the IAM role that controls your users' access to your Amazon S3 bucket or EFS
         * file system. The policies attached to this role determine the level of access that you want to provide your users when transferring
         * files into and out of your Amazon S3 bucket or EFS file system. The IAM role should also contain a trust relationship that allows the
         * server to access your resources when servicing your users' transfer requests.
         * The IAM role that controls your users' access to your Amazon S3 bucket for servers with Domain=S3, or your EFS file system for servers with Domain=EFS.
         * The policies attached to this role determine the level of access you want to provide your users when
         * transferring files into and out of your S3 buckets or EFS file systems.
         */
        var role: kotlin.String? = null
        /**
         * Specifies the number of SSH public keys stored for the user you specified.
         */
        var sshPublicKeyCount: kotlin.Int? = null
        /**
         * Specifies the name of the user whose ARN was specified. User names are used for
         * authentication purposes.
         */
        var userName: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.transfer.model.ListedUser) : this() {
            this.arn = x.arn
            this.homeDirectory = x.homeDirectory
            this.homeDirectoryType = x.homeDirectoryType
            this.role = x.role
            this.sshPublicKeyCount = x.sshPublicKeyCount
            this.userName = x.userName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.transfer.model.ListedUser = ListedUser(this)
    }
}
