// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.transfer.model



/**
 * The protocol settings that are configured for your server.
 */
class ProtocolDetails private constructor(builder: Builder) {
    /**
     * Indicates passive mode, for FTP and FTPS protocols.
     * Enter a single dotted-quad IPv4 address, such as the external IP address of a firewall, router, or load balancer.
     * For example:
     * aws transfer update-server --protocol-details PassiveIp=0.0.0.0
     * Replace
     * 0.0.0.0
     * in the example above with the actual IP address you want to use.
     * If you change the PassiveIp value, you must stop and then restart your Transfer server for the change to take effect. For details on using Passive IP (PASV) in a NAT environment, see <a href="http://aws.amazon.com/blogs/storage/configuring-your-ftps-server-behind-a-firewall-or-nat-with-aws-transfer-family/">Configuring your FTPS server behind a firewall or NAT with Amazon Web Services Transfer Family.
     */
    val passiveIp: kotlin.String? = builder.passiveIp
    /**
     * A property used with Transfer servers that use the FTPS protocol. TLS Session Resumption provides a mechanism to resume or share a negotiated secret
     * key between the control and data connection for an FTPS session. TlsSessionResumptionMode determines whether or not the server resumes recent,
     * negotiated sessions through a unique session ID. This property is available during CreateServer and UpdateServer calls.
     * If a TlsSessionResumptionMode value is not specified during CreateServer, it is set to ENFORCED by default.
     * DISABLED: the server does not process TLS session resumption client requests and creates a new TLS session for each request.
     * ENABLED: the server processes and accepts clients that are performing TLS session resumption.
     * The server doesn't reject client data connections that do not perform the TLS session resumption client processing.
     * ENFORCED: the server processes and accepts clients that are performing TLS session resumption.
     * The server rejects client data connections that do not perform the TLS session resumption client processing.
     * Before you set the value to ENFORCED, test your clients.
     * Not all FTPS clients perform TLS session resumption. So, if you choose to enforce
     * TLS session resumption, you prevent any connections from FTPS clients that don't perform
     * the protocol negotiation. To determine whether or not you can use the
     * ENFORCED value, you need to test your clients.
     */
    val tlsSessionResumptionMode: aws.sdk.kotlin.services.transfer.model.TlsSessionResumptionMode? = builder.tlsSessionResumptionMode

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.transfer.model.ProtocolDetails = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ProtocolDetails(")
        append("passiveIp=$passiveIp,")
        append("tlsSessionResumptionMode=$tlsSessionResumptionMode)")
    }

    override fun hashCode(): kotlin.Int {
        var result = passiveIp?.hashCode() ?: 0
        result = 31 * result + (tlsSessionResumptionMode?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ProtocolDetails

        if (passiveIp != other.passiveIp) return false
        if (tlsSessionResumptionMode != other.tlsSessionResumptionMode) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.transfer.model.ProtocolDetails = Builder(this).apply(block).build()

    class Builder {
        /**
         * Indicates passive mode, for FTP and FTPS protocols.
         * Enter a single dotted-quad IPv4 address, such as the external IP address of a firewall, router, or load balancer.
         * For example:
         * aws transfer update-server --protocol-details PassiveIp=0.0.0.0
         * Replace
         * 0.0.0.0
         * in the example above with the actual IP address you want to use.
         * If you change the PassiveIp value, you must stop and then restart your Transfer server for the change to take effect. For details on using Passive IP (PASV) in a NAT environment, see <a href="http://aws.amazon.com/blogs/storage/configuring-your-ftps-server-behind-a-firewall-or-nat-with-aws-transfer-family/">Configuring your FTPS server behind a firewall or NAT with Amazon Web Services Transfer Family.
         */
        var passiveIp: kotlin.String? = null
        /**
         * A property used with Transfer servers that use the FTPS protocol. TLS Session Resumption provides a mechanism to resume or share a negotiated secret
         * key between the control and data connection for an FTPS session. TlsSessionResumptionMode determines whether or not the server resumes recent,
         * negotiated sessions through a unique session ID. This property is available during CreateServer and UpdateServer calls.
         * If a TlsSessionResumptionMode value is not specified during CreateServer, it is set to ENFORCED by default.
         * DISABLED: the server does not process TLS session resumption client requests and creates a new TLS session for each request.
         * ENABLED: the server processes and accepts clients that are performing TLS session resumption.
         * The server doesn't reject client data connections that do not perform the TLS session resumption client processing.
         * ENFORCED: the server processes and accepts clients that are performing TLS session resumption.
         * The server rejects client data connections that do not perform the TLS session resumption client processing.
         * Before you set the value to ENFORCED, test your clients.
         * Not all FTPS clients perform TLS session resumption. So, if you choose to enforce
         * TLS session resumption, you prevent any connections from FTPS clients that don't perform
         * the protocol negotiation. To determine whether or not you can use the
         * ENFORCED value, you need to test your clients.
         */
        var tlsSessionResumptionMode: aws.sdk.kotlin.services.transfer.model.TlsSessionResumptionMode? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.transfer.model.ProtocolDetails) : this() {
            this.passiveIp = x.passiveIp
            this.tlsSessionResumptionMode = x.tlsSessionResumptionMode
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.transfer.model.ProtocolDetails = ProtocolDetails(this)
    }
}
