// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.transfer.paginators

import aws.sdk.kotlin.services.transfer.TransferClient
import aws.sdk.kotlin.services.transfer.model.ListAccessesRequest
import aws.sdk.kotlin.services.transfer.model.ListAccessesResponse
import aws.sdk.kotlin.services.transfer.model.ListExecutionsRequest
import aws.sdk.kotlin.services.transfer.model.ListExecutionsResponse
import aws.sdk.kotlin.services.transfer.model.ListSecurityPoliciesRequest
import aws.sdk.kotlin.services.transfer.model.ListSecurityPoliciesResponse
import aws.sdk.kotlin.services.transfer.model.ListServersRequest
import aws.sdk.kotlin.services.transfer.model.ListServersResponse
import aws.sdk.kotlin.services.transfer.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.transfer.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.transfer.model.ListUsersRequest
import aws.sdk.kotlin.services.transfer.model.ListUsersResponse
import aws.sdk.kotlin.services.transfer.model.ListWorkflowsRequest
import aws.sdk.kotlin.services.transfer.model.ListWorkflowsResponse
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow


/**
 * Paginate over [ListAccessesResponse] results.
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service calls are
 * made until the flow is collected. This also means there is no guarantee that the request is valid until then. Once
 * you start collecting the flow, the SDK will lazily load response pages by making service calls until there are no
 * pages left or the flow is cancelled. If there are errors in your request, you will see the failures only after you start
 * collection.
 * @param initialRequest A [ListAccessesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAccessesResponse]
 */
fun TransferClient.listAccessesPaginated(initialRequest: ListAccessesRequest): Flow<ListAccessesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listAccessesPaginated.listAccesses(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListExecutionsResponse] results.
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service calls are
 * made until the flow is collected. This also means there is no guarantee that the request is valid until then. Once
 * you start collecting the flow, the SDK will lazily load response pages by making service calls until there are no
 * pages left or the flow is cancelled. If there are errors in your request, you will see the failures only after you start
 * collection.
 * @param initialRequest A [ListExecutionsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListExecutionsResponse]
 */
fun TransferClient.listExecutionsPaginated(initialRequest: ListExecutionsRequest): Flow<ListExecutionsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listExecutionsPaginated.listExecutions(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListSecurityPoliciesResponse] results.
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service calls are
 * made until the flow is collected. This also means there is no guarantee that the request is valid until then. Once
 * you start collecting the flow, the SDK will lazily load response pages by making service calls until there are no
 * pages left or the flow is cancelled. If there are errors in your request, you will see the failures only after you start
 * collection.
 * @param initialRequest A [ListSecurityPoliciesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListSecurityPoliciesResponse]
 */
fun TransferClient.listSecurityPoliciesPaginated(initialRequest: ListSecurityPoliciesRequest): Flow<ListSecurityPoliciesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listSecurityPoliciesPaginated.listSecurityPolicies(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListServersResponse] results.
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service calls are
 * made until the flow is collected. This also means there is no guarantee that the request is valid until then. Once
 * you start collecting the flow, the SDK will lazily load response pages by making service calls until there are no
 * pages left or the flow is cancelled. If there are errors in your request, you will see the failures only after you start
 * collection.
 * @param initialRequest A [ListServersRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListServersResponse]
 */
fun TransferClient.listServersPaginated(initialRequest: ListServersRequest): Flow<ListServersResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listServersPaginated.listServers(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListTagsForResourceResponse] results.
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service calls are
 * made until the flow is collected. This also means there is no guarantee that the request is valid until then. Once
 * you start collecting the flow, the SDK will lazily load response pages by making service calls until there are no
 * pages left or the flow is cancelled. If there are errors in your request, you will see the failures only after you start
 * collection.
 * @param initialRequest A [ListTagsForResourceRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTagsForResourceResponse]
 */
fun TransferClient.listTagsForResourcePaginated(initialRequest: ListTagsForResourceRequest): Flow<ListTagsForResourceResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listTagsForResourcePaginated.listTagsForResource(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListUsersResponse] results.
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service calls are
 * made until the flow is collected. This also means there is no guarantee that the request is valid until then. Once
 * you start collecting the flow, the SDK will lazily load response pages by making service calls until there are no
 * pages left or the flow is cancelled. If there are errors in your request, you will see the failures only after you start
 * collection.
 * @param initialRequest A [ListUsersRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListUsersResponse]
 */
fun TransferClient.listUsersPaginated(initialRequest: ListUsersRequest): Flow<ListUsersResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listUsersPaginated.listUsers(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListWorkflowsResponse] results.
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service calls are
 * made until the flow is collected. This also means there is no guarantee that the request is valid until then. Once
 * you start collecting the flow, the SDK will lazily load response pages by making service calls until there are no
 * pages left or the flow is cancelled. If there are errors in your request, you will see the failures only after you start
 * collection.
 * @param initialRequest A [ListWorkflowsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListWorkflowsResponse]
 */
fun TransferClient.listWorkflowsPaginated(initialRequest: ListWorkflowsRequest): Flow<ListWorkflowsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listWorkflowsPaginated.listWorkflows(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }
