// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.transfer.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.transfer.model.ListAccessesResponse
import aws.sdk.kotlin.services.transfer.model.ListedAccess
import aws.sdk.kotlin.services.transfer.model.TransferException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class ListAccessesOperationDeserializer: HttpDeserialize<ListAccessesResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): ListAccessesResponse {
        if (!response.status.isSuccess()) {
            throwListAccessesError(context, response)
        }
        val builder = ListAccessesResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeListAccessesOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private fun deserializeListAccessesOperationBody(builder: ListAccessesResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ACCESSES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Accesses"))
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("NextToken"))
    val SERVERID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ServerId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ACCESSES_DESCRIPTOR)
        field(NEXTTOKEN_DESCRIPTOR)
        field(SERVERID_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ACCESSES_DESCRIPTOR.index -> builder.accesses =
                    deserializer.deserializeList(ACCESSES_DESCRIPTOR) {
                        val col0 = mutableListOf<ListedAccess>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeListedAccessDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                NEXTTOKEN_DESCRIPTOR.index -> builder.nextToken = deserializeString()
                SERVERID_DESCRIPTOR.index -> builder.serverId = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}

private suspend fun throwListAccessesError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw TransferException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val modeledExceptionDeserializer = when(errorDetails.code) {
        "InternalServiceError" -> InternalServiceErrorDeserializer()
        "InvalidNextTokenException" -> InvalidNextTokenExceptionDeserializer()
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer()
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer()
        "ServiceUnavailableException" -> ServiceUnavailableExceptionDeserializer()
        else -> throw TransferException(errorDetails.message)
    }

    val modeledException = modeledExceptionDeserializer.deserialize(context, wrappedResponse)
    setAseErrorMetadata(modeledException, wrappedResponse, errorDetails)
    throw modeledException
}
