// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.transfer.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.transfer.model.TestIdentityProviderResponse
import aws.sdk.kotlin.services.transfer.model.TransferException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class TestIdentityProviderOperationDeserializer: HttpDeserialize<TestIdentityProviderResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): TestIdentityProviderResponse {
        if (!response.status.isSuccess()) {
            throwTestIdentityProviderError(context, response)
        }
        val builder = TestIdentityProviderResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeTestIdentityProviderOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private fun deserializeTestIdentityProviderOperationBody(builder: TestIdentityProviderResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val MESSAGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Message"))
    val RESPONSE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Response"))
    val STATUSCODE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("StatusCode"))
    val URL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Url"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(MESSAGE_DESCRIPTOR)
        field(RESPONSE_DESCRIPTOR)
        field(STATUSCODE_DESCRIPTOR)
        field(URL_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                MESSAGE_DESCRIPTOR.index -> builder.message = deserializeString()
                RESPONSE_DESCRIPTOR.index -> builder.response = deserializeString()
                STATUSCODE_DESCRIPTOR.index -> builder.statusCode = deserializeInt()
                URL_DESCRIPTOR.index -> builder.url = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}

private suspend fun throwTestIdentityProviderError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw TransferException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val modeledExceptionDeserializer = when(errorDetails.code) {
        "InternalServiceError" -> InternalServiceErrorDeserializer()
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer()
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer()
        "ServiceUnavailableException" -> ServiceUnavailableExceptionDeserializer()
        else -> throw TransferException(errorDetails.message)
    }

    val modeledException = modeledExceptionDeserializer.deserialize(context, wrappedResponse)
    setAseErrorMetadata(modeledException, wrappedResponse, errorDetails)
    throw modeledException
}
