// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.transfer

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.borrow
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.transfer.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.transfer.model.*
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.endpoints.EndpointResolver
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy

/**
 * Amazon Web Services Transfer Family is a fully managed service that enables the transfer of files over the File Transfer Protocol (FTP), File Transfer Protocol over SSL (FTPS), or Secure Shell (SSH) File Transfer Protocol (SFTP) directly into and out of Amazon Simple Storage Service (Amazon S3). Amazon Web Services helps you seamlessly migrate your file transfer workflows to Amazon Web Services Transfer Family by integrating with existing authentication systems, and providing DNS routing with Amazon Route 53 so nothing changes for your customers and partners, or their applications. With your data in Amazon S3, you can use it with Amazon Web Services services for processing, analytics, machine learning, and archiving. Getting started with Amazon Web Services Transfer Family is easy since there is no infrastructure to buy and set up.
 */
interface TransferClient : SdkClient {

    override val serviceName: String
        get() = "Transfer"
    /**
     * TransferClient's configuration
     */
    val config: Config

    companion object {
        operator fun invoke(block: Config.Builder.() -> Unit): TransferClient {
            val config = Config.Builder().apply(block).build()
            return DefaultTransferClient(config)
        }

        operator fun invoke(config: Config): TransferClient = DefaultTransferClient(config)

        /**
         * Construct a [TransferClient] by resolving the configuration from the current environment.
         */
        suspend fun fromEnvironment(block: (Config.Builder.() -> Unit)? = null): TransferClient {
            val builder = Config.Builder()
            if (block != null) builder.apply(block)
            builder.region = builder.region ?: resolveRegion()
            return DefaultTransferClient(builder.build())
        }
    }

    class Config private constructor(builder: Builder): HttpClientConfig, SdkClientConfig {
        val credentialsProvider: CredentialsProvider = builder.credentialsProvider?.borrow() ?: DefaultChainCredentialsProvider()
        val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        val retryStrategy: RetryStrategy = StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        val signer: AwsSigner = builder.signer ?: DefaultAwsSigner
        companion object {
            inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        class Builder {
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            var credentialsProvider: CredentialsProvider? = null
            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            var endpointResolver: AwsEndpointResolver? = null
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            var httpClientEngine: HttpClientEngine? = null
            /**
             * AWS region to make requests to
             */
            var region: String? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            var sdkLogMode: SdkLogMode = SdkLogMode.Default
            /**
             * The implementation of AWS signer to use for signing requests
             */
            var signer: AwsSigner? = null

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * Used by administrators to choose which groups in the directory should have access to upload and download files over the enabled protocols using Amazon Web Services Transfer Family. For example, a Microsoft Active Directory might contain 50,000 users, but only a small fraction might need the ability to transfer files to the server. An administrator can use `CreateAccess` to limit the access to the correct set of users who need this ability.
     */
    suspend fun createAccess(input: CreateAccessRequest): CreateAccessResponse

    /**
     * Instantiates an auto-scaling virtual server based on the selected file transfer protocol in Amazon Web Services. When you make updates to your file transfer protocol-enabled server or when you work with users, use the service-generated `ServerId` property that is assigned to the newly created server.
     */
    suspend fun createServer(input: CreateServerRequest = CreateServerRequest {}): CreateServerResponse

    /**
     * Creates a user and associates them with an existing file transfer protocol-enabled server. You can only create and associate users with servers that have the `IdentityProviderType` set to `SERVICE_MANAGED`. Using parameters for `CreateUser`, you can specify the user name, set the home directory, store the user's public key, and assign the user's Amazon Web Services Identity and Access Management (IAM) role. You can also optionally add a session policy, and assign metadata with tags that can be used to group and search for users.
     */
    suspend fun createUser(input: CreateUserRequest): CreateUserResponse

    /**
     * Allows you to create a workflow with specified steps and step details the workflow invokes after file transfer completes. After creating a workflow, you can associate the workflow created with any transfer servers by specifying the `workflow-details` field in `CreateServer` and `UpdateServer` operations.
     */
    suspend fun createWorkflow(input: CreateWorkflowRequest): CreateWorkflowResponse

    /**
     * Allows you to delete the access specified in the `ServerID` and `ExternalID` parameters.
     */
    suspend fun deleteAccess(input: DeleteAccessRequest): DeleteAccessResponse

    /**
     * Deletes the file transfer protocol-enabled server that you specify.
     *
     * No response returns from this operation.
     */
    suspend fun deleteServer(input: DeleteServerRequest): DeleteServerResponse

    /**
     * Deletes a user's Secure Shell (SSH) public key.
     */
    suspend fun deleteSshPublicKey(input: DeleteSshPublicKeyRequest): DeleteSshPublicKeyResponse

    /**
     * Deletes the user belonging to a file transfer protocol-enabled server you specify.
     *
     * No response returns from this operation.
     *
     * When you delete a user from a server, the user's information is lost.
     */
    suspend fun deleteUser(input: DeleteUserRequest): DeleteUserResponse

    /**
     * Deletes the specified workflow.
     */
    suspend fun deleteWorkflow(input: DeleteWorkflowRequest): DeleteWorkflowResponse

    /**
     * Describes the access that is assigned to the specific file transfer protocol-enabled server, as identified by its `ServerId` property and its `ExternalID`.
     *
     * The response from this call returns the properties of the access that is associated with the `ServerId` value that was specified.
     */
    suspend fun describeAccess(input: DescribeAccessRequest): DescribeAccessResponse

    /**
     * You can use `DescribeExecution` to check the details of the execution of the specified workflow.
     */
    suspend fun describeExecution(input: DescribeExecutionRequest): DescribeExecutionResponse

    /**
     * Describes the security policy that is attached to your file transfer protocol-enabled server. The response contains a description of the security policy's properties. For more information about security policies, see [Working with security policies](https://docs.aws.amazon.com/transfer/latest/userguide/security-policies.html).
     */
    suspend fun describeSecurityPolicy(input: DescribeSecurityPolicyRequest): DescribeSecurityPolicyResponse

    /**
     * Describes a file transfer protocol-enabled server that you specify by passing the `ServerId` parameter.
     *
     * The response contains a description of a server's properties. When you set `EndpointType` to VPC, the response will contain the `EndpointDetails`.
     */
    suspend fun describeServer(input: DescribeServerRequest): DescribeServerResponse

    /**
     * Describes the user assigned to the specific file transfer protocol-enabled server, as identified by its `ServerId` property.
     *
     * The response from this call returns the properties of the user associated with the `ServerId` value that was specified.
     */
    suspend fun describeUser(input: DescribeUserRequest): DescribeUserResponse

    /**
     * Describes the specified workflow.
     */
    suspend fun describeWorkflow(input: DescribeWorkflowRequest): DescribeWorkflowResponse

    /**
     * Adds a Secure Shell (SSH) public key to a user account identified by a `UserName` value assigned to the specific file transfer protocol-enabled server, identified by `ServerId`.
     *
     * The response returns the `UserName` value, the `ServerId` value, and the name of the `SshPublicKeyId`.
     */
    suspend fun importSshPublicKey(input: ImportSshPublicKeyRequest): ImportSshPublicKeyResponse

    /**
     * Lists the details for all the accesses you have on your server.
     */
    suspend fun listAccesses(input: ListAccessesRequest): ListAccessesResponse

    /**
     * Lists all executions for the specified workflow.
     */
    suspend fun listExecutions(input: ListExecutionsRequest): ListExecutionsResponse

    /**
     * Lists the security policies that are attached to your file transfer protocol-enabled servers.
     */
    suspend fun listSecurityPolicies(input: ListSecurityPoliciesRequest = ListSecurityPoliciesRequest {}): ListSecurityPoliciesResponse

    /**
     * Lists the file transfer protocol-enabled servers that are associated with your Amazon Web Services account.
     */
    suspend fun listServers(input: ListServersRequest = ListServersRequest {}): ListServersResponse

    /**
     * Lists all of the tags associated with the Amazon Resource Name (ARN) that you specify. The resource can be a user, server, or role.
     */
    suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Lists the users for a file transfer protocol-enabled server that you specify by passing the `ServerId` parameter.
     */
    suspend fun listUsers(input: ListUsersRequest): ListUsersResponse

    /**
     * Lists all of your workflows.
     */
    suspend fun listWorkflows(input: ListWorkflowsRequest = ListWorkflowsRequest {}): ListWorkflowsResponse

    /**
     * Sends a callback for asynchronous custom steps.
     *
     *  The `ExecutionId`, `WorkflowId`, and `Token` are passed to the target resource during execution of a custom step of a workflow. You must include those with their callback as well as providing a status.
     */
    suspend fun sendWorkflowStepState(input: SendWorkflowStepStateRequest): SendWorkflowStepStateResponse

    /**
     * Changes the state of a file transfer protocol-enabled server from `OFFLINE` to `ONLINE`. It has no impact on a server that is already `ONLINE`. An `ONLINE` server can accept and process file transfer jobs.
     *
     * The state of `STARTING` indicates that the server is in an intermediate state, either not fully able to respond, or not fully online. The values of `START_FAILED` can indicate an error condition.
     *
     * No response is returned from this call.
     */
    suspend fun startServer(input: StartServerRequest): StartServerResponse

    /**
     * Changes the state of a file transfer protocol-enabled server from `ONLINE` to `OFFLINE`. An `OFFLINE` server cannot accept and process file transfer jobs. Information tied to your server, such as server and user properties, are not affected by stopping your server.
     *
     * Stopping the server will not reduce or impact your file transfer protocol endpoint billing; you must delete the server to stop being billed.
     *
     * The state of `STOPPING` indicates that the server is in an intermediate state, either not fully able to respond, or not fully offline. The values of `STOP_FAILED` can indicate an error condition.
     *
     * No response is returned from this call.
     */
    suspend fun stopServer(input: StopServerRequest): StopServerResponse

    /**
     * Attaches a key-value pair to a resource, as identified by its Amazon Resource Name (ARN). Resources are users, servers, roles, and other entities.
     *
     * There is no response returned from this call.
     */
    suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * If the `IdentityProviderType` of a file transfer protocol-enabled server is `AWS_DIRECTORY_SERVICE` or `API_Gateway`, tests whether your identity provider is set up successfully. We highly recommend that you call this operation to test your authentication method as soon as you create your server. By doing so, you can troubleshoot issues with the identity provider integration to ensure that your users can successfully use the service.
     *
     *  The `ServerId` and `UserName` parameters are required. The `ServerProtocol`, `SourceIp`, and `UserPassword` are all optional.
     *
     *  You cannot use `TestIdentityProvider` if the `IdentityProviderType` of your server is `SERVICE_MANAGED`.
     *
     * +  If you provide any incorrect values for any parameters, the `Response` field is empty.
     * +  If you provide a server ID for a server that uses service-managed users, you get an error: ` An error occurred (InvalidRequestException) when calling the TestIdentityProvider operation: s-<i>server-ID</i> not configured for external auth `
     * +  If you enter a Server ID for the `--server-id` parameter that does not identify an actual Transfer server, you receive the following error: `An error occurred (ResourceNotFoundException) when calling the TestIdentityProvider operation: Unknown server`
     */
    suspend fun testIdentityProvider(input: TestIdentityProviderRequest): TestIdentityProviderResponse

    /**
     * Detaches a key-value pair from a resource, as identified by its Amazon Resource Name (ARN). Resources are users, servers, roles, and other entities.
     *
     * No response is returned from this call.
     */
    suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Allows you to update parameters for the access specified in the `ServerID` and `ExternalID` parameters.
     */
    suspend fun updateAccess(input: UpdateAccessRequest): UpdateAccessResponse

    /**
     * Updates the file transfer protocol-enabled server's properties after that server has been created.
     *
     * The `UpdateServer` call returns the `ServerId` of the server you updated.
     */
    suspend fun updateServer(input: UpdateServerRequest): UpdateServerResponse

    /**
     * Assigns new properties to a user. Parameters you pass modify any or all of the following: the home directory, role, and policy for the `UserName` and `ServerId` you specify.
     *
     * The response returns the `ServerId` and the `UserName` for the updated user.
     */
    suspend fun updateUser(input: UpdateUserRequest): UpdateUserResponse
}

/**
 * Used by administrators to choose which groups in the directory should have access to upload and download files over the enabled protocols using Amazon Web Services Transfer Family. For example, a Microsoft Active Directory might contain 50,000 users, but only a small fraction might need the ability to transfer files to the server. An administrator can use `CreateAccess` to limit the access to the correct set of users who need this ability.
 */
suspend inline fun TransferClient.createAccess(crossinline block: CreateAccessRequest.Builder.() -> Unit) = createAccess(CreateAccessRequest.Builder().apply(block).build())

/**
 * Instantiates an auto-scaling virtual server based on the selected file transfer protocol in Amazon Web Services. When you make updates to your file transfer protocol-enabled server or when you work with users, use the service-generated `ServerId` property that is assigned to the newly created server.
 */
suspend inline fun TransferClient.createServer(crossinline block: CreateServerRequest.Builder.() -> Unit) = createServer(CreateServerRequest.Builder().apply(block).build())

/**
 * Creates a user and associates them with an existing file transfer protocol-enabled server. You can only create and associate users with servers that have the `IdentityProviderType` set to `SERVICE_MANAGED`. Using parameters for `CreateUser`, you can specify the user name, set the home directory, store the user's public key, and assign the user's Amazon Web Services Identity and Access Management (IAM) role. You can also optionally add a session policy, and assign metadata with tags that can be used to group and search for users.
 */
suspend inline fun TransferClient.createUser(crossinline block: CreateUserRequest.Builder.() -> Unit) = createUser(CreateUserRequest.Builder().apply(block).build())

/**
 * Allows you to create a workflow with specified steps and step details the workflow invokes after file transfer completes. After creating a workflow, you can associate the workflow created with any transfer servers by specifying the `workflow-details` field in `CreateServer` and `UpdateServer` operations.
 */
suspend inline fun TransferClient.createWorkflow(crossinline block: CreateWorkflowRequest.Builder.() -> Unit) = createWorkflow(CreateWorkflowRequest.Builder().apply(block).build())

/**
 * Allows you to delete the access specified in the `ServerID` and `ExternalID` parameters.
 */
suspend inline fun TransferClient.deleteAccess(crossinline block: DeleteAccessRequest.Builder.() -> Unit) = deleteAccess(DeleteAccessRequest.Builder().apply(block).build())

/**
 * Deletes the file transfer protocol-enabled server that you specify.
 *
 * No response returns from this operation.
 */
suspend inline fun TransferClient.deleteServer(crossinline block: DeleteServerRequest.Builder.() -> Unit) = deleteServer(DeleteServerRequest.Builder().apply(block).build())

/**
 * Deletes a user's Secure Shell (SSH) public key.
 */
suspend inline fun TransferClient.deleteSshPublicKey(crossinline block: DeleteSshPublicKeyRequest.Builder.() -> Unit) = deleteSshPublicKey(DeleteSshPublicKeyRequest.Builder().apply(block).build())

/**
 * Deletes the user belonging to a file transfer protocol-enabled server you specify.
 *
 * No response returns from this operation.
 *
 * When you delete a user from a server, the user's information is lost.
 */
suspend inline fun TransferClient.deleteUser(crossinline block: DeleteUserRequest.Builder.() -> Unit) = deleteUser(DeleteUserRequest.Builder().apply(block).build())

/**
 * Deletes the specified workflow.
 */
suspend inline fun TransferClient.deleteWorkflow(crossinline block: DeleteWorkflowRequest.Builder.() -> Unit) = deleteWorkflow(DeleteWorkflowRequest.Builder().apply(block).build())

/**
 * Describes the access that is assigned to the specific file transfer protocol-enabled server, as identified by its `ServerId` property and its `ExternalID`.
 *
 * The response from this call returns the properties of the access that is associated with the `ServerId` value that was specified.
 */
suspend inline fun TransferClient.describeAccess(crossinline block: DescribeAccessRequest.Builder.() -> Unit) = describeAccess(DescribeAccessRequest.Builder().apply(block).build())

/**
 * You can use `DescribeExecution` to check the details of the execution of the specified workflow.
 */
suspend inline fun TransferClient.describeExecution(crossinline block: DescribeExecutionRequest.Builder.() -> Unit) = describeExecution(DescribeExecutionRequest.Builder().apply(block).build())

/**
 * Describes the security policy that is attached to your file transfer protocol-enabled server. The response contains a description of the security policy's properties. For more information about security policies, see [Working with security policies](https://docs.aws.amazon.com/transfer/latest/userguide/security-policies.html).
 */
suspend inline fun TransferClient.describeSecurityPolicy(crossinline block: DescribeSecurityPolicyRequest.Builder.() -> Unit) = describeSecurityPolicy(DescribeSecurityPolicyRequest.Builder().apply(block).build())

/**
 * Describes a file transfer protocol-enabled server that you specify by passing the `ServerId` parameter.
 *
 * The response contains a description of a server's properties. When you set `EndpointType` to VPC, the response will contain the `EndpointDetails`.
 */
suspend inline fun TransferClient.describeServer(crossinline block: DescribeServerRequest.Builder.() -> Unit) = describeServer(DescribeServerRequest.Builder().apply(block).build())

/**
 * Describes the user assigned to the specific file transfer protocol-enabled server, as identified by its `ServerId` property.
 *
 * The response from this call returns the properties of the user associated with the `ServerId` value that was specified.
 */
suspend inline fun TransferClient.describeUser(crossinline block: DescribeUserRequest.Builder.() -> Unit) = describeUser(DescribeUserRequest.Builder().apply(block).build())

/**
 * Describes the specified workflow.
 */
suspend inline fun TransferClient.describeWorkflow(crossinline block: DescribeWorkflowRequest.Builder.() -> Unit) = describeWorkflow(DescribeWorkflowRequest.Builder().apply(block).build())

/**
 * Adds a Secure Shell (SSH) public key to a user account identified by a `UserName` value assigned to the specific file transfer protocol-enabled server, identified by `ServerId`.
 *
 * The response returns the `UserName` value, the `ServerId` value, and the name of the `SshPublicKeyId`.
 */
suspend inline fun TransferClient.importSshPublicKey(crossinline block: ImportSshPublicKeyRequest.Builder.() -> Unit) = importSshPublicKey(ImportSshPublicKeyRequest.Builder().apply(block).build())

/**
 * Lists the details for all the accesses you have on your server.
 */
suspend inline fun TransferClient.listAccesses(crossinline block: ListAccessesRequest.Builder.() -> Unit) = listAccesses(ListAccessesRequest.Builder().apply(block).build())

/**
 * Lists all executions for the specified workflow.
 */
suspend inline fun TransferClient.listExecutions(crossinline block: ListExecutionsRequest.Builder.() -> Unit) = listExecutions(ListExecutionsRequest.Builder().apply(block).build())

/**
 * Lists the security policies that are attached to your file transfer protocol-enabled servers.
 */
suspend inline fun TransferClient.listSecurityPolicies(crossinline block: ListSecurityPoliciesRequest.Builder.() -> Unit) = listSecurityPolicies(ListSecurityPoliciesRequest.Builder().apply(block).build())

/**
 * Lists the file transfer protocol-enabled servers that are associated with your Amazon Web Services account.
 */
suspend inline fun TransferClient.listServers(crossinline block: ListServersRequest.Builder.() -> Unit) = listServers(ListServersRequest.Builder().apply(block).build())

/**
 * Lists all of the tags associated with the Amazon Resource Name (ARN) that you specify. The resource can be a user, server, or role.
 */
suspend inline fun TransferClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit) = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Lists the users for a file transfer protocol-enabled server that you specify by passing the `ServerId` parameter.
 */
suspend inline fun TransferClient.listUsers(crossinline block: ListUsersRequest.Builder.() -> Unit) = listUsers(ListUsersRequest.Builder().apply(block).build())

/**
 * Lists all of your workflows.
 */
suspend inline fun TransferClient.listWorkflows(crossinline block: ListWorkflowsRequest.Builder.() -> Unit) = listWorkflows(ListWorkflowsRequest.Builder().apply(block).build())

/**
 * Sends a callback for asynchronous custom steps.
 *
 *  The `ExecutionId`, `WorkflowId`, and `Token` are passed to the target resource during execution of a custom step of a workflow. You must include those with their callback as well as providing a status.
 */
suspend inline fun TransferClient.sendWorkflowStepState(crossinline block: SendWorkflowStepStateRequest.Builder.() -> Unit) = sendWorkflowStepState(SendWorkflowStepStateRequest.Builder().apply(block).build())

/**
 * Changes the state of a file transfer protocol-enabled server from `OFFLINE` to `ONLINE`. It has no impact on a server that is already `ONLINE`. An `ONLINE` server can accept and process file transfer jobs.
 *
 * The state of `STARTING` indicates that the server is in an intermediate state, either not fully able to respond, or not fully online. The values of `START_FAILED` can indicate an error condition.
 *
 * No response is returned from this call.
 */
suspend inline fun TransferClient.startServer(crossinline block: StartServerRequest.Builder.() -> Unit) = startServer(StartServerRequest.Builder().apply(block).build())

/**
 * Changes the state of a file transfer protocol-enabled server from `ONLINE` to `OFFLINE`. An `OFFLINE` server cannot accept and process file transfer jobs. Information tied to your server, such as server and user properties, are not affected by stopping your server.
 *
 * Stopping the server will not reduce or impact your file transfer protocol endpoint billing; you must delete the server to stop being billed.
 *
 * The state of `STOPPING` indicates that the server is in an intermediate state, either not fully able to respond, or not fully offline. The values of `STOP_FAILED` can indicate an error condition.
 *
 * No response is returned from this call.
 */
suspend inline fun TransferClient.stopServer(crossinline block: StopServerRequest.Builder.() -> Unit) = stopServer(StopServerRequest.Builder().apply(block).build())

/**
 * Attaches a key-value pair to a resource, as identified by its Amazon Resource Name (ARN). Resources are users, servers, roles, and other entities.
 *
 * There is no response returned from this call.
 */
suspend inline fun TransferClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit) = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * If the `IdentityProviderType` of a file transfer protocol-enabled server is `AWS_DIRECTORY_SERVICE` or `API_Gateway`, tests whether your identity provider is set up successfully. We highly recommend that you call this operation to test your authentication method as soon as you create your server. By doing so, you can troubleshoot issues with the identity provider integration to ensure that your users can successfully use the service.
 *
 *  The `ServerId` and `UserName` parameters are required. The `ServerProtocol`, `SourceIp`, and `UserPassword` are all optional.
 *
 *  You cannot use `TestIdentityProvider` if the `IdentityProviderType` of your server is `SERVICE_MANAGED`.
 *
 * +  If you provide any incorrect values for any parameters, the `Response` field is empty.
 * +  If you provide a server ID for a server that uses service-managed users, you get an error: ` An error occurred (InvalidRequestException) when calling the TestIdentityProvider operation: s-<i>server-ID</i> not configured for external auth `
 * +  If you enter a Server ID for the `--server-id` parameter that does not identify an actual Transfer server, you receive the following error: `An error occurred (ResourceNotFoundException) when calling the TestIdentityProvider operation: Unknown server`
 */
suspend inline fun TransferClient.testIdentityProvider(crossinline block: TestIdentityProviderRequest.Builder.() -> Unit) = testIdentityProvider(TestIdentityProviderRequest.Builder().apply(block).build())

/**
 * Detaches a key-value pair from a resource, as identified by its Amazon Resource Name (ARN). Resources are users, servers, roles, and other entities.
 *
 * No response is returned from this call.
 */
suspend inline fun TransferClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit) = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Allows you to update parameters for the access specified in the `ServerID` and `ExternalID` parameters.
 */
suspend inline fun TransferClient.updateAccess(crossinline block: UpdateAccessRequest.Builder.() -> Unit) = updateAccess(UpdateAccessRequest.Builder().apply(block).build())

/**
 * Updates the file transfer protocol-enabled server's properties after that server has been created.
 *
 * The `UpdateServer` call returns the `ServerId` of the server you updated.
 */
suspend inline fun TransferClient.updateServer(crossinline block: UpdateServerRequest.Builder.() -> Unit) = updateServer(UpdateServerRequest.Builder().apply(block).build())

/**
 * Assigns new properties to a user. Parameters you pass modify any or all of the following: the home directory, role, and policy for the `UserName` and `ServerId` you specify.
 *
 * The response returns the `ServerId` and the `UserName` for the updated user.
 */
suspend inline fun TransferClient.updateUser(crossinline block: UpdateUserRequest.Builder.() -> Unit) = updateUser(UpdateUserRequest.Builder().apply(block).build())
