// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.transfer.model



/**
 * Describes the properties of a security policy that was specified. For more information about security policies, see [Working with security policies](https://docs.aws.amazon.com/transfer/latest/userguide/security-policies.html).
 */
class DescribedSecurityPolicy private constructor(builder: Builder) {
    /**
     * Specifies whether this policy enables Federal Information Processing Standards (FIPS).
     */
    val fips: kotlin.Boolean? = builder.fips
    /**
     * Specifies the name of the security policy that is attached to the server.
     */
    val securityPolicyName: kotlin.String? = builder.securityPolicyName
    /**
     * Specifies the enabled Secure Shell (SSH) cipher encryption algorithms in the security policy that is attached to the server.
     */
    val sshCiphers: List<String>? = builder.sshCiphers
    /**
     * Specifies the enabled SSH key exchange (KEX) encryption algorithms in the security policy that is attached to the server.
     */
    val sshKexs: List<String>? = builder.sshKexs
    /**
     * Specifies the enabled SSH message authentication code (MAC) encryption algorithms in the security policy that is attached to the server.
     */
    val sshMacs: List<String>? = builder.sshMacs
    /**
     * Specifies the enabled Transport Layer Security (TLS) cipher encryption algorithms in the security policy that is attached to the server.
     */
    val tlsCiphers: List<String>? = builder.tlsCiphers

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.transfer.model.DescribedSecurityPolicy = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribedSecurityPolicy(")
        append("fips=$fips,")
        append("securityPolicyName=$securityPolicyName,")
        append("sshCiphers=$sshCiphers,")
        append("sshKexs=$sshKexs,")
        append("sshMacs=$sshMacs,")
        append("tlsCiphers=$tlsCiphers)")
    }

    override fun hashCode(): kotlin.Int {
        var result = fips?.hashCode() ?: 0
        result = 31 * result + (securityPolicyName?.hashCode() ?: 0)
        result = 31 * result + (sshCiphers?.hashCode() ?: 0)
        result = 31 * result + (sshKexs?.hashCode() ?: 0)
        result = 31 * result + (sshMacs?.hashCode() ?: 0)
        result = 31 * result + (tlsCiphers?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribedSecurityPolicy

        if (fips != other.fips) return false
        if (securityPolicyName != other.securityPolicyName) return false
        if (sshCiphers != other.sshCiphers) return false
        if (sshKexs != other.sshKexs) return false
        if (sshMacs != other.sshMacs) return false
        if (tlsCiphers != other.tlsCiphers) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.transfer.model.DescribedSecurityPolicy = Builder(this).apply(block).build()

    class Builder {
        /**
         * Specifies whether this policy enables Federal Information Processing Standards (FIPS).
         */
        var fips: kotlin.Boolean? = null
        /**
         * Specifies the name of the security policy that is attached to the server.
         */
        var securityPolicyName: kotlin.String? = null
        /**
         * Specifies the enabled Secure Shell (SSH) cipher encryption algorithms in the security policy that is attached to the server.
         */
        var sshCiphers: List<String>? = null
        /**
         * Specifies the enabled SSH key exchange (KEX) encryption algorithms in the security policy that is attached to the server.
         */
        var sshKexs: List<String>? = null
        /**
         * Specifies the enabled SSH message authentication code (MAC) encryption algorithms in the security policy that is attached to the server.
         */
        var sshMacs: List<String>? = null
        /**
         * Specifies the enabled Transport Layer Security (TLS) cipher encryption algorithms in the security policy that is attached to the server.
         */
        var tlsCiphers: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.transfer.model.DescribedSecurityPolicy) : this() {
            this.fips = x.fips
            this.securityPolicyName = x.securityPolicyName
            this.sshCiphers = x.sshCiphers
            this.sshKexs = x.sshKexs
            this.sshMacs = x.sshMacs
            this.tlsCiphers = x.tlsCiphers
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.transfer.model.DescribedSecurityPolicy = DescribedSecurityPolicy(this)
    }
}
