// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.transfer.model



/**
 * Describes the properties of a user that was specified.
 */
class DescribedUser private constructor(builder: Builder) {
    /**
     * Specifies the unique Amazon Resource Name (ARN) for the user that was requested to be described.
     */
    val arn: kotlin.String? = builder.arn
    /**
     * The landing directory (folder) for a user when they log in to the server using the client.
     *
     * A `HomeDirectory` example is `/bucket_name/home/mydirectory`.
     */
    val homeDirectory: kotlin.String? = builder.homeDirectory
    /**
     * Logical directory mappings that specify what Amazon S3 or Amazon EFS paths and keys should be visible to your user and how you want to make them visible. You must specify the `Entry` and `Target` pair, where `Entry` shows how the path is made visible and `Target` is the actual Amazon S3 or Amazon EFS path. If you only specify a target, it is displayed as is. You also must ensure that your Amazon Web Services Identity and Access Management (IAM) role provides access to paths in `Target`. This value can only be set when `HomeDirectoryType` is set to *LOGICAL*.
     *
     * In most cases, you can use this value instead of the session policy to lock your user down to the designated home directory ("`chroot`"). To do this, you can set `Entry` to '/' and set `Target` to the HomeDirectory parameter value.
     */
    val homeDirectoryMappings: List<HomeDirectoryMapEntry>? = builder.homeDirectoryMappings
    /**
     * The type of landing directory (folder) you want your users' home directory to be when they log into the server. If you set it to `PATH`, the user will see the absolute Amazon S3 bucket or EFS paths as is in their file transfer protocol clients. If you set it `LOGICAL`, you need to provide mappings in the `HomeDirectoryMappings` for how you want to make Amazon S3 or EFS paths visible to your users.
     */
    val homeDirectoryType: aws.sdk.kotlin.services.transfer.model.HomeDirectoryType? = builder.homeDirectoryType
    /**
     * A session policy for your user so that you can use the same IAM role across multiple users. This policy scopes down user access to portions of their Amazon S3 bucket. Variables that you can use inside this policy include `${Transfer:UserName}`, `${Transfer:HomeDirectory}`, and `${Transfer:HomeBucket}`.
     */
    val policy: kotlin.String? = builder.policy
    /**
     * Specifies the full POSIX identity, including user ID (`Uid`), group ID (`Gid`), and any secondary groups IDs (`SecondaryGids`), that controls your users' access to your Amazon Elastic File System (Amazon EFS) file systems. The POSIX permissions that are set on files and directories in your file system determine the level of access your users get when transferring files into and out of your Amazon EFS file systems.
     */
    val posixProfile: aws.sdk.kotlin.services.transfer.model.PosixProfile? = builder.posixProfile
    /**
     * Specifies the Amazon Resource Name (ARN) of the IAM role that controls your users' access to your Amazon S3 bucket or EFS file system. The policies attached to this role determine the level of access that you want to provide your users when transferring files into and out of your Amazon S3 bucket or EFS file system. The IAM role should also contain a trust relationship that allows the server to access your resources when servicing your users' transfer requests.
     */
    val role: kotlin.String? = builder.role
    /**
     * Specifies the public key portion of the Secure Shell (SSH) keys stored for the described user.
     */
    val sshPublicKeys: List<SshPublicKey>? = builder.sshPublicKeys
    /**
     * Specifies the key-value pairs for the user requested. Tag can be used to search for and group users for a variety of purposes.
     */
    val tags: List<Tag>? = builder.tags
    /**
     * Specifies the name of the user that was requested to be described. User names are used for authentication purposes. This is the string that will be used by your user when they log in to your server.
     */
    val userName: kotlin.String? = builder.userName

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.transfer.model.DescribedUser = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribedUser(")
        append("arn=$arn,")
        append("homeDirectory=$homeDirectory,")
        append("homeDirectoryMappings=$homeDirectoryMappings,")
        append("homeDirectoryType=$homeDirectoryType,")
        append("policy=$policy,")
        append("posixProfile=$posixProfile,")
        append("role=$role,")
        append("sshPublicKeys=$sshPublicKeys,")
        append("tags=$tags,")
        append("userName=$userName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (homeDirectory?.hashCode() ?: 0)
        result = 31 * result + (homeDirectoryMappings?.hashCode() ?: 0)
        result = 31 * result + (homeDirectoryType?.hashCode() ?: 0)
        result = 31 * result + (policy?.hashCode() ?: 0)
        result = 31 * result + (posixProfile?.hashCode() ?: 0)
        result = 31 * result + (role?.hashCode() ?: 0)
        result = 31 * result + (sshPublicKeys?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (userName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribedUser

        if (arn != other.arn) return false
        if (homeDirectory != other.homeDirectory) return false
        if (homeDirectoryMappings != other.homeDirectoryMappings) return false
        if (homeDirectoryType != other.homeDirectoryType) return false
        if (policy != other.policy) return false
        if (posixProfile != other.posixProfile) return false
        if (role != other.role) return false
        if (sshPublicKeys != other.sshPublicKeys) return false
        if (tags != other.tags) return false
        if (userName != other.userName) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.transfer.model.DescribedUser = Builder(this).apply(block).build()

    class Builder {
        /**
         * Specifies the unique Amazon Resource Name (ARN) for the user that was requested to be described.
         */
        var arn: kotlin.String? = null
        /**
         * The landing directory (folder) for a user when they log in to the server using the client.
         *
         * A `HomeDirectory` example is `/bucket_name/home/mydirectory`.
         */
        var homeDirectory: kotlin.String? = null
        /**
         * Logical directory mappings that specify what Amazon S3 or Amazon EFS paths and keys should be visible to your user and how you want to make them visible. You must specify the `Entry` and `Target` pair, where `Entry` shows how the path is made visible and `Target` is the actual Amazon S3 or Amazon EFS path. If you only specify a target, it is displayed as is. You also must ensure that your Amazon Web Services Identity and Access Management (IAM) role provides access to paths in `Target`. This value can only be set when `HomeDirectoryType` is set to *LOGICAL*.
         *
         * In most cases, you can use this value instead of the session policy to lock your user down to the designated home directory ("`chroot`"). To do this, you can set `Entry` to '/' and set `Target` to the HomeDirectory parameter value.
         */
        var homeDirectoryMappings: List<HomeDirectoryMapEntry>? = null
        /**
         * The type of landing directory (folder) you want your users' home directory to be when they log into the server. If you set it to `PATH`, the user will see the absolute Amazon S3 bucket or EFS paths as is in their file transfer protocol clients. If you set it `LOGICAL`, you need to provide mappings in the `HomeDirectoryMappings` for how you want to make Amazon S3 or EFS paths visible to your users.
         */
        var homeDirectoryType: aws.sdk.kotlin.services.transfer.model.HomeDirectoryType? = null
        /**
         * A session policy for your user so that you can use the same IAM role across multiple users. This policy scopes down user access to portions of their Amazon S3 bucket. Variables that you can use inside this policy include `${Transfer:UserName}`, `${Transfer:HomeDirectory}`, and `${Transfer:HomeBucket}`.
         */
        var policy: kotlin.String? = null
        /**
         * Specifies the full POSIX identity, including user ID (`Uid`), group ID (`Gid`), and any secondary groups IDs (`SecondaryGids`), that controls your users' access to your Amazon Elastic File System (Amazon EFS) file systems. The POSIX permissions that are set on files and directories in your file system determine the level of access your users get when transferring files into and out of your Amazon EFS file systems.
         */
        var posixProfile: aws.sdk.kotlin.services.transfer.model.PosixProfile? = null
        /**
         * Specifies the Amazon Resource Name (ARN) of the IAM role that controls your users' access to your Amazon S3 bucket or EFS file system. The policies attached to this role determine the level of access that you want to provide your users when transferring files into and out of your Amazon S3 bucket or EFS file system. The IAM role should also contain a trust relationship that allows the server to access your resources when servicing your users' transfer requests.
         */
        var role: kotlin.String? = null
        /**
         * Specifies the public key portion of the Secure Shell (SSH) keys stored for the described user.
         */
        var sshPublicKeys: List<SshPublicKey>? = null
        /**
         * Specifies the key-value pairs for the user requested. Tag can be used to search for and group users for a variety of purposes.
         */
        var tags: List<Tag>? = null
        /**
         * Specifies the name of the user that was requested to be described. User names are used for authentication purposes. This is the string that will be used by your user when they log in to your server.
         */
        var userName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.transfer.model.DescribedUser) : this() {
            this.arn = x.arn
            this.homeDirectory = x.homeDirectory
            this.homeDirectoryMappings = x.homeDirectoryMappings
            this.homeDirectoryType = x.homeDirectoryType
            this.policy = x.policy
            this.posixProfile = x.posixProfile
            this.role = x.role
            this.sshPublicKeys = x.sshPublicKeys
            this.tags = x.tags
            this.userName = x.userName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.transfer.model.DescribedUser = DescribedUser(this)

        /**
         * construct an [aws.sdk.kotlin.services.transfer.model.PosixProfile] inside the given [block]
         */
        fun posixProfile(block: aws.sdk.kotlin.services.transfer.model.PosixProfile.Builder.() -> kotlin.Unit) {
            this.posixProfile = aws.sdk.kotlin.services.transfer.model.PosixProfile.invoke(block)
        }
    }
}
