// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.transfer.model



/**
 * The virtual private cloud (VPC) endpoint settings that are configured for your file transfer protocol-enabled server. With a VPC endpoint, you can restrict access to your server and resources only within your VPC. To control incoming internet traffic, invoke the `UpdateServer` API and attach an Elastic IP address to your server's endpoint.
 *
 *  After May 19, 2021, you won't be able to create a server using `EndpointType=VPC_ENDPOINT` in your Amazon Web Servicesaccount if your account hasn't already done so before May 19, 2021. If you have already created servers with `EndpointType=VPC_ENDPOINT` in your Amazon Web Servicesaccount on or before May 19, 2021, you will not be affected. After this date, use `EndpointType`=`VPC`.
 *
 * For more information, see https://docs.aws.amazon.com/transfer/latest/userguide/create-server-in-vpc.html#deprecate-vpc-endpoint.
 */
class EndpointDetails private constructor(builder: Builder) {
    /**
     * A list of address allocation IDs that are required to attach an Elastic IP address to your server's endpoint.
     *
     * This property can only be set when `EndpointType` is set to `VPC` and it is only valid in the `UpdateServer` API.
     */
    val addressAllocationIds: List<String>? = builder.addressAllocationIds
    /**
     * A list of security groups IDs that are available to attach to your server's endpoint.
     *
     * This property can only be set when `EndpointType` is set to `VPC`.
     *
     * You can edit the `SecurityGroupIds` property in the [UpdateServer](https://docs.aws.amazon.com/transfer/latest/userguide/API_UpdateServer.html) API only if you are changing the `EndpointType` from `PUBLIC` or `VPC_ENDPOINT` to `VPC`. To change security groups associated with your server's VPC endpoint after creation, use the Amazon EC2 [ModifyVpcEndpoint](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyVpcEndpoint.html) API.
     */
    val securityGroupIds: List<String>? = builder.securityGroupIds
    /**
     * A list of subnet IDs that are required to host your server endpoint in your VPC.
     *
     * This property can only be set when `EndpointType` is set to `VPC`.
     */
    val subnetIds: List<String>? = builder.subnetIds
    /**
     * The ID of the VPC endpoint.
     *
     * This property can only be set when `EndpointType` is set to `VPC_ENDPOINT`.
     *
     * For more information, see https://docs.aws.amazon.com/transfer/latest/userguide/create-server-in-vpc.html#deprecate-vpc-endpoint.
     */
    val vpcEndpointId: kotlin.String? = builder.vpcEndpointId
    /**
     * The VPC ID of the VPC in which a server's endpoint will be hosted.
     *
     * This property can only be set when `EndpointType` is set to `VPC`.
     */
    val vpcId: kotlin.String? = builder.vpcId

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.transfer.model.EndpointDetails = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("EndpointDetails(")
        append("addressAllocationIds=$addressAllocationIds,")
        append("securityGroupIds=$securityGroupIds,")
        append("subnetIds=$subnetIds,")
        append("vpcEndpointId=$vpcEndpointId,")
        append("vpcId=$vpcId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = addressAllocationIds?.hashCode() ?: 0
        result = 31 * result + (securityGroupIds?.hashCode() ?: 0)
        result = 31 * result + (subnetIds?.hashCode() ?: 0)
        result = 31 * result + (vpcEndpointId?.hashCode() ?: 0)
        result = 31 * result + (vpcId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as EndpointDetails

        if (addressAllocationIds != other.addressAllocationIds) return false
        if (securityGroupIds != other.securityGroupIds) return false
        if (subnetIds != other.subnetIds) return false
        if (vpcEndpointId != other.vpcEndpointId) return false
        if (vpcId != other.vpcId) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.transfer.model.EndpointDetails = Builder(this).apply(block).build()

    class Builder {
        /**
         * A list of address allocation IDs that are required to attach an Elastic IP address to your server's endpoint.
         *
         * This property can only be set when `EndpointType` is set to `VPC` and it is only valid in the `UpdateServer` API.
         */
        var addressAllocationIds: List<String>? = null
        /**
         * A list of security groups IDs that are available to attach to your server's endpoint.
         *
         * This property can only be set when `EndpointType` is set to `VPC`.
         *
         * You can edit the `SecurityGroupIds` property in the [UpdateServer](https://docs.aws.amazon.com/transfer/latest/userguide/API_UpdateServer.html) API only if you are changing the `EndpointType` from `PUBLIC` or `VPC_ENDPOINT` to `VPC`. To change security groups associated with your server's VPC endpoint after creation, use the Amazon EC2 [ModifyVpcEndpoint](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyVpcEndpoint.html) API.
         */
        var securityGroupIds: List<String>? = null
        /**
         * A list of subnet IDs that are required to host your server endpoint in your VPC.
         *
         * This property can only be set when `EndpointType` is set to `VPC`.
         */
        var subnetIds: List<String>? = null
        /**
         * The ID of the VPC endpoint.
         *
         * This property can only be set when `EndpointType` is set to `VPC_ENDPOINT`.
         *
         * For more information, see https://docs.aws.amazon.com/transfer/latest/userguide/create-server-in-vpc.html#deprecate-vpc-endpoint.
         */
        var vpcEndpointId: kotlin.String? = null
        /**
         * The VPC ID of the VPC in which a server's endpoint will be hosted.
         *
         * This property can only be set when `EndpointType` is set to `VPC`.
         */
        var vpcId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.transfer.model.EndpointDetails) : this() {
            this.addressAllocationIds = x.addressAllocationIds
            this.securityGroupIds = x.securityGroupIds
            this.subnetIds = x.subnetIds
            this.vpcEndpointId = x.vpcEndpointId
            this.vpcId = x.vpcId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.transfer.model.EndpointDetails = EndpointDetails(this)
    }
}
