// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.transfer.model



/**
 * Specifies the Amazon S3 or EFS file details to be used in the step.
 */
class FileLocation private constructor(builder: Builder) {
    /**
     * Specifies the Amazon EFS ID and the path for the file being used.
     */
    val efsFileLocation: aws.sdk.kotlin.services.transfer.model.EfsFileLocation? = builder.efsFileLocation
    /**
     * Specifies the S3 details for the file being used, such as bucket, Etag, and so forth.
     */
    val s3FileLocation: aws.sdk.kotlin.services.transfer.model.S3FileLocation? = builder.s3FileLocation

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.transfer.model.FileLocation = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("FileLocation(")
        append("efsFileLocation=$efsFileLocation,")
        append("s3FileLocation=$s3FileLocation)")
    }

    override fun hashCode(): kotlin.Int {
        var result = efsFileLocation?.hashCode() ?: 0
        result = 31 * result + (s3FileLocation?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as FileLocation

        if (efsFileLocation != other.efsFileLocation) return false
        if (s3FileLocation != other.s3FileLocation) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.transfer.model.FileLocation = Builder(this).apply(block).build()

    class Builder {
        /**
         * Specifies the Amazon EFS ID and the path for the file being used.
         */
        var efsFileLocation: aws.sdk.kotlin.services.transfer.model.EfsFileLocation? = null
        /**
         * Specifies the S3 details for the file being used, such as bucket, Etag, and so forth.
         */
        var s3FileLocation: aws.sdk.kotlin.services.transfer.model.S3FileLocation? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.transfer.model.FileLocation) : this() {
            this.efsFileLocation = x.efsFileLocation
            this.s3FileLocation = x.s3FileLocation
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.transfer.model.FileLocation = FileLocation(this)

        /**
         * construct an [aws.sdk.kotlin.services.transfer.model.EfsFileLocation] inside the given [block]
         */
        fun efsFileLocation(block: aws.sdk.kotlin.services.transfer.model.EfsFileLocation.Builder.() -> kotlin.Unit) {
            this.efsFileLocation = aws.sdk.kotlin.services.transfer.model.EfsFileLocation.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.transfer.model.S3FileLocation] inside the given [block]
         */
        fun s3FileLocation(block: aws.sdk.kotlin.services.transfer.model.S3FileLocation.Builder.() -> kotlin.Unit) {
            this.s3FileLocation = aws.sdk.kotlin.services.transfer.model.S3FileLocation.invoke(block)
        }
    }
}
