// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.transfer.model



class ListExecutionsRequest private constructor(builder: Builder) {
    /**
     * Specifies the aximum number of executions to return.
     */
    val maxResults: kotlin.Int? = builder.maxResults
    /**
     * `ListExecutions` returns the `NextToken` parameter in the output. You can then pass the `NextToken` parameter in a subsequent command to continue listing additional executions.
     *
     *  This is useful for pagination, for instance. If you have 100 executions for a workflow, you might only want to list first 10. If so, callthe API by specifing the `max-results`:
     *
     * `aws transfer list-executions --max-results 10`
     *
     *  This returns details for the first 10 executions, as well as the pointer (`NextToken`) to the eleventh execution. You can now call the API again, suppling the `NextToken` value you received:
     *
     * `aws transfer list-executions --max-results 10 --next-token $somePointerReturnedFromPreviousListResult`
     *
     *  This call returns the next 10 executions, the 11th through the 20th. You can then repeat the call until the details for all 100 executions have been returned.
     */
    val nextToken: kotlin.String? = builder.nextToken
    /**
     * A unique identifier for the workflow.
     */
    val workflowId: kotlin.String? = builder.workflowId

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.transfer.model.ListExecutionsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListExecutionsRequest(")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken,")
        append("workflowId=$workflowId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = maxResults ?: 0
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (workflowId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListExecutionsRequest

        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (workflowId != other.workflowId) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.transfer.model.ListExecutionsRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * Specifies the aximum number of executions to return.
         */
        var maxResults: kotlin.Int? = null
        /**
         * `ListExecutions` returns the `NextToken` parameter in the output. You can then pass the `NextToken` parameter in a subsequent command to continue listing additional executions.
         *
         *  This is useful for pagination, for instance. If you have 100 executions for a workflow, you might only want to list first 10. If so, callthe API by specifing the `max-results`:
         *
         * `aws transfer list-executions --max-results 10`
         *
         *  This returns details for the first 10 executions, as well as the pointer (`NextToken`) to the eleventh execution. You can now call the API again, suppling the `NextToken` value you received:
         *
         * `aws transfer list-executions --max-results 10 --next-token $somePointerReturnedFromPreviousListResult`
         *
         *  This call returns the next 10 executions, the 11th through the 20th. You can then repeat the call until the details for all 100 executions have been returned.
         */
        var nextToken: kotlin.String? = null
        /**
         * A unique identifier for the workflow.
         */
        var workflowId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.transfer.model.ListExecutionsRequest) : this() {
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.workflowId = x.workflowId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.transfer.model.ListExecutionsRequest = ListExecutionsRequest(this)
    }
}
