// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.transfer.model



/**
 * Lists the properties for one or more specified associated accesses.
 */
class ListedAccess private constructor(builder: Builder) {
    /**
     * A unique identifier that is required to identify specific groups within your directory. The users of the group that you associate have access to your Amazon S3 or Amazon EFS resources over the enabled protocols using Amazon Web Services Transfer Family. If you know the group name, you can view the SID values by running the following command using Windows PowerShell.
     *
     * `Get-ADGroup -Filter {samAccountName -like "<i>YourGroupName</i>*"} -Properties * | Select SamAccountName,ObjectSid`
     *
     * In that command, replace *YourGroupName* with the name of your Active Directory group.
     *
     * The regex used to validate this parameter is a string of characters consisting of uppercase and lowercase alphanumeric characters with no spaces. You can also include underscores or any of the following characters: =,.@:/-
     */
    val externalId: kotlin.String? = builder.externalId
    /**
     * The landing directory (folder) for a user when they log in to the server using the client.
     *
     * A `HomeDirectory` example is `/bucket_name/home/mydirectory`.
     */
    val homeDirectory: kotlin.String? = builder.homeDirectory
    /**
     * The type of landing directory (folder) you want your users' home directory to be when they log into the server. If you set it to `PATH`, the user will see the absolute Amazon S3 bucket or EFS paths as is in their file transfer protocol clients. If you set it `LOGICAL`, you need to provide mappings in the `HomeDirectoryMappings` for how you want to make Amazon S3 or EFS paths visible to your users.
     */
    val homeDirectoryType: aws.sdk.kotlin.services.transfer.model.HomeDirectoryType? = builder.homeDirectoryType
    /**
     * Specifies the Amazon Resource Name (ARN) of the IAM role that controls your users' access to your Amazon S3 bucket or EFS file system. The policies attached to this role determine the level of access that you want to provide your users when transferring files into and out of your Amazon S3 bucket or EFS file system. The IAM role should also contain a trust relationship that allows the server to access your resources when servicing your users' transfer requests.
     */
    val role: kotlin.String? = builder.role

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.transfer.model.ListedAccess = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListedAccess(")
        append("externalId=$externalId,")
        append("homeDirectory=$homeDirectory,")
        append("homeDirectoryType=$homeDirectoryType,")
        append("role=$role)")
    }

    override fun hashCode(): kotlin.Int {
        var result = externalId?.hashCode() ?: 0
        result = 31 * result + (homeDirectory?.hashCode() ?: 0)
        result = 31 * result + (homeDirectoryType?.hashCode() ?: 0)
        result = 31 * result + (role?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListedAccess

        if (externalId != other.externalId) return false
        if (homeDirectory != other.homeDirectory) return false
        if (homeDirectoryType != other.homeDirectoryType) return false
        if (role != other.role) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.transfer.model.ListedAccess = Builder(this).apply(block).build()

    class Builder {
        /**
         * A unique identifier that is required to identify specific groups within your directory. The users of the group that you associate have access to your Amazon S3 or Amazon EFS resources over the enabled protocols using Amazon Web Services Transfer Family. If you know the group name, you can view the SID values by running the following command using Windows PowerShell.
         *
         * `Get-ADGroup -Filter {samAccountName -like "<i>YourGroupName</i>*"} -Properties * | Select SamAccountName,ObjectSid`
         *
         * In that command, replace *YourGroupName* with the name of your Active Directory group.
         *
         * The regex used to validate this parameter is a string of characters consisting of uppercase and lowercase alphanumeric characters with no spaces. You can also include underscores or any of the following characters: =,.@:/-
         */
        var externalId: kotlin.String? = null
        /**
         * The landing directory (folder) for a user when they log in to the server using the client.
         *
         * A `HomeDirectory` example is `/bucket_name/home/mydirectory`.
         */
        var homeDirectory: kotlin.String? = null
        /**
         * The type of landing directory (folder) you want your users' home directory to be when they log into the server. If you set it to `PATH`, the user will see the absolute Amazon S3 bucket or EFS paths as is in their file transfer protocol clients. If you set it `LOGICAL`, you need to provide mappings in the `HomeDirectoryMappings` for how you want to make Amazon S3 or EFS paths visible to your users.
         */
        var homeDirectoryType: aws.sdk.kotlin.services.transfer.model.HomeDirectoryType? = null
        /**
         * Specifies the Amazon Resource Name (ARN) of the IAM role that controls your users' access to your Amazon S3 bucket or EFS file system. The policies attached to this role determine the level of access that you want to provide your users when transferring files into and out of your Amazon S3 bucket or EFS file system. The IAM role should also contain a trust relationship that allows the server to access your resources when servicing your users' transfer requests.
         */
        var role: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.transfer.model.ListedAccess) : this() {
            this.externalId = x.externalId
            this.homeDirectory = x.homeDirectory
            this.homeDirectoryType = x.homeDirectoryType
            this.role = x.role
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.transfer.model.ListedAccess = ListedAccess(this)
    }
}
