// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.transfer.model



/**
 * Returns properties of the execution that is specified.
 */
class ListedExecution private constructor(builder: Builder) {
    /**
     * A unique identifier for the execution of a workflow.
     */
    val executionId: kotlin.String? = builder.executionId
    /**
     * A structure that describes the Amazon S3 or EFS file location. This is the file location when the execution begins: if the file is being copied, this is the initial (as opposed to destination) file location.
     */
    val initialFileLocation: aws.sdk.kotlin.services.transfer.model.FileLocation? = builder.initialFileLocation
    /**
     * A container object for the session details associated with a workflow.
     */
    val serviceMetadata: aws.sdk.kotlin.services.transfer.model.ServiceMetadata? = builder.serviceMetadata
    /**
     * The status is one of the execution. Can be in progress, completed, exception encountered, or handling the exception.
     */
    val status: aws.sdk.kotlin.services.transfer.model.ExecutionStatus? = builder.status

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.transfer.model.ListedExecution = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListedExecution(")
        append("executionId=$executionId,")
        append("initialFileLocation=$initialFileLocation,")
        append("serviceMetadata=$serviceMetadata,")
        append("status=$status)")
    }

    override fun hashCode(): kotlin.Int {
        var result = executionId?.hashCode() ?: 0
        result = 31 * result + (initialFileLocation?.hashCode() ?: 0)
        result = 31 * result + (serviceMetadata?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListedExecution

        if (executionId != other.executionId) return false
        if (initialFileLocation != other.initialFileLocation) return false
        if (serviceMetadata != other.serviceMetadata) return false
        if (status != other.status) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.transfer.model.ListedExecution = Builder(this).apply(block).build()

    class Builder {
        /**
         * A unique identifier for the execution of a workflow.
         */
        var executionId: kotlin.String? = null
        /**
         * A structure that describes the Amazon S3 or EFS file location. This is the file location when the execution begins: if the file is being copied, this is the initial (as opposed to destination) file location.
         */
        var initialFileLocation: aws.sdk.kotlin.services.transfer.model.FileLocation? = null
        /**
         * A container object for the session details associated with a workflow.
         */
        var serviceMetadata: aws.sdk.kotlin.services.transfer.model.ServiceMetadata? = null
        /**
         * The status is one of the execution. Can be in progress, completed, exception encountered, or handling the exception.
         */
        var status: aws.sdk.kotlin.services.transfer.model.ExecutionStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.transfer.model.ListedExecution) : this() {
            this.executionId = x.executionId
            this.initialFileLocation = x.initialFileLocation
            this.serviceMetadata = x.serviceMetadata
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.transfer.model.ListedExecution = ListedExecution(this)

        /**
         * construct an [aws.sdk.kotlin.services.transfer.model.FileLocation] inside the given [block]
         */
        fun initialFileLocation(block: aws.sdk.kotlin.services.transfer.model.FileLocation.Builder.() -> kotlin.Unit) {
            this.initialFileLocation = aws.sdk.kotlin.services.transfer.model.FileLocation.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.transfer.model.ServiceMetadata] inside the given [block]
         */
        fun serviceMetadata(block: aws.sdk.kotlin.services.transfer.model.ServiceMetadata.Builder.() -> kotlin.Unit) {
            this.serviceMetadata = aws.sdk.kotlin.services.transfer.model.ServiceMetadata.invoke(block)
        }
    }
}
