// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.transfer.model



/**
 * Specifies the details for the file location for the file being used in the workflow. Only applicable if you are using S3 storage.
 */
class S3FileLocation private constructor(builder: Builder) {
    /**
     * Specifies the S3 bucket that contains the file being used.
     */
    val bucket: kotlin.String? = builder.bucket
    /**
     * The entity tag is a hash of the object. The ETag reflects changes only to the contents of an object, not its metadata.
     */
    val etag: kotlin.String? = builder.etag
    /**
     * The name assigned to the file when it was created in S3. You use the object key to retrieve the object.
     */
    val key: kotlin.String? = builder.key
    /**
     * Specifies the file version.
     */
    val versionId: kotlin.String? = builder.versionId

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.transfer.model.S3FileLocation = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("S3FileLocation(")
        append("bucket=$bucket,")
        append("etag=$etag,")
        append("key=$key,")
        append("versionId=$versionId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = bucket?.hashCode() ?: 0
        result = 31 * result + (etag?.hashCode() ?: 0)
        result = 31 * result + (key?.hashCode() ?: 0)
        result = 31 * result + (versionId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as S3FileLocation

        if (bucket != other.bucket) return false
        if (etag != other.etag) return false
        if (key != other.key) return false
        if (versionId != other.versionId) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.transfer.model.S3FileLocation = Builder(this).apply(block).build()

    class Builder {
        /**
         * Specifies the S3 bucket that contains the file being used.
         */
        var bucket: kotlin.String? = null
        /**
         * The entity tag is a hash of the object. The ETag reflects changes only to the contents of an object, not its metadata.
         */
        var etag: kotlin.String? = null
        /**
         * The name assigned to the file when it was created in S3. You use the object key to retrieve the object.
         */
        var key: kotlin.String? = null
        /**
         * Specifies the file version.
         */
        var versionId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.transfer.model.S3FileLocation) : this() {
            this.bucket = x.bucket
            this.etag = x.etag
            this.key = x.key
            this.versionId = x.versionId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.transfer.model.S3FileLocation = S3FileLocation(this)
    }
}
