// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.transfer.model



class TestIdentityProviderRequest private constructor(builder: Builder) {
    /**
     * A system-assigned identifier for a specific server. That server's user authentication method is tested with a user name and password.
     */
    val serverId: kotlin.String? = builder.serverId
    /**
     * The type of file transfer protocol to be tested.
     *
     * The available protocols are:
     * + Secure Shell (SSH) File Transfer Protocol (SFTP)
     * + File Transfer Protocol Secure (FTPS)
     * + File Transfer Protocol (FTP)
     */
    val serverProtocol: aws.sdk.kotlin.services.transfer.model.Protocol? = builder.serverProtocol
    /**
     * The source IP address of the user account to be tested.
     */
    val sourceIp: kotlin.String? = builder.sourceIp
    /**
     * The name of the user account to be tested.
     */
    val userName: kotlin.String? = builder.userName
    /**
     * The password of the user account to be tested.
     */
    val userPassword: kotlin.String? = builder.userPassword

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.transfer.model.TestIdentityProviderRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TestIdentityProviderRequest(")
        append("serverId=$serverId,")
        append("serverProtocol=$serverProtocol,")
        append("sourceIp=$sourceIp,")
        append("userName=$userName,")
        append("userPassword=*** Sensitive Data Redacted ***)")
    }

    override fun hashCode(): kotlin.Int {
        var result = serverId?.hashCode() ?: 0
        result = 31 * result + (serverProtocol?.hashCode() ?: 0)
        result = 31 * result + (sourceIp?.hashCode() ?: 0)
        result = 31 * result + (userName?.hashCode() ?: 0)
        result = 31 * result + (userPassword?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TestIdentityProviderRequest

        if (serverId != other.serverId) return false
        if (serverProtocol != other.serverProtocol) return false
        if (sourceIp != other.sourceIp) return false
        if (userName != other.userName) return false
        if (userPassword != other.userPassword) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.transfer.model.TestIdentityProviderRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * A system-assigned identifier for a specific server. That server's user authentication method is tested with a user name and password.
         */
        var serverId: kotlin.String? = null
        /**
         * The type of file transfer protocol to be tested.
         *
         * The available protocols are:
         * + Secure Shell (SSH) File Transfer Protocol (SFTP)
         * + File Transfer Protocol Secure (FTPS)
         * + File Transfer Protocol (FTP)
         */
        var serverProtocol: aws.sdk.kotlin.services.transfer.model.Protocol? = null
        /**
         * The source IP address of the user account to be tested.
         */
        var sourceIp: kotlin.String? = null
        /**
         * The name of the user account to be tested.
         */
        var userName: kotlin.String? = null
        /**
         * The password of the user account to be tested.
         */
        var userPassword: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.transfer.model.TestIdentityProviderRequest) : this() {
            this.serverId = x.serverId
            this.serverProtocol = x.serverProtocol
            this.sourceIp = x.sourceIp
            this.userName = x.userName
            this.userPassword = x.userPassword
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.transfer.model.TestIdentityProviderRequest = TestIdentityProviderRequest(this)
    }
}
