// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.transfer.model



class UpdateServerRequest private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the Amazon Web ServicesCertificate Manager (ACM) certificate. Required when `Protocols` is set to `FTPS`.
     *
     * To request a new public certificate, see [Request a public certificate](https://docs.aws.amazon.com/acm/latest/userguide/gs-acm-request-public.html) in the * Amazon Web ServicesCertificate Manager User Guide*.
     *
     * To import an existing certificate into ACM, see [Importing certificates into ACM](https://docs.aws.amazon.com/acm/latest/userguide/import-certificate.html) in the * Amazon Web ServicesCertificate Manager User Guide*.
     *
     * To request a private certificate to use FTPS through private IP addresses, see [Request a private certificate](https://docs.aws.amazon.com/acm/latest/userguide/gs-acm-request-private.html) in the * Amazon Web ServicesCertificate Manager User Guide*.
     *
     * Certificates with the following cryptographic algorithms and key sizes are supported:
     * + 2048-bit RSA (RSA_2048)
     * + 4096-bit RSA (RSA_4096)
     * + Elliptic Prime Curve 256 bit (EC_prime256v1)
     * + Elliptic Prime Curve 384 bit (EC_secp384r1)
     * + Elliptic Prime Curve 521 bit (EC_secp521r1)
     *
     * The certificate must be a valid SSL/TLS X.509 version 3 certificate with FQDN or IP address specified and information about the issuer.
     */
    val certificate: kotlin.String? = builder.certificate
    /**
     * The virtual private cloud (VPC) endpoint settings that are configured for your server. When you host your endpoint within your VPC, you can make it accessible only to resources within your VPC, or you can attach Elastic IP addresses and make it accessible to clients over the internet. Your VPC's default security groups are automatically assigned to your endpoint.
     */
    val endpointDetails: aws.sdk.kotlin.services.transfer.model.EndpointDetails? = builder.endpointDetails
    /**
     * The type of endpoint that you want your server to use. You can choose to make your server's endpoint publicly accessible (PUBLIC) or host it inside your VPC. With an endpoint that is hosted in a VPC, you can restrict access to your server and resources only within your VPC or choose to make it internet facing by attaching Elastic IP addresses directly to it.
     *
     *  After May 19, 2021, you won't be able to create a server using `EndpointType=VPC_ENDPOINT` in your Amazon Web Servicesaccount if your account hasn't already done so before May 19, 2021. If you have already created servers with `EndpointType=VPC_ENDPOINT` in your Amazon Web Servicesaccount on or before May 19, 2021, you will not be affected. After this date, use `EndpointType`=`VPC`.
     *
     * For more information, see https://docs.aws.amazon.com/transfer/latest/userguide/create-server-in-vpc.html#deprecate-vpc-endpoint.
     *
     * It is recommended that you use `VPC` as the `EndpointType`. With this endpoint type, you have the option to directly associate up to three Elastic IPv4 addresses (BYO IP included) with your server's endpoint and use VPC security groups to restrict traffic by the client's public IP address. This is not possible with `EndpointType` set to `VPC_ENDPOINT`.
     */
    val endpointType: aws.sdk.kotlin.services.transfer.model.EndpointType? = builder.endpointType
    /**
     * The RSA, ECDSA, or ED25519 private key to use for your server.
     *
     * Use the following command to generate an RSA 2048 bit key with no passphrase:
     *
     * `ssh-keygen -t rsa -b 2048 -N "" -m PEM -f my-new-server-key`.
     *
     * Use a minimum value of 2048 for the `-b` option: you can create a stronger key using 3072 or 4096.
     *
     * Use the following command to generate an ECDSA 256 bit key with no passphrase:
     *
     * `ssh-keygen -t ecdsa -b 256 -N "" -m PEM -f my-new-server-key`.
     *
     * Valid values for the `-b` option for ECDSA are 256, 384, and 521.
     *
     * Use the following command to generate an ED25519 key with no passphrase:
     *
     * `ssh-keygen -t ed25519 -N "" -f my-new-server-key`.
     *
     * For all of these commands, you can replace *my-new-server-key* with a string of your choice.
     *
     * If you aren't planning to migrate existing users from an existing SFTP-enabled server to a new server, don't update the host key. Accidentally changing a server's host key can be disruptive.
     *
     * For more information, see [Change the host key for your SFTP-enabled server](https://docs.aws.amazon.com/transfer/latest/userguide/edit-server-config.html#configuring-servers-change-host-key) in the *Amazon Web Services Transfer Family User Guide*.
     */
    val hostKey: kotlin.String? = builder.hostKey
    /**
     * An array containing all of the information required to call a customer's authentication API method.
     */
    val identityProviderDetails: aws.sdk.kotlin.services.transfer.model.IdentityProviderDetails? = builder.identityProviderDetails
    /**
     * Specifies the Amazon Resource Name (ARN) of the Amazon Web Services Identity and Access Management (IAM) role that allows a server to turn on Amazon CloudWatch logging for Amazon S3 or Amazon EFS events. When set, user activity can be viewed in your CloudWatch logs.
     */
    val loggingRole: kotlin.String? = builder.loggingRole
    /**
     * Specify a string to display when users connect to a server. This string is displayed after the user authenticates.
     *
     * The SFTP protocol does not support post-authentication display banners.
     */
    val postAuthenticationLoginBanner: kotlin.String? = builder.postAuthenticationLoginBanner
    /**
     * Specify a string to display when users connect to a server. This string is displayed before the user authenticates. For example, the following banner displays details about using the system.
     *
     * `This system is for the use of authorized users only. Individuals using this computer system without authority, or in excess of their authority, are subject to having all of their activities on this system monitored and recorded by system personnel.`
     */
    val preAuthenticationLoginBanner: kotlin.String? = builder.preAuthenticationLoginBanner
    /**
     * The protocol settings that are configured for your server.
     * +  Use the `PassiveIp` parameter to indicate passive mode (for FTP and FTPS protocols). Enter a single dotted-quad IPv4 address, such as the external IP address of a firewall, router, or load balancer.
     * + Use the `SetStatOption` to ignore the error that is generated when the client attempts to use SETSTAT on a file you are uploading to an S3 bucket. Set the value to `ENABLE_NO_OP` to have the Transfer Family server ignore the SETSTAT command, and upload files without needing to make any changes to your SFTP client. Note that with `SetStatOption` set to `ENABLE_NO_OP`, Transfer generates a log entry to CloudWatch Logs, so you can determine when the client is making a SETSTAT call.
     * + Use the `TlsSessionResumptionMode` parameter to determine whether or not your Transfer server resumes recent, negotiated sessions through a unique session ID.
     */
    val protocolDetails: aws.sdk.kotlin.services.transfer.model.ProtocolDetails? = builder.protocolDetails
    /**
     * Specifies the file transfer protocol or protocols over which your file transfer protocol client can connect to your server's endpoint. The available protocols are:
     * + Secure Shell (SSH) File Transfer Protocol (SFTP): File transfer over SSH
     * + File Transfer Protocol Secure (FTPS): File transfer with TLS encryption
     * + File Transfer Protocol (FTP): Unencrypted file transfer
     *
     * If you select `FTPS`, you must choose a certificate stored in Amazon Web ServicesCertificate Manager (ACM) which will be used to identify your server when clients connect to it over FTPS.
     *
     * If `Protocol` includes either `FTP` or `FTPS`, then the `EndpointType` must be `VPC` and the `IdentityProviderType` must be `AWS_DIRECTORY_SERVICE` or `API_GATEWAY`.
     *
     * If `Protocol` includes `FTP`, then `AddressAllocationIds` cannot be associated.
     *
     * If `Protocol` is set only to `SFTP`, the `EndpointType` can be set to `PUBLIC` and the `IdentityProviderType` can be set to `SERVICE_MANAGED`.
     */
    val protocols: List<Protocol>? = builder.protocols
    /**
     * Specifies the name of the security policy that is attached to the server.
     */
    val securityPolicyName: kotlin.String? = builder.securityPolicyName
    /**
     * A system-assigned unique identifier for a server instance that the user account is assigned to.
     */
    val serverId: kotlin.String? = builder.serverId
    /**
     * Specifies the workflow ID for the workflow to assign and the execution role used for executing the workflow.
     *
     * To remove an associated workflow from a server, you can provide an empty `OnUpload` object, as in the following example.
     *
     * `aws transfer update-server --server-id s-01234567890abcdef --workflow-details '{"OnUpload":[]}'`
     */
    val workflowDetails: aws.sdk.kotlin.services.transfer.model.WorkflowDetails? = builder.workflowDetails

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.transfer.model.UpdateServerRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateServerRequest(")
        append("certificate=$certificate,")
        append("endpointDetails=$endpointDetails,")
        append("endpointType=$endpointType,")
        append("hostKey=*** Sensitive Data Redacted ***,")
        append("identityProviderDetails=$identityProviderDetails,")
        append("loggingRole=$loggingRole,")
        append("postAuthenticationLoginBanner=$postAuthenticationLoginBanner,")
        append("preAuthenticationLoginBanner=$preAuthenticationLoginBanner,")
        append("protocolDetails=$protocolDetails,")
        append("protocols=$protocols,")
        append("securityPolicyName=$securityPolicyName,")
        append("serverId=$serverId,")
        append("workflowDetails=$workflowDetails)")
    }

    override fun hashCode(): kotlin.Int {
        var result = certificate?.hashCode() ?: 0
        result = 31 * result + (endpointDetails?.hashCode() ?: 0)
        result = 31 * result + (endpointType?.hashCode() ?: 0)
        result = 31 * result + (hostKey?.hashCode() ?: 0)
        result = 31 * result + (identityProviderDetails?.hashCode() ?: 0)
        result = 31 * result + (loggingRole?.hashCode() ?: 0)
        result = 31 * result + (postAuthenticationLoginBanner?.hashCode() ?: 0)
        result = 31 * result + (preAuthenticationLoginBanner?.hashCode() ?: 0)
        result = 31 * result + (protocolDetails?.hashCode() ?: 0)
        result = 31 * result + (protocols?.hashCode() ?: 0)
        result = 31 * result + (securityPolicyName?.hashCode() ?: 0)
        result = 31 * result + (serverId?.hashCode() ?: 0)
        result = 31 * result + (workflowDetails?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateServerRequest

        if (certificate != other.certificate) return false
        if (endpointDetails != other.endpointDetails) return false
        if (endpointType != other.endpointType) return false
        if (hostKey != other.hostKey) return false
        if (identityProviderDetails != other.identityProviderDetails) return false
        if (loggingRole != other.loggingRole) return false
        if (postAuthenticationLoginBanner != other.postAuthenticationLoginBanner) return false
        if (preAuthenticationLoginBanner != other.preAuthenticationLoginBanner) return false
        if (protocolDetails != other.protocolDetails) return false
        if (protocols != other.protocols) return false
        if (securityPolicyName != other.securityPolicyName) return false
        if (serverId != other.serverId) return false
        if (workflowDetails != other.workflowDetails) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.transfer.model.UpdateServerRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The Amazon Resource Name (ARN) of the Amazon Web ServicesCertificate Manager (ACM) certificate. Required when `Protocols` is set to `FTPS`.
         *
         * To request a new public certificate, see [Request a public certificate](https://docs.aws.amazon.com/acm/latest/userguide/gs-acm-request-public.html) in the * Amazon Web ServicesCertificate Manager User Guide*.
         *
         * To import an existing certificate into ACM, see [Importing certificates into ACM](https://docs.aws.amazon.com/acm/latest/userguide/import-certificate.html) in the * Amazon Web ServicesCertificate Manager User Guide*.
         *
         * To request a private certificate to use FTPS through private IP addresses, see [Request a private certificate](https://docs.aws.amazon.com/acm/latest/userguide/gs-acm-request-private.html) in the * Amazon Web ServicesCertificate Manager User Guide*.
         *
         * Certificates with the following cryptographic algorithms and key sizes are supported:
         * + 2048-bit RSA (RSA_2048)
         * + 4096-bit RSA (RSA_4096)
         * + Elliptic Prime Curve 256 bit (EC_prime256v1)
         * + Elliptic Prime Curve 384 bit (EC_secp384r1)
         * + Elliptic Prime Curve 521 bit (EC_secp521r1)
         *
         * The certificate must be a valid SSL/TLS X.509 version 3 certificate with FQDN or IP address specified and information about the issuer.
         */
        var certificate: kotlin.String? = null
        /**
         * The virtual private cloud (VPC) endpoint settings that are configured for your server. When you host your endpoint within your VPC, you can make it accessible only to resources within your VPC, or you can attach Elastic IP addresses and make it accessible to clients over the internet. Your VPC's default security groups are automatically assigned to your endpoint.
         */
        var endpointDetails: aws.sdk.kotlin.services.transfer.model.EndpointDetails? = null
        /**
         * The type of endpoint that you want your server to use. You can choose to make your server's endpoint publicly accessible (PUBLIC) or host it inside your VPC. With an endpoint that is hosted in a VPC, you can restrict access to your server and resources only within your VPC or choose to make it internet facing by attaching Elastic IP addresses directly to it.
         *
         *  After May 19, 2021, you won't be able to create a server using `EndpointType=VPC_ENDPOINT` in your Amazon Web Servicesaccount if your account hasn't already done so before May 19, 2021. If you have already created servers with `EndpointType=VPC_ENDPOINT` in your Amazon Web Servicesaccount on or before May 19, 2021, you will not be affected. After this date, use `EndpointType`=`VPC`.
         *
         * For more information, see https://docs.aws.amazon.com/transfer/latest/userguide/create-server-in-vpc.html#deprecate-vpc-endpoint.
         *
         * It is recommended that you use `VPC` as the `EndpointType`. With this endpoint type, you have the option to directly associate up to three Elastic IPv4 addresses (BYO IP included) with your server's endpoint and use VPC security groups to restrict traffic by the client's public IP address. This is not possible with `EndpointType` set to `VPC_ENDPOINT`.
         */
        var endpointType: aws.sdk.kotlin.services.transfer.model.EndpointType? = null
        /**
         * The RSA, ECDSA, or ED25519 private key to use for your server.
         *
         * Use the following command to generate an RSA 2048 bit key with no passphrase:
         *
         * `ssh-keygen -t rsa -b 2048 -N "" -m PEM -f my-new-server-key`.
         *
         * Use a minimum value of 2048 for the `-b` option: you can create a stronger key using 3072 or 4096.
         *
         * Use the following command to generate an ECDSA 256 bit key with no passphrase:
         *
         * `ssh-keygen -t ecdsa -b 256 -N "" -m PEM -f my-new-server-key`.
         *
         * Valid values for the `-b` option for ECDSA are 256, 384, and 521.
         *
         * Use the following command to generate an ED25519 key with no passphrase:
         *
         * `ssh-keygen -t ed25519 -N "" -f my-new-server-key`.
         *
         * For all of these commands, you can replace *my-new-server-key* with a string of your choice.
         *
         * If you aren't planning to migrate existing users from an existing SFTP-enabled server to a new server, don't update the host key. Accidentally changing a server's host key can be disruptive.
         *
         * For more information, see [Change the host key for your SFTP-enabled server](https://docs.aws.amazon.com/transfer/latest/userguide/edit-server-config.html#configuring-servers-change-host-key) in the *Amazon Web Services Transfer Family User Guide*.
         */
        var hostKey: kotlin.String? = null
        /**
         * An array containing all of the information required to call a customer's authentication API method.
         */
        var identityProviderDetails: aws.sdk.kotlin.services.transfer.model.IdentityProviderDetails? = null
        /**
         * Specifies the Amazon Resource Name (ARN) of the Amazon Web Services Identity and Access Management (IAM) role that allows a server to turn on Amazon CloudWatch logging for Amazon S3 or Amazon EFS events. When set, user activity can be viewed in your CloudWatch logs.
         */
        var loggingRole: kotlin.String? = null
        /**
         * Specify a string to display when users connect to a server. This string is displayed after the user authenticates.
         *
         * The SFTP protocol does not support post-authentication display banners.
         */
        var postAuthenticationLoginBanner: kotlin.String? = null
        /**
         * Specify a string to display when users connect to a server. This string is displayed before the user authenticates. For example, the following banner displays details about using the system.
         *
         * `This system is for the use of authorized users only. Individuals using this computer system without authority, or in excess of their authority, are subject to having all of their activities on this system monitored and recorded by system personnel.`
         */
        var preAuthenticationLoginBanner: kotlin.String? = null
        /**
         * The protocol settings that are configured for your server.
         * +  Use the `PassiveIp` parameter to indicate passive mode (for FTP and FTPS protocols). Enter a single dotted-quad IPv4 address, such as the external IP address of a firewall, router, or load balancer.
         * + Use the `SetStatOption` to ignore the error that is generated when the client attempts to use SETSTAT on a file you are uploading to an S3 bucket. Set the value to `ENABLE_NO_OP` to have the Transfer Family server ignore the SETSTAT command, and upload files without needing to make any changes to your SFTP client. Note that with `SetStatOption` set to `ENABLE_NO_OP`, Transfer generates a log entry to CloudWatch Logs, so you can determine when the client is making a SETSTAT call.
         * + Use the `TlsSessionResumptionMode` parameter to determine whether or not your Transfer server resumes recent, negotiated sessions through a unique session ID.
         */
        var protocolDetails: aws.sdk.kotlin.services.transfer.model.ProtocolDetails? = null
        /**
         * Specifies the file transfer protocol or protocols over which your file transfer protocol client can connect to your server's endpoint. The available protocols are:
         * + Secure Shell (SSH) File Transfer Protocol (SFTP): File transfer over SSH
         * + File Transfer Protocol Secure (FTPS): File transfer with TLS encryption
         * + File Transfer Protocol (FTP): Unencrypted file transfer
         *
         * If you select `FTPS`, you must choose a certificate stored in Amazon Web ServicesCertificate Manager (ACM) which will be used to identify your server when clients connect to it over FTPS.
         *
         * If `Protocol` includes either `FTP` or `FTPS`, then the `EndpointType` must be `VPC` and the `IdentityProviderType` must be `AWS_DIRECTORY_SERVICE` or `API_GATEWAY`.
         *
         * If `Protocol` includes `FTP`, then `AddressAllocationIds` cannot be associated.
         *
         * If `Protocol` is set only to `SFTP`, the `EndpointType` can be set to `PUBLIC` and the `IdentityProviderType` can be set to `SERVICE_MANAGED`.
         */
        var protocols: List<Protocol>? = null
        /**
         * Specifies the name of the security policy that is attached to the server.
         */
        var securityPolicyName: kotlin.String? = null
        /**
         * A system-assigned unique identifier for a server instance that the user account is assigned to.
         */
        var serverId: kotlin.String? = null
        /**
         * Specifies the workflow ID for the workflow to assign and the execution role used for executing the workflow.
         *
         * To remove an associated workflow from a server, you can provide an empty `OnUpload` object, as in the following example.
         *
         * `aws transfer update-server --server-id s-01234567890abcdef --workflow-details '{"OnUpload":[]}'`
         */
        var workflowDetails: aws.sdk.kotlin.services.transfer.model.WorkflowDetails? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.transfer.model.UpdateServerRequest) : this() {
            this.certificate = x.certificate
            this.endpointDetails = x.endpointDetails
            this.endpointType = x.endpointType
            this.hostKey = x.hostKey
            this.identityProviderDetails = x.identityProviderDetails
            this.loggingRole = x.loggingRole
            this.postAuthenticationLoginBanner = x.postAuthenticationLoginBanner
            this.preAuthenticationLoginBanner = x.preAuthenticationLoginBanner
            this.protocolDetails = x.protocolDetails
            this.protocols = x.protocols
            this.securityPolicyName = x.securityPolicyName
            this.serverId = x.serverId
            this.workflowDetails = x.workflowDetails
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.transfer.model.UpdateServerRequest = UpdateServerRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.transfer.model.EndpointDetails] inside the given [block]
         */
        fun endpointDetails(block: aws.sdk.kotlin.services.transfer.model.EndpointDetails.Builder.() -> kotlin.Unit) {
            this.endpointDetails = aws.sdk.kotlin.services.transfer.model.EndpointDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.transfer.model.IdentityProviderDetails] inside the given [block]
         */
        fun identityProviderDetails(block: aws.sdk.kotlin.services.transfer.model.IdentityProviderDetails.Builder.() -> kotlin.Unit) {
            this.identityProviderDetails = aws.sdk.kotlin.services.transfer.model.IdentityProviderDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.transfer.model.ProtocolDetails] inside the given [block]
         */
        fun protocolDetails(block: aws.sdk.kotlin.services.transfer.model.ProtocolDetails.Builder.() -> kotlin.Unit) {
            this.protocolDetails = aws.sdk.kotlin.services.transfer.model.ProtocolDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.transfer.model.WorkflowDetails] inside the given [block]
         */
        fun workflowDetails(block: aws.sdk.kotlin.services.transfer.model.WorkflowDetails.Builder.() -> kotlin.Unit) {
            this.workflowDetails = aws.sdk.kotlin.services.transfer.model.WorkflowDetails.invoke(block)
        }
    }
}
