// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.transfer.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.transfer.model.DescribeUserResponse
import aws.sdk.kotlin.services.transfer.model.DescribedUser
import aws.sdk.kotlin.services.transfer.model.TransferException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class DescribeUserOperationDeserializer: HttpDeserialize<DescribeUserResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeUserResponse {
        if (!response.status.isSuccess()) {
            throwDescribeUserError(context, response)
        }
        val builder = DescribeUserResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeUserOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDescribeUserError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw TransferException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalServiceError" -> InternalServiceErrorDeserializer().deserialize(context, wrappedResponse)
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ServiceUnavailableException" -> ServiceUnavailableExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> TransferException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeUserOperationBody(builder: DescribeUserResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val SERVERID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ServerId"))
    val USER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("User"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(SERVERID_DESCRIPTOR)
        field(USER_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                SERVERID_DESCRIPTOR.index -> builder.serverId = deserializeString()
                USER_DESCRIPTOR.index -> builder.user = deserializeDescribedUserDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
