// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.waf.model



/**
 * This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
 *
 * **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html). With the latest version, AWS WAF has a single set of endpoints for regional and global use.
 *
 * Specifies an `ActivatedRule` and indicates whether you want to add it to a `RuleGroup` or delete it from a `RuleGroup`.
 */
public class RuleGroupUpdate private constructor(builder: Builder) {
    /**
     * Specify `INSERT` to add an `ActivatedRule` to a `RuleGroup`. Use `DELETE` to remove an `ActivatedRule` from a `RuleGroup`.
     */
    public val action: aws.sdk.kotlin.services.waf.model.ChangeAction? = builder.action
    /**
     * The `ActivatedRule` object specifies a `Rule` that you want to insert or delete, the priority of the `Rule` in the `WebACL`, and the action that you want AWS WAF to take when a web request matches the `Rule` (`ALLOW`, `BLOCK`, or `COUNT`).
     */
    public val activatedRule: aws.sdk.kotlin.services.waf.model.ActivatedRule? = builder.activatedRule

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.waf.model.RuleGroupUpdate = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RuleGroupUpdate(")
        append("action=$action,")
        append("activatedRule=$activatedRule)")
    }

    override fun hashCode(): kotlin.Int {
        var result = action?.hashCode() ?: 0
        result = 31 * result + (activatedRule?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RuleGroupUpdate

        if (action != other.action) return false
        if (activatedRule != other.activatedRule) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.waf.model.RuleGroupUpdate = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Specify `INSERT` to add an `ActivatedRule` to a `RuleGroup`. Use `DELETE` to remove an `ActivatedRule` from a `RuleGroup`.
         */
        public var action: aws.sdk.kotlin.services.waf.model.ChangeAction? = null
        /**
         * The `ActivatedRule` object specifies a `Rule` that you want to insert or delete, the priority of the `Rule` in the `WebACL`, and the action that you want AWS WAF to take when a web request matches the `Rule` (`ALLOW`, `BLOCK`, or `COUNT`).
         */
        public var activatedRule: aws.sdk.kotlin.services.waf.model.ActivatedRule? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.waf.model.RuleGroupUpdate) : this() {
            this.action = x.action
            this.activatedRule = x.activatedRule
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.waf.model.RuleGroupUpdate = RuleGroupUpdate(this)

        /**
         * construct an [aws.sdk.kotlin.services.waf.model.ActivatedRule] inside the given [block]
         */
        public fun activatedRule(block: aws.sdk.kotlin.services.waf.model.ActivatedRule.Builder.() -> kotlin.Unit) {
            this.activatedRule = aws.sdk.kotlin.services.waf.model.ActivatedRule.invoke(block)
        }
    }
}
