// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.waf.model



/**
 * This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
 *
 * **For the latest version of AWS WAF**, use the AWS WAFV2 API and see the [AWS WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html). With the latest version, AWS WAF has a single set of endpoints for regional and global use.
 *
 * Specifies the part of a web request that you want to inspect for cross-site scripting attacks and indicates whether you want to add the specification to an XssMatchSet or delete it from an `XssMatchSet`.
 */
public class XssMatchSetUpdate private constructor(builder: Builder) {
    /**
     * Specify `INSERT` to add an XssMatchSetUpdate to an XssMatchSet. Use `DELETE` to remove an `XssMatchSetUpdate` from an `XssMatchSet`.
     */
    public val action: aws.sdk.kotlin.services.waf.model.ChangeAction? = builder.action
    /**
     * Specifies the part of a web request that you want AWS WAF to inspect for cross-site scripting attacks and, if you want AWS WAF to inspect a header, the name of the header.
     */
    public val xssMatchTuple: aws.sdk.kotlin.services.waf.model.XssMatchTuple? = builder.xssMatchTuple

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.waf.model.XssMatchSetUpdate = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("XssMatchSetUpdate(")
        append("action=$action,")
        append("xssMatchTuple=$xssMatchTuple)")
    }

    override fun hashCode(): kotlin.Int {
        var result = action?.hashCode() ?: 0
        result = 31 * result + (xssMatchTuple?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as XssMatchSetUpdate

        if (action != other.action) return false
        if (xssMatchTuple != other.xssMatchTuple) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.waf.model.XssMatchSetUpdate = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Specify `INSERT` to add an XssMatchSetUpdate to an XssMatchSet. Use `DELETE` to remove an `XssMatchSetUpdate` from an `XssMatchSet`.
         */
        public var action: aws.sdk.kotlin.services.waf.model.ChangeAction? = null
        /**
         * Specifies the part of a web request that you want AWS WAF to inspect for cross-site scripting attacks and, if you want AWS WAF to inspect a header, the name of the header.
         */
        public var xssMatchTuple: aws.sdk.kotlin.services.waf.model.XssMatchTuple? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.waf.model.XssMatchSetUpdate) : this() {
            this.action = x.action
            this.xssMatchTuple = x.xssMatchTuple
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.waf.model.XssMatchSetUpdate = XssMatchSetUpdate(this)

        /**
         * construct an [aws.sdk.kotlin.services.waf.model.XssMatchTuple] inside the given [block]
         */
        public fun xssMatchTuple(block: aws.sdk.kotlin.services.waf.model.XssMatchTuple.Builder.() -> kotlin.Unit) {
            this.xssMatchTuple = aws.sdk.kotlin.services.waf.model.XssMatchTuple.invoke(block)
        }
    }
}
