// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.waf.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.waf.model.CreateRuleGroupResponse
import aws.sdk.kotlin.services.waf.model.RuleGroup
import aws.sdk.kotlin.services.waf.model.WafException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateRuleGroupOperationDeserializer: HttpDeserialize<CreateRuleGroupResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): CreateRuleGroupResponse {
        if (!response.status.isSuccess()) {
            throwCreateRuleGroupError(context, response)
        }
        val builder = CreateRuleGroupResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeCreateRuleGroupOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwCreateRuleGroupError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw WafException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "WAFBadRequestException" -> WafBadRequestExceptionDeserializer().deserialize(context, wrappedResponse)
        "WAFDisallowedNameException" -> WafDisallowedNameExceptionDeserializer().deserialize(context, wrappedResponse)
        "WAFInternalErrorException" -> WafInternalErrorExceptionDeserializer().deserialize(context, wrappedResponse)
        "WAFLimitsExceededException" -> WafLimitsExceededExceptionDeserializer().deserialize(context, wrappedResponse)
        "WAFStaleDataException" -> WafStaleDataExceptionDeserializer().deserialize(context, wrappedResponse)
        "WAFTagOperationException" -> WafTagOperationExceptionDeserializer().deserialize(context, wrappedResponse)
        "WAFTagOperationInternalErrorException" -> WafTagOperationInternalErrorExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> WafException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateRuleGroupOperationBody(builder: CreateRuleGroupResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CHANGETOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ChangeToken"))
    val RULEGROUP_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("RuleGroup"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CHANGETOKEN_DESCRIPTOR)
        field(RULEGROUP_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CHANGETOKEN_DESCRIPTOR.index -> builder.changeToken = deserializeString()
                RULEGROUP_DESCRIPTOR.index -> builder.ruleGroup = deserializeRuleGroupDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
