// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.waf.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.waf.model.GetRateBasedRuleManagedKeysResponse
import aws.sdk.kotlin.services.waf.model.WafException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class GetRateBasedRuleManagedKeysOperationDeserializer: HttpDeserialize<GetRateBasedRuleManagedKeysResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetRateBasedRuleManagedKeysResponse {
        if (!response.status.isSuccess()) {
            throwGetRateBasedRuleManagedKeysError(context, response)
        }
        val builder = GetRateBasedRuleManagedKeysResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetRateBasedRuleManagedKeysOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetRateBasedRuleManagedKeysError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw WafException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "WAFInternalErrorException" -> WafInternalErrorExceptionDeserializer().deserialize(context, wrappedResponse)
        "WAFInvalidAccountException" -> WafInvalidAccountExceptionDeserializer().deserialize(context, wrappedResponse)
        "WAFInvalidParameterException" -> WafInvalidParameterExceptionDeserializer().deserialize(context, wrappedResponse)
        "WAFNonexistentItemException" -> WafNonexistentItemExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> WafException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetRateBasedRuleManagedKeysOperationBody(builder: GetRateBasedRuleManagedKeysResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val MANAGEDKEYS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("ManagedKeys"))
    val NEXTMARKER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("NextMarker"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(MANAGEDKEYS_DESCRIPTOR)
        field(NEXTMARKER_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                MANAGEDKEYS_DESCRIPTOR.index -> builder.managedKeys =
                    deserializer.deserializeList(MANAGEDKEYS_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                NEXTMARKER_DESCRIPTOR.index -> builder.nextMarker = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
