// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.waf.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.waf.model.GetRegexMatchSetResponse
import aws.sdk.kotlin.services.waf.model.RegexMatchSet
import aws.sdk.kotlin.services.waf.model.WafException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class GetRegexMatchSetOperationDeserializer: HttpDeserialize<GetRegexMatchSetResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetRegexMatchSetResponse {
        if (!response.status.isSuccess()) {
            throwGetRegexMatchSetError(context, response)
        }
        val builder = GetRegexMatchSetResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetRegexMatchSetOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetRegexMatchSetError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw WafException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "WAFInternalErrorException" -> WafInternalErrorExceptionDeserializer().deserialize(context, wrappedResponse)
        "WAFInvalidAccountException" -> WafInvalidAccountExceptionDeserializer().deserialize(context, wrappedResponse)
        "WAFNonexistentItemException" -> WafNonexistentItemExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> WafException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetRegexMatchSetOperationBody(builder: GetRegexMatchSetResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val REGEXMATCHSET_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("RegexMatchSet"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(REGEXMATCHSET_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                REGEXMATCHSET_DESCRIPTOR.index -> builder.regexMatchSet = deserializeRegexMatchSetDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
