// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.wafv2

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.borrow
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.wafv2.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.wafv2.model.*
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.endpoints.EndpointResolver
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy

/**
 * # WAF
 * This is the latest version of the **WAF** API, released in November, 2019. The names of the entities that you use to access this API, like endpoints and namespaces, all have the versioning information added, like "V2" or "v2", to distinguish from the prior version. We recommend migrating your resources to this version, because it has a number of significant improvements.
 *
 * If you used WAF prior to this release, you can't use this WAFV2 API to access any WAF resources that you created before. You can access your old rules, web ACLs, and other WAF resources only through the WAF Classic APIs. The WAF Classic APIs have retained the prior names, endpoints, and namespaces.
 *
 * For information, including how to migrate your WAF resources to this version, see the [WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
 *
 * WAF is a web application firewall that lets you monitor the HTTP and HTTPS requests that are forwarded to Amazon CloudFront, an Amazon API Gateway REST API, an Application Load Balancer, or an AppSync GraphQL API. WAF also lets you control access to your content. Based on conditions that you specify, such as the IP addresses that requests originate from or the values of query strings, the Amazon API Gateway REST API, CloudFront distribution, the Application Load Balancer, or the AppSync GraphQL API responds to requests either with the requested content or with an HTTP 403 status code (Forbidden). You also can configure CloudFront to return a custom error page when a request is blocked.
 *
 * This API guide is for developers who need detailed information about WAF API actions, data types, and errors. For detailed information about WAF features and an overview of how to use WAF, see the [WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/what-is-aws-waf.html).
 *
 * You can make calls using the endpoints listed in [WAF endpoints and quotas](https://docs.aws.amazon.com/general/latest/gr/waf.html).
 * + For regional applications, you can use any of the endpoints in the list. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API.
 * + For Amazon CloudFront applications, you must use the API endpoint listed for US East (N. Virginia): us-east-1.
 *
 * Alternatively, you can use one of the Amazon Web Services SDKs to access an API that's tailored to the programming language or platform that you're using. For more information, see [Amazon Web Services SDKs](http://aws.amazon.com/tools/#SDKs).
 *
 * We currently provide two versions of the WAF API: this API and the prior versions, the classic WAF APIs. This new API provides the same functionality as the older versions, with the following major improvements:
 * + You use one API for both global and regional applications. Where you need to distinguish the scope, you specify a `Scope` parameter and set it to `CLOUDFRONT` or `REGIONAL`.
 * + You can define a web ACL or rule group with a single call, and update it with a single call. You define all rule specifications in JSON format, and pass them to your rule group or web ACL calls.
 * + The limits WAF places on the use of rules more closely reflects the cost of running each type of rule. Rule groups include capacity settings, so you know the maximum cost of a rule group when you use it.
 */
interface Wafv2Client : SdkClient {

    override val serviceName: String
        get() = "WAFV2"
    /**
     * Wafv2Client's configuration
     */
    val config: Config

    companion object {
        operator fun invoke(block: Config.Builder.() -> Unit): Wafv2Client {
            val config = Config.Builder().apply(block).build()
            return DefaultWafv2Client(config)
        }

        operator fun invoke(config: Config): Wafv2Client = DefaultWafv2Client(config)

        /**
         * Construct a [Wafv2Client] by resolving the configuration from the current environment.
         */
        suspend fun fromEnvironment(block: (Config.Builder.() -> Unit)? = null): Wafv2Client {
            val builder = Config.Builder()
            if (block != null) builder.apply(block)
            builder.region = builder.region ?: resolveRegion()
            return DefaultWafv2Client(builder.build())
        }
    }

    class Config private constructor(builder: Builder): HttpClientConfig, SdkClientConfig {
        val credentialsProvider: CredentialsProvider = builder.credentialsProvider?.borrow() ?: DefaultChainCredentialsProvider()
        val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        val retryStrategy: RetryStrategy = StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        val signer: AwsSigner = builder.signer ?: DefaultAwsSigner
        companion object {
            inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        class Builder {
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            var credentialsProvider: CredentialsProvider? = null
            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            var endpointResolver: AwsEndpointResolver? = null
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            var httpClientEngine: HttpClientEngine? = null
            /**
             * AWS region to make requests to
             */
            var region: String? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            var sdkLogMode: SdkLogMode = SdkLogMode.Default
            /**
             * The implementation of AWS signer to use for signing requests
             */
            var signer: AwsSigner? = null

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * Associates a web ACL with a regional application resource, to protect the resource. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API.
     *
     * For Amazon CloudFront, don't use this call. Instead, use your CloudFront distribution configuration. To associate a web ACL, in the CloudFront call `UpdateDistribution`, set the web ACL ID to the Amazon Resource Name (ARN) of the web ACL. For information, see [UpdateDistribution](https://docs.aws.amazon.com/cloudfront/latest/APIReference/API_UpdateDistribution.html).
     *
     * When you make changes to web ACLs or web ACL components, like rules and rule groups, WAF propagates the changes everywhere that the web ACL and its components are stored and used. Your changes are applied within seconds, but there might be a brief period of inconsistency when the changes have arrived in some places and not in others. So, for example, if you change a rule action setting, the action might be the old action in one area and the new action in another area. Or if you add an IP address to an IP set used in a blocking rule, the new address might briefly be blocked in one area while still allowed in another. This temporary inconsistency can occur when you first associate a web ACL with an Amazon Web Services resource and when you change a web ACL that is already associated with a resource. Generally, any inconsistencies of this type last only a few seconds.
     */
    suspend fun associateWebAcl(input: AssociateWebAclRequest): AssociateWebAclResponse

    /**
     * Associates a web ACL with a regional application resource, to protect the resource. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API.
     *
     * For Amazon CloudFront, don't use this call. Instead, use your CloudFront distribution configuration. To associate a web ACL, in the CloudFront call `UpdateDistribution`, set the web ACL ID to the Amazon Resource Name (ARN) of the web ACL. For information, see [UpdateDistribution](https://docs.aws.amazon.com/cloudfront/latest/APIReference/API_UpdateDistribution.html).
     *
     * When you make changes to web ACLs or web ACL components, like rules and rule groups, WAF propagates the changes everywhere that the web ACL and its components are stored and used. Your changes are applied within seconds, but there might be a brief period of inconsistency when the changes have arrived in some places and not in others. So, for example, if you change a rule action setting, the action might be the old action in one area and the new action in another area. Or if you add an IP address to an IP set used in a blocking rule, the new address might briefly be blocked in one area while still allowed in another. This temporary inconsistency can occur when you first associate a web ACL with an Amazon Web Services resource and when you change a web ACL that is already associated with a resource. Generally, any inconsistencies of this type last only a few seconds.
     */
    suspend fun associateWebAcl(block: AssociateWebAclRequest.Builder.() -> Unit) = associateWebAcl(AssociateWebAclRequest.Builder().apply(block).build())

    /**
     * Returns the web ACL capacity unit (WCU) requirements for a specified scope and set of rules. You can use this to check the capacity requirements for the rules you want to use in a RuleGroup or WebACL.
     *
     * WAF uses WCUs to calculate and control the operating resources that are used to run your rules, rule groups, and web ACLs. WAF calculates capacity differently for each rule type, to reflect the relative cost of each rule. Simple rules that cost little to run use fewer WCUs than more complex rules that use more processing power. Rule group capacity is fixed at creation, which helps users plan their web ACL WCU usage when they use a rule group. The WCU limit for web ACLs is 1,500.
     */
    suspend fun checkCapacity(input: CheckCapacityRequest): CheckCapacityResponse

    /**
     * Returns the web ACL capacity unit (WCU) requirements for a specified scope and set of rules. You can use this to check the capacity requirements for the rules you want to use in a RuleGroup or WebACL.
     *
     * WAF uses WCUs to calculate and control the operating resources that are used to run your rules, rule groups, and web ACLs. WAF calculates capacity differently for each rule type, to reflect the relative cost of each rule. Simple rules that cost little to run use fewer WCUs than more complex rules that use more processing power. Rule group capacity is fixed at creation, which helps users plan their web ACL WCU usage when they use a rule group. The WCU limit for web ACLs is 1,500.
     */
    suspend fun checkCapacity(block: CheckCapacityRequest.Builder.() -> Unit) = checkCapacity(CheckCapacityRequest.Builder().apply(block).build())

    /**
     * Creates an IPSet, which you use to identify web requests that originate from specific IP addresses or ranges of IP addresses. For example, if you're receiving a lot of requests from a ranges of IP addresses, you can configure WAF to block them using an IPSet that lists those IP addresses.
     */
    suspend fun createIpSet(input: CreateIpSetRequest): CreateIpSetResponse

    /**
     * Creates an IPSet, which you use to identify web requests that originate from specific IP addresses or ranges of IP addresses. For example, if you're receiving a lot of requests from a ranges of IP addresses, you can configure WAF to block them using an IPSet that lists those IP addresses.
     */
    suspend fun createIpSet(block: CreateIpSetRequest.Builder.() -> Unit) = createIpSet(CreateIpSetRequest.Builder().apply(block).build())

    /**
     * Creates a RegexPatternSet, which you reference in a RegexPatternSetReferenceStatement, to have WAF inspect a web request component for the specified patterns.
     */
    suspend fun createRegexPatternSet(input: CreateRegexPatternSetRequest): CreateRegexPatternSetResponse

    /**
     * Creates a RegexPatternSet, which you reference in a RegexPatternSetReferenceStatement, to have WAF inspect a web request component for the specified patterns.
     */
    suspend fun createRegexPatternSet(block: CreateRegexPatternSetRequest.Builder.() -> Unit) = createRegexPatternSet(CreateRegexPatternSetRequest.Builder().apply(block).build())

    /**
     * Creates a RuleGroup per the specifications provided.
     *
     *  A rule group defines a collection of rules to inspect and control web requests that you can use in a WebACL. When you create a rule group, you define an immutable capacity limit. If you update a rule group, you must stay within the capacity. This allows others to reuse the rule group with confidence in its capacity requirements.
     */
    suspend fun createRuleGroup(input: CreateRuleGroupRequest): CreateRuleGroupResponse

    /**
     * Creates a RuleGroup per the specifications provided.
     *
     *  A rule group defines a collection of rules to inspect and control web requests that you can use in a WebACL. When you create a rule group, you define an immutable capacity limit. If you update a rule group, you must stay within the capacity. This allows others to reuse the rule group with confidence in its capacity requirements.
     */
    suspend fun createRuleGroup(block: CreateRuleGroupRequest.Builder.() -> Unit) = createRuleGroup(CreateRuleGroupRequest.Builder().apply(block).build())

    /**
     * Creates a WebACL per the specifications provided.
     *
     *  A web ACL defines a collection of rules to use to inspect and control web requests. Each rule has an action defined (allow, block, or count) for requests that match the statement of the rule. In the web ACL, you assign a default action to take (allow, block) for any request that does not match any of the rules. The rules in a web ACL can be a combination of the types Rule, RuleGroup, and managed rule group. You can associate a web ACL with one or more Amazon Web Services resources to protect. The resources can be an Amazon CloudFront distribution, an Amazon API Gateway REST API, an Application Load Balancer, or an AppSync GraphQL API.
     */
    suspend fun createWebAcl(input: CreateWebAclRequest): CreateWebAclResponse

    /**
     * Creates a WebACL per the specifications provided.
     *
     *  A web ACL defines a collection of rules to use to inspect and control web requests. Each rule has an action defined (allow, block, or count) for requests that match the statement of the rule. In the web ACL, you assign a default action to take (allow, block) for any request that does not match any of the rules. The rules in a web ACL can be a combination of the types Rule, RuleGroup, and managed rule group. You can associate a web ACL with one or more Amazon Web Services resources to protect. The resources can be an Amazon CloudFront distribution, an Amazon API Gateway REST API, an Application Load Balancer, or an AppSync GraphQL API.
     */
    suspend fun createWebAcl(block: CreateWebAclRequest.Builder.() -> Unit) = createWebAcl(CreateWebAclRequest.Builder().apply(block).build())

    /**
     * Deletes all rule groups that are managed by Firewall Manager for the specified web ACL.
     *
     * You can only use this if `ManagedByFirewallManager` is false in the specified WebACL.
     */
    suspend fun deleteFirewallManagerRuleGroups(input: DeleteFirewallManagerRuleGroupsRequest): DeleteFirewallManagerRuleGroupsResponse

    /**
     * Deletes all rule groups that are managed by Firewall Manager for the specified web ACL.
     *
     * You can only use this if `ManagedByFirewallManager` is false in the specified WebACL.
     */
    suspend fun deleteFirewallManagerRuleGroups(block: DeleteFirewallManagerRuleGroupsRequest.Builder.() -> Unit) = deleteFirewallManagerRuleGroups(DeleteFirewallManagerRuleGroupsRequest.Builder().apply(block).build())

    /**
     * Deletes the specified IPSet.
     */
    suspend fun deleteIpSet(input: DeleteIpSetRequest): DeleteIpSetResponse

    /**
     * Deletes the specified IPSet.
     */
    suspend fun deleteIpSet(block: DeleteIpSetRequest.Builder.() -> Unit) = deleteIpSet(DeleteIpSetRequest.Builder().apply(block).build())

    /**
     * Deletes the LoggingConfiguration from the specified web ACL.
     */
    suspend fun deleteLoggingConfiguration(input: DeleteLoggingConfigurationRequest): DeleteLoggingConfigurationResponse

    /**
     * Deletes the LoggingConfiguration from the specified web ACL.
     */
    suspend fun deleteLoggingConfiguration(block: DeleteLoggingConfigurationRequest.Builder.() -> Unit) = deleteLoggingConfiguration(DeleteLoggingConfigurationRequest.Builder().apply(block).build())

    /**
     * Permanently deletes an IAM policy from the specified rule group.
     *
     * You must be the owner of the rule group to perform this operation.
     */
    suspend fun deletePermissionPolicy(input: DeletePermissionPolicyRequest): DeletePermissionPolicyResponse

    /**
     * Permanently deletes an IAM policy from the specified rule group.
     *
     * You must be the owner of the rule group to perform this operation.
     */
    suspend fun deletePermissionPolicy(block: DeletePermissionPolicyRequest.Builder.() -> Unit) = deletePermissionPolicy(DeletePermissionPolicyRequest.Builder().apply(block).build())

    /**
     * Deletes the specified RegexPatternSet.
     */
    suspend fun deleteRegexPatternSet(input: DeleteRegexPatternSetRequest): DeleteRegexPatternSetResponse

    /**
     * Deletes the specified RegexPatternSet.
     */
    suspend fun deleteRegexPatternSet(block: DeleteRegexPatternSetRequest.Builder.() -> Unit) = deleteRegexPatternSet(DeleteRegexPatternSetRequest.Builder().apply(block).build())

    /**
     * Deletes the specified RuleGroup.
     */
    suspend fun deleteRuleGroup(input: DeleteRuleGroupRequest): DeleteRuleGroupResponse

    /**
     * Deletes the specified RuleGroup.
     */
    suspend fun deleteRuleGroup(block: DeleteRuleGroupRequest.Builder.() -> Unit) = deleteRuleGroup(DeleteRuleGroupRequest.Builder().apply(block).build())

    /**
     * Deletes the specified WebACL.
     *
     * You can only use this if `ManagedByFirewallManager` is false in the specified WebACL.
     *
     * Before deleting any web ACL, first disassociate it from all resources.
     * + To retrieve a list of the resources that are associated with a web ACL, use the following calls:
     *    + For regional resources, call ListResourcesForWebACL.
     *    + For Amazon CloudFront distributions, use the CloudFront call `ListDistributionsByWebACLId`. For information, see [ListDistributionsByWebACLId](https://docs.aws.amazon.com/cloudfront/latest/APIReference/API_ListDistributionsByWebACLId.html).
     * + To disassociate a resource from a web ACL, use the following calls:
     *    + For regional resources, call DisassociateWebACL.
     *    + For Amazon CloudFront distributions, provide an empty web ACL ID in the CloudFront call `UpdateDistribution`. For information, see [UpdateDistribution](https://docs.aws.amazon.com/cloudfront/latest/APIReference/API_UpdateDistribution.html).
     */
    suspend fun deleteWebAcl(input: DeleteWebAclRequest): DeleteWebAclResponse

    /**
     * Deletes the specified WebACL.
     *
     * You can only use this if `ManagedByFirewallManager` is false in the specified WebACL.
     *
     * Before deleting any web ACL, first disassociate it from all resources.
     * + To retrieve a list of the resources that are associated with a web ACL, use the following calls:
     *    + For regional resources, call ListResourcesForWebACL.
     *    + For Amazon CloudFront distributions, use the CloudFront call `ListDistributionsByWebACLId`. For information, see [ListDistributionsByWebACLId](https://docs.aws.amazon.com/cloudfront/latest/APIReference/API_ListDistributionsByWebACLId.html).
     * + To disassociate a resource from a web ACL, use the following calls:
     *    + For regional resources, call DisassociateWebACL.
     *    + For Amazon CloudFront distributions, provide an empty web ACL ID in the CloudFront call `UpdateDistribution`. For information, see [UpdateDistribution](https://docs.aws.amazon.com/cloudfront/latest/APIReference/API_UpdateDistribution.html).
     */
    suspend fun deleteWebAcl(block: DeleteWebAclRequest.Builder.() -> Unit) = deleteWebAcl(DeleteWebAclRequest.Builder().apply(block).build())

    /**
     * Provides high-level information for a managed rule group, including descriptions of the rules.
     */
    suspend fun describeManagedRuleGroup(input: DescribeManagedRuleGroupRequest): DescribeManagedRuleGroupResponse

    /**
     * Provides high-level information for a managed rule group, including descriptions of the rules.
     */
    suspend fun describeManagedRuleGroup(block: DescribeManagedRuleGroupRequest.Builder.() -> Unit) = describeManagedRuleGroup(DescribeManagedRuleGroupRequest.Builder().apply(block).build())

    /**
     * Disassociates the specified regional application resource from any existing web ACL association. A resource can have at most one web ACL association. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API.
     *
     * For Amazon CloudFront, don't use this call. Instead, use your CloudFront distribution configuration. To disassociate a web ACL, provide an empty web ACL ID in the CloudFront call `UpdateDistribution`. For information, see [UpdateDistribution](https://docs.aws.amazon.com/cloudfront/latest/APIReference/API_UpdateDistribution.html).
     */
    suspend fun disassociateWebAcl(input: DisassociateWebAclRequest): DisassociateWebAclResponse

    /**
     * Disassociates the specified regional application resource from any existing web ACL association. A resource can have at most one web ACL association. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API.
     *
     * For Amazon CloudFront, don't use this call. Instead, use your CloudFront distribution configuration. To disassociate a web ACL, provide an empty web ACL ID in the CloudFront call `UpdateDistribution`. For information, see [UpdateDistribution](https://docs.aws.amazon.com/cloudfront/latest/APIReference/API_UpdateDistribution.html).
     */
    suspend fun disassociateWebAcl(block: DisassociateWebAclRequest.Builder.() -> Unit) = disassociateWebAcl(DisassociateWebAclRequest.Builder().apply(block).build())

    /**
     * Generates a presigned download URL for the specified release of the mobile SDK.
     *
     * The mobile SDK is not generally available. Customers who have access to the mobile SDK can use it to establish and manage Security Token Service (STS) security tokens for use in HTTP(S) requests from a mobile device to WAF. For more information, see [WAF client application integration](https://docs.aws.amazon.com/waf/latest/developerguide/waf-application-integration.html) in the *WAF Developer Guide*.
     */
    suspend fun generateMobileSdkReleaseUrl(input: GenerateMobileSdkReleaseUrlRequest): GenerateMobileSdkReleaseUrlResponse

    /**
     * Generates a presigned download URL for the specified release of the mobile SDK.
     *
     * The mobile SDK is not generally available. Customers who have access to the mobile SDK can use it to establish and manage Security Token Service (STS) security tokens for use in HTTP(S) requests from a mobile device to WAF. For more information, see [WAF client application integration](https://docs.aws.amazon.com/waf/latest/developerguide/waf-application-integration.html) in the *WAF Developer Guide*.
     */
    suspend fun generateMobileSdkReleaseUrl(block: GenerateMobileSdkReleaseUrlRequest.Builder.() -> Unit) = generateMobileSdkReleaseUrl(GenerateMobileSdkReleaseUrlRequest.Builder().apply(block).build())

    /**
     * Retrieves the specified IPSet.
     */
    suspend fun getIpSet(input: GetIpSetRequest): GetIpSetResponse

    /**
     * Retrieves the specified IPSet.
     */
    suspend fun getIpSet(block: GetIpSetRequest.Builder.() -> Unit) = getIpSet(GetIpSetRequest.Builder().apply(block).build())

    /**
     * Returns the LoggingConfiguration for the specified web ACL.
     */
    suspend fun getLoggingConfiguration(input: GetLoggingConfigurationRequest): GetLoggingConfigurationResponse

    /**
     * Returns the LoggingConfiguration for the specified web ACL.
     */
    suspend fun getLoggingConfiguration(block: GetLoggingConfigurationRequest.Builder.() -> Unit) = getLoggingConfiguration(GetLoggingConfigurationRequest.Builder().apply(block).build())

    /**
     * Retrieves the specified managed rule set.
     *
     * This is intended for use only by vendors of managed rule sets. Vendors are Amazon Web Services and Amazon Web Services Marketplace sellers.
     *
     * Vendors, you can use the managed rule set APIs to provide controlled rollout of your versioned managed rule group offerings for your customers. The APIs are `ListManagedRuleSets`, `GetManagedRuleSet`, `PutManagedRuleSetVersions`, and `UpdateManagedRuleSetVersionExpiryDate`.
     */
    suspend fun getManagedRuleSet(input: GetManagedRuleSetRequest): GetManagedRuleSetResponse

    /**
     * Retrieves the specified managed rule set.
     *
     * This is intended for use only by vendors of managed rule sets. Vendors are Amazon Web Services and Amazon Web Services Marketplace sellers.
     *
     * Vendors, you can use the managed rule set APIs to provide controlled rollout of your versioned managed rule group offerings for your customers. The APIs are `ListManagedRuleSets`, `GetManagedRuleSet`, `PutManagedRuleSetVersions`, and `UpdateManagedRuleSetVersionExpiryDate`.
     */
    suspend fun getManagedRuleSet(block: GetManagedRuleSetRequest.Builder.() -> Unit) = getManagedRuleSet(GetManagedRuleSetRequest.Builder().apply(block).build())

    /**
     * Retrieves information for the specified mobile SDK release, including release notes and tags.
     *
     * The mobile SDK is not generally available. Customers who have access to the mobile SDK can use it to establish and manage Security Token Service (STS) security tokens for use in HTTP(S) requests from a mobile device to WAF. For more information, see [WAF client application integration](https://docs.aws.amazon.com/waf/latest/developerguide/waf-application-integration.html) in the *WAF Developer Guide*.
     */
    suspend fun getMobileSdkRelease(input: GetMobileSdkReleaseRequest): GetMobileSdkReleaseResponse

    /**
     * Retrieves information for the specified mobile SDK release, including release notes and tags.
     *
     * The mobile SDK is not generally available. Customers who have access to the mobile SDK can use it to establish and manage Security Token Service (STS) security tokens for use in HTTP(S) requests from a mobile device to WAF. For more information, see [WAF client application integration](https://docs.aws.amazon.com/waf/latest/developerguide/waf-application-integration.html) in the *WAF Developer Guide*.
     */
    suspend fun getMobileSdkRelease(block: GetMobileSdkReleaseRequest.Builder.() -> Unit) = getMobileSdkRelease(GetMobileSdkReleaseRequest.Builder().apply(block).build())

    /**
     * Returns the IAM policy that is attached to the specified rule group.
     *
     * You must be the owner of the rule group to perform this operation.
     */
    suspend fun getPermissionPolicy(input: GetPermissionPolicyRequest): GetPermissionPolicyResponse

    /**
     * Returns the IAM policy that is attached to the specified rule group.
     *
     * You must be the owner of the rule group to perform this operation.
     */
    suspend fun getPermissionPolicy(block: GetPermissionPolicyRequest.Builder.() -> Unit) = getPermissionPolicy(GetPermissionPolicyRequest.Builder().apply(block).build())

    /**
     * Retrieves the keys that are currently blocked by a rate-based rule instance. The maximum number of managed keys that can be blocked for a single rate-based rule instance is 10,000. If more than 10,000 addresses exceed the rate limit, those with the highest rates are blocked.
     *
     * For a rate-based rule that you've defined inside a rule group, provide the name of the rule group reference statement in your request, in addition to the rate-based rule name and the web ACL name.
     *
     * WAF monitors web requests and manages keys independently for each unique combination of web ACL, optional rule group, and rate-based rule. For example, if you define a rate-based rule inside a rule group, and then use the rule group in a web ACL, WAF monitors web requests and manages keys for that web ACL, rule group reference statement, and rate-based rule instance. If you use the same rule group in a second web ACL, WAF monitors web requests and manages keys for this second usage completely independent of your first.
     */
    suspend fun getRateBasedStatementManagedKeys(input: GetRateBasedStatementManagedKeysRequest): GetRateBasedStatementManagedKeysResponse

    /**
     * Retrieves the keys that are currently blocked by a rate-based rule instance. The maximum number of managed keys that can be blocked for a single rate-based rule instance is 10,000. If more than 10,000 addresses exceed the rate limit, those with the highest rates are blocked.
     *
     * For a rate-based rule that you've defined inside a rule group, provide the name of the rule group reference statement in your request, in addition to the rate-based rule name and the web ACL name.
     *
     * WAF monitors web requests and manages keys independently for each unique combination of web ACL, optional rule group, and rate-based rule. For example, if you define a rate-based rule inside a rule group, and then use the rule group in a web ACL, WAF monitors web requests and manages keys for that web ACL, rule group reference statement, and rate-based rule instance. If you use the same rule group in a second web ACL, WAF monitors web requests and manages keys for this second usage completely independent of your first.
     */
    suspend fun getRateBasedStatementManagedKeys(block: GetRateBasedStatementManagedKeysRequest.Builder.() -> Unit) = getRateBasedStatementManagedKeys(GetRateBasedStatementManagedKeysRequest.Builder().apply(block).build())

    /**
     * Retrieves the specified RegexPatternSet.
     */
    suspend fun getRegexPatternSet(input: GetRegexPatternSetRequest): GetRegexPatternSetResponse

    /**
     * Retrieves the specified RegexPatternSet.
     */
    suspend fun getRegexPatternSet(block: GetRegexPatternSetRequest.Builder.() -> Unit) = getRegexPatternSet(GetRegexPatternSetRequest.Builder().apply(block).build())

    /**
     * Retrieves the specified RuleGroup.
     */
    suspend fun getRuleGroup(input: GetRuleGroupRequest = GetRuleGroupRequest {}): GetRuleGroupResponse

    /**
     * Retrieves the specified RuleGroup.
     */
    suspend fun getRuleGroup(block: GetRuleGroupRequest.Builder.() -> Unit) = getRuleGroup(GetRuleGroupRequest.Builder().apply(block).build())

    /**
     * Gets detailed information about a specified number of requests--a sample--that WAF randomly selects from among the first 5,000 requests that your Amazon Web Services resource received during a time range that you choose. You can specify a sample size of up to 500 requests, and you can specify any time range in the previous three hours.
     *
     * `GetSampledRequests` returns a time range, which is usually the time range that you specified. However, if your resource (such as a CloudFront distribution) received 5,000 requests before the specified time range elapsed, `GetSampledRequests` returns an updated time range. This new time range indicates the actual period during which WAF selected the requests in the sample.
     */
    suspend fun getSampledRequests(input: GetSampledRequestsRequest): GetSampledRequestsResponse

    /**
     * Gets detailed information about a specified number of requests--a sample--that WAF randomly selects from among the first 5,000 requests that your Amazon Web Services resource received during a time range that you choose. You can specify a sample size of up to 500 requests, and you can specify any time range in the previous three hours.
     *
     * `GetSampledRequests` returns a time range, which is usually the time range that you specified. However, if your resource (such as a CloudFront distribution) received 5,000 requests before the specified time range elapsed, `GetSampledRequests` returns an updated time range. This new time range indicates the actual period during which WAF selected the requests in the sample.
     */
    suspend fun getSampledRequests(block: GetSampledRequestsRequest.Builder.() -> Unit) = getSampledRequests(GetSampledRequestsRequest.Builder().apply(block).build())

    /**
     * Retrieves the specified WebACL.
     */
    suspend fun getWebAcl(input: GetWebAclRequest): GetWebAclResponse

    /**
     * Retrieves the specified WebACL.
     */
    suspend fun getWebAcl(block: GetWebAclRequest.Builder.() -> Unit) = getWebAcl(GetWebAclRequest.Builder().apply(block).build())

    /**
     * Retrieves the WebACL for the specified resource.
     */
    suspend fun getWebAclForResource(input: GetWebAclForResourceRequest): GetWebAclForResourceResponse

    /**
     * Retrieves the WebACL for the specified resource.
     */
    suspend fun getWebAclForResource(block: GetWebAclForResourceRequest.Builder.() -> Unit) = getWebAclForResource(GetWebAclForResourceRequest.Builder().apply(block).build())

    /**
     * Returns a list of the available versions for the specified managed rule group.
     */
    suspend fun listAvailableManagedRuleGroupVersions(input: ListAvailableManagedRuleGroupVersionsRequest): ListAvailableManagedRuleGroupVersionsResponse

    /**
     * Returns a list of the available versions for the specified managed rule group.
     */
    suspend fun listAvailableManagedRuleGroupVersions(block: ListAvailableManagedRuleGroupVersionsRequest.Builder.() -> Unit) = listAvailableManagedRuleGroupVersions(ListAvailableManagedRuleGroupVersionsRequest.Builder().apply(block).build())

    /**
     * Retrieves an array of managed rule groups that are available for you to use. This list includes all Amazon Web Services Managed Rules rule groups and all of the Amazon Web Services Marketplace managed rule groups that you're subscribed to.
     */
    suspend fun listAvailableManagedRuleGroups(input: ListAvailableManagedRuleGroupsRequest): ListAvailableManagedRuleGroupsResponse

    /**
     * Retrieves an array of managed rule groups that are available for you to use. This list includes all Amazon Web Services Managed Rules rule groups and all of the Amazon Web Services Marketplace managed rule groups that you're subscribed to.
     */
    suspend fun listAvailableManagedRuleGroups(block: ListAvailableManagedRuleGroupsRequest.Builder.() -> Unit) = listAvailableManagedRuleGroups(ListAvailableManagedRuleGroupsRequest.Builder().apply(block).build())

    /**
     * Retrieves an array of IPSetSummary objects for the IP sets that you manage.
     */
    suspend fun listIpSets(input: ListIpSetsRequest): ListIpSetsResponse

    /**
     * Retrieves an array of IPSetSummary objects for the IP sets that you manage.
     */
    suspend fun listIpSets(block: ListIpSetsRequest.Builder.() -> Unit) = listIpSets(ListIpSetsRequest.Builder().apply(block).build())

    /**
     * Retrieves an array of your LoggingConfiguration objects.
     */
    suspend fun listLoggingConfigurations(input: ListLoggingConfigurationsRequest): ListLoggingConfigurationsResponse

    /**
     * Retrieves an array of your LoggingConfiguration objects.
     */
    suspend fun listLoggingConfigurations(block: ListLoggingConfigurationsRequest.Builder.() -> Unit) = listLoggingConfigurations(ListLoggingConfigurationsRequest.Builder().apply(block).build())

    /**
     * Retrieves the managed rule sets that you own.
     *
     * This is intended for use only by vendors of managed rule sets. Vendors are Amazon Web Services and Amazon Web Services Marketplace sellers.
     *
     * Vendors, you can use the managed rule set APIs to provide controlled rollout of your versioned managed rule group offerings for your customers. The APIs are `ListManagedRuleSets`, `GetManagedRuleSet`, `PutManagedRuleSetVersions`, and `UpdateManagedRuleSetVersionExpiryDate`.
     */
    suspend fun listManagedRuleSets(input: ListManagedRuleSetsRequest): ListManagedRuleSetsResponse

    /**
     * Retrieves the managed rule sets that you own.
     *
     * This is intended for use only by vendors of managed rule sets. Vendors are Amazon Web Services and Amazon Web Services Marketplace sellers.
     *
     * Vendors, you can use the managed rule set APIs to provide controlled rollout of your versioned managed rule group offerings for your customers. The APIs are `ListManagedRuleSets`, `GetManagedRuleSet`, `PutManagedRuleSetVersions`, and `UpdateManagedRuleSetVersionExpiryDate`.
     */
    suspend fun listManagedRuleSets(block: ListManagedRuleSetsRequest.Builder.() -> Unit) = listManagedRuleSets(ListManagedRuleSetsRequest.Builder().apply(block).build())

    /**
     * Retrieves a list of the available releases for the mobile SDK and the specified device platform.
     *
     * The mobile SDK is not generally available. Customers who have access to the mobile SDK can use it to establish and manage Security Token Service (STS) security tokens for use in HTTP(S) requests from a mobile device to WAF. For more information, see [WAF client application integration](https://docs.aws.amazon.com/waf/latest/developerguide/waf-application-integration.html) in the *WAF Developer Guide*.
     */
    suspend fun listMobileSdkReleases(input: ListMobileSdkReleasesRequest): ListMobileSdkReleasesResponse

    /**
     * Retrieves a list of the available releases for the mobile SDK and the specified device platform.
     *
     * The mobile SDK is not generally available. Customers who have access to the mobile SDK can use it to establish and manage Security Token Service (STS) security tokens for use in HTTP(S) requests from a mobile device to WAF. For more information, see [WAF client application integration](https://docs.aws.amazon.com/waf/latest/developerguide/waf-application-integration.html) in the *WAF Developer Guide*.
     */
    suspend fun listMobileSdkReleases(block: ListMobileSdkReleasesRequest.Builder.() -> Unit) = listMobileSdkReleases(ListMobileSdkReleasesRequest.Builder().apply(block).build())

    /**
     * Retrieves an array of RegexPatternSetSummary objects for the regex pattern sets that you manage.
     */
    suspend fun listRegexPatternSets(input: ListRegexPatternSetsRequest): ListRegexPatternSetsResponse

    /**
     * Retrieves an array of RegexPatternSetSummary objects for the regex pattern sets that you manage.
     */
    suspend fun listRegexPatternSets(block: ListRegexPatternSetsRequest.Builder.() -> Unit) = listRegexPatternSets(ListRegexPatternSetsRequest.Builder().apply(block).build())

    /**
     * Retrieves an array of the Amazon Resource Names (ARNs) for the regional resources that are associated with the specified web ACL. If you want the list of Amazon CloudFront resources, use the CloudFront call `ListDistributionsByWebACLId`.
     */
    suspend fun listResourcesForWebAcl(input: ListResourcesForWebAclRequest): ListResourcesForWebAclResponse

    /**
     * Retrieves an array of the Amazon Resource Names (ARNs) for the regional resources that are associated with the specified web ACL. If you want the list of Amazon CloudFront resources, use the CloudFront call `ListDistributionsByWebACLId`.
     */
    suspend fun listResourcesForWebAcl(block: ListResourcesForWebAclRequest.Builder.() -> Unit) = listResourcesForWebAcl(ListResourcesForWebAclRequest.Builder().apply(block).build())

    /**
     * Retrieves an array of RuleGroupSummary objects for the rule groups that you manage.
     */
    suspend fun listRuleGroups(input: ListRuleGroupsRequest): ListRuleGroupsResponse

    /**
     * Retrieves an array of RuleGroupSummary objects for the rule groups that you manage.
     */
    suspend fun listRuleGroups(block: ListRuleGroupsRequest.Builder.() -> Unit) = listRuleGroups(ListRuleGroupsRequest.Builder().apply(block).build())

    /**
     * Retrieves the TagInfoForResource for the specified resource. Tags are key:value pairs that you can use to categorize and manage your resources, for purposes like billing. For example, you might set the tag key to "customer" and the value to the customer name or ID. You can specify one or more tags to add to each Amazon Web Services resource, up to 50 tags for a resource.
     *
     * You can tag the Amazon Web Services resources that you manage through WAF: web ACLs, rule groups, IP sets, and regex pattern sets. You can't manage or view tags through the WAF console.
     */
    suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Retrieves the TagInfoForResource for the specified resource. Tags are key:value pairs that you can use to categorize and manage your resources, for purposes like billing. For example, you might set the tag key to "customer" and the value to the customer name or ID. You can specify one or more tags to add to each Amazon Web Services resource, up to 50 tags for a resource.
     *
     * You can tag the Amazon Web Services resources that you manage through WAF: web ACLs, rule groups, IP sets, and regex pattern sets. You can't manage or view tags through the WAF console.
     */
    suspend fun listTagsForResource(block: ListTagsForResourceRequest.Builder.() -> Unit) = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

    /**
     * Retrieves an array of WebACLSummary objects for the web ACLs that you manage.
     */
    suspend fun listWebAcLs(input: ListWebAcLsRequest): ListWebAcLsResponse

    /**
     * Retrieves an array of WebACLSummary objects for the web ACLs that you manage.
     */
    suspend fun listWebAcLs(block: ListWebAcLsRequest.Builder.() -> Unit) = listWebAcLs(ListWebAcLsRequest.Builder().apply(block).build())

    /**
     * Enables the specified LoggingConfiguration, to start logging from a web ACL, according to the configuration provided.
     *
     * You can define one logging destination per web ACL.
     *
     * You can access information about the traffic that WAF inspects using the following steps:
     * + Create your logging destination. You can use an Amazon CloudWatch Logs log group, an Amazon Simple Storage Service (Amazon S3) bucket, or an Amazon Kinesis Data Firehose. For information about configuring logging destinations and the permissions that are required for each, see [Logging web ACL traffic information](https://docs.aws.amazon.com/waf/latest/developerguide/logging.html) in the *WAF Developer Guide*.
     * + Associate your logging destination to your web ACL using a `PutLoggingConfiguration` request.
     *
     * When you successfully enable logging using a `PutLoggingConfiguration` request, WAF creates an additional role or policy that is required to write logs to the logging destination. For an Amazon CloudWatch Logs log group, WAF creates a resource policy on the log group. For an Amazon S3 bucket, WAF creates a bucket policy. For an Amazon Kinesis Data Firehose, WAF creates a service-linked role.
     *
     * For additional information about web ACL logging, see [Logging web ACL traffic information](https://docs.aws.amazon.com/waf/latest/developerguide/logging.html) in the *WAF Developer Guide*.
     *
     * This operation completely replaces the mutable specifications that you already have for the logging configuration with the ones that you provide to this call. To modify the logging configuration, retrieve it by calling GetLoggingConfiguration, update the settings as needed, and then provide the complete logging configuration specification to this call.
     */
    suspend fun putLoggingConfiguration(input: PutLoggingConfigurationRequest): PutLoggingConfigurationResponse

    /**
     * Enables the specified LoggingConfiguration, to start logging from a web ACL, according to the configuration provided.
     *
     * You can define one logging destination per web ACL.
     *
     * You can access information about the traffic that WAF inspects using the following steps:
     * + Create your logging destination. You can use an Amazon CloudWatch Logs log group, an Amazon Simple Storage Service (Amazon S3) bucket, or an Amazon Kinesis Data Firehose. For information about configuring logging destinations and the permissions that are required for each, see [Logging web ACL traffic information](https://docs.aws.amazon.com/waf/latest/developerguide/logging.html) in the *WAF Developer Guide*.
     * + Associate your logging destination to your web ACL using a `PutLoggingConfiguration` request.
     *
     * When you successfully enable logging using a `PutLoggingConfiguration` request, WAF creates an additional role or policy that is required to write logs to the logging destination. For an Amazon CloudWatch Logs log group, WAF creates a resource policy on the log group. For an Amazon S3 bucket, WAF creates a bucket policy. For an Amazon Kinesis Data Firehose, WAF creates a service-linked role.
     *
     * For additional information about web ACL logging, see [Logging web ACL traffic information](https://docs.aws.amazon.com/waf/latest/developerguide/logging.html) in the *WAF Developer Guide*.
     *
     * This operation completely replaces the mutable specifications that you already have for the logging configuration with the ones that you provide to this call. To modify the logging configuration, retrieve it by calling GetLoggingConfiguration, update the settings as needed, and then provide the complete logging configuration specification to this call.
     */
    suspend fun putLoggingConfiguration(block: PutLoggingConfigurationRequest.Builder.() -> Unit) = putLoggingConfiguration(PutLoggingConfigurationRequest.Builder().apply(block).build())

    /**
     * Defines the versions of your managed rule set that you are offering to the customers. Customers see your offerings as managed rule groups with versioning.
     *
     * This is intended for use only by vendors of managed rule sets. Vendors are Amazon Web Services and Amazon Web Services Marketplace sellers.
     *
     * Vendors, you can use the managed rule set APIs to provide controlled rollout of your versioned managed rule group offerings for your customers. The APIs are `ListManagedRuleSets`, `GetManagedRuleSet`, `PutManagedRuleSetVersions`, and `UpdateManagedRuleSetVersionExpiryDate`.
     *
     * Customers retrieve their managed rule group list by calling ListAvailableManagedRuleGroups. The name that you provide here for your managed rule set is the name the customer sees for the corresponding managed rule group. Customers can retrieve the available versions for a managed rule group by calling ListAvailableManagedRuleGroupVersions. You provide a rule group specification for each version. For each managed rule set, you must specify a version that you recommend using.
     *
     * To initiate the expiration of a managed rule group version, use UpdateManagedRuleSetVersionExpiryDate.
     */
    suspend fun putManagedRuleSetVersions(input: PutManagedRuleSetVersionsRequest): PutManagedRuleSetVersionsResponse

    /**
     * Defines the versions of your managed rule set that you are offering to the customers. Customers see your offerings as managed rule groups with versioning.
     *
     * This is intended for use only by vendors of managed rule sets. Vendors are Amazon Web Services and Amazon Web Services Marketplace sellers.
     *
     * Vendors, you can use the managed rule set APIs to provide controlled rollout of your versioned managed rule group offerings for your customers. The APIs are `ListManagedRuleSets`, `GetManagedRuleSet`, `PutManagedRuleSetVersions`, and `UpdateManagedRuleSetVersionExpiryDate`.
     *
     * Customers retrieve their managed rule group list by calling ListAvailableManagedRuleGroups. The name that you provide here for your managed rule set is the name the customer sees for the corresponding managed rule group. Customers can retrieve the available versions for a managed rule group by calling ListAvailableManagedRuleGroupVersions. You provide a rule group specification for each version. For each managed rule set, you must specify a version that you recommend using.
     *
     * To initiate the expiration of a managed rule group version, use UpdateManagedRuleSetVersionExpiryDate.
     */
    suspend fun putManagedRuleSetVersions(block: PutManagedRuleSetVersionsRequest.Builder.() -> Unit) = putManagedRuleSetVersions(PutManagedRuleSetVersionsRequest.Builder().apply(block).build())

    /**
     * Attaches an IAM policy to the specified resource. Use this to share a rule group across accounts.
     *
     * You must be the owner of the rule group to perform this operation.
     *
     * This action is subject to the following restrictions:
     * + You can attach only one policy with each `PutPermissionPolicy` request.
     * + The ARN in the request must be a valid WAF RuleGroup ARN and the rule group must exist in the same Region.
     * + The user making the request must be the owner of the rule group.
     */
    suspend fun putPermissionPolicy(input: PutPermissionPolicyRequest): PutPermissionPolicyResponse

    /**
     * Attaches an IAM policy to the specified resource. Use this to share a rule group across accounts.
     *
     * You must be the owner of the rule group to perform this operation.
     *
     * This action is subject to the following restrictions:
     * + You can attach only one policy with each `PutPermissionPolicy` request.
     * + The ARN in the request must be a valid WAF RuleGroup ARN and the rule group must exist in the same Region.
     * + The user making the request must be the owner of the rule group.
     */
    suspend fun putPermissionPolicy(block: PutPermissionPolicyRequest.Builder.() -> Unit) = putPermissionPolicy(PutPermissionPolicyRequest.Builder().apply(block).build())

    /**
     * Associates tags with the specified Amazon Web Services resource. Tags are key:value pairs that you can use to categorize and manage your resources, for purposes like billing. For example, you might set the tag key to "customer" and the value to the customer name or ID. You can specify one or more tags to add to each Amazon Web Services resource, up to 50 tags for a resource.
     *
     * You can tag the Amazon Web Services resources that you manage through WAF: web ACLs, rule groups, IP sets, and regex pattern sets. You can't manage or view tags through the WAF console.
     */
    suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Associates tags with the specified Amazon Web Services resource. Tags are key:value pairs that you can use to categorize and manage your resources, for purposes like billing. For example, you might set the tag key to "customer" and the value to the customer name or ID. You can specify one or more tags to add to each Amazon Web Services resource, up to 50 tags for a resource.
     *
     * You can tag the Amazon Web Services resources that you manage through WAF: web ACLs, rule groups, IP sets, and regex pattern sets. You can't manage or view tags through the WAF console.
     */
    suspend fun tagResource(block: TagResourceRequest.Builder.() -> Unit) = tagResource(TagResourceRequest.Builder().apply(block).build())

    /**
     * Disassociates tags from an Amazon Web Services resource. Tags are key:value pairs that you can associate with Amazon Web Services resources. For example, the tag key might be "customer" and the tag value might be "companyA." You can specify one or more tags to add to each container. You can add up to 50 tags to each Amazon Web Services resource.
     */
    suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Disassociates tags from an Amazon Web Services resource. Tags are key:value pairs that you can associate with Amazon Web Services resources. For example, the tag key might be "customer" and the tag value might be "companyA." You can specify one or more tags to add to each container. You can add up to 50 tags to each Amazon Web Services resource.
     */
    suspend fun untagResource(block: UntagResourceRequest.Builder.() -> Unit) = untagResource(UntagResourceRequest.Builder().apply(block).build())

    /**
     * Updates the specified IPSet.
     *
     * This operation completely replaces the mutable specifications that you already have for the IP set with the ones that you provide to this call. To modify the IP set, retrieve it by calling GetIPSet, update the settings as needed, and then provide the complete IP set specification to this call.
     *
     * When you make changes to web ACLs or web ACL components, like rules and rule groups, WAF propagates the changes everywhere that the web ACL and its components are stored and used. Your changes are applied within seconds, but there might be a brief period of inconsistency when the changes have arrived in some places and not in others. So, for example, if you change a rule action setting, the action might be the old action in one area and the new action in another area. Or if you add an IP address to an IP set used in a blocking rule, the new address might briefly be blocked in one area while still allowed in another. This temporary inconsistency can occur when you first associate a web ACL with an Amazon Web Services resource and when you change a web ACL that is already associated with a resource. Generally, any inconsistencies of this type last only a few seconds.
     */
    suspend fun updateIpSet(input: UpdateIpSetRequest): UpdateIpSetResponse

    /**
     * Updates the specified IPSet.
     *
     * This operation completely replaces the mutable specifications that you already have for the IP set with the ones that you provide to this call. To modify the IP set, retrieve it by calling GetIPSet, update the settings as needed, and then provide the complete IP set specification to this call.
     *
     * When you make changes to web ACLs or web ACL components, like rules and rule groups, WAF propagates the changes everywhere that the web ACL and its components are stored and used. Your changes are applied within seconds, but there might be a brief period of inconsistency when the changes have arrived in some places and not in others. So, for example, if you change a rule action setting, the action might be the old action in one area and the new action in another area. Or if you add an IP address to an IP set used in a blocking rule, the new address might briefly be blocked in one area while still allowed in another. This temporary inconsistency can occur when you first associate a web ACL with an Amazon Web Services resource and when you change a web ACL that is already associated with a resource. Generally, any inconsistencies of this type last only a few seconds.
     */
    suspend fun updateIpSet(block: UpdateIpSetRequest.Builder.() -> Unit) = updateIpSet(UpdateIpSetRequest.Builder().apply(block).build())

    /**
     * Updates the expiration information for your managed rule set. Use this to initiate the expiration of a managed rule group version. After you initiate expiration for a version, WAF excludes it from the reponse to ListAvailableManagedRuleGroupVersions for the managed rule group.
     *
     * This is intended for use only by vendors of managed rule sets. Vendors are Amazon Web Services and Amazon Web Services Marketplace sellers.
     *
     * Vendors, you can use the managed rule set APIs to provide controlled rollout of your versioned managed rule group offerings for your customers. The APIs are `ListManagedRuleSets`, `GetManagedRuleSet`, `PutManagedRuleSetVersions`, and `UpdateManagedRuleSetVersionExpiryDate`.
     */
    suspend fun updateManagedRuleSetVersionExpiryDate(input: UpdateManagedRuleSetVersionExpiryDateRequest): UpdateManagedRuleSetVersionExpiryDateResponse

    /**
     * Updates the expiration information for your managed rule set. Use this to initiate the expiration of a managed rule group version. After you initiate expiration for a version, WAF excludes it from the reponse to ListAvailableManagedRuleGroupVersions for the managed rule group.
     *
     * This is intended for use only by vendors of managed rule sets. Vendors are Amazon Web Services and Amazon Web Services Marketplace sellers.
     *
     * Vendors, you can use the managed rule set APIs to provide controlled rollout of your versioned managed rule group offerings for your customers. The APIs are `ListManagedRuleSets`, `GetManagedRuleSet`, `PutManagedRuleSetVersions`, and `UpdateManagedRuleSetVersionExpiryDate`.
     */
    suspend fun updateManagedRuleSetVersionExpiryDate(block: UpdateManagedRuleSetVersionExpiryDateRequest.Builder.() -> Unit) = updateManagedRuleSetVersionExpiryDate(UpdateManagedRuleSetVersionExpiryDateRequest.Builder().apply(block).build())

    /**
     * Updates the specified RegexPatternSet.
     *
     * This operation completely replaces the mutable specifications that you already have for the regex pattern set with the ones that you provide to this call. To modify the regex pattern set, retrieve it by calling GetRegexPatternSet, update the settings as needed, and then provide the complete regex pattern set specification to this call.
     *
     * When you make changes to web ACLs or web ACL components, like rules and rule groups, WAF propagates the changes everywhere that the web ACL and its components are stored and used. Your changes are applied within seconds, but there might be a brief period of inconsistency when the changes have arrived in some places and not in others. So, for example, if you change a rule action setting, the action might be the old action in one area and the new action in another area. Or if you add an IP address to an IP set used in a blocking rule, the new address might briefly be blocked in one area while still allowed in another. This temporary inconsistency can occur when you first associate a web ACL with an Amazon Web Services resource and when you change a web ACL that is already associated with a resource. Generally, any inconsistencies of this type last only a few seconds.
     */
    suspend fun updateRegexPatternSet(input: UpdateRegexPatternSetRequest): UpdateRegexPatternSetResponse

    /**
     * Updates the specified RegexPatternSet.
     *
     * This operation completely replaces the mutable specifications that you already have for the regex pattern set with the ones that you provide to this call. To modify the regex pattern set, retrieve it by calling GetRegexPatternSet, update the settings as needed, and then provide the complete regex pattern set specification to this call.
     *
     * When you make changes to web ACLs or web ACL components, like rules and rule groups, WAF propagates the changes everywhere that the web ACL and its components are stored and used. Your changes are applied within seconds, but there might be a brief period of inconsistency when the changes have arrived in some places and not in others. So, for example, if you change a rule action setting, the action might be the old action in one area and the new action in another area. Or if you add an IP address to an IP set used in a blocking rule, the new address might briefly be blocked in one area while still allowed in another. This temporary inconsistency can occur when you first associate a web ACL with an Amazon Web Services resource and when you change a web ACL that is already associated with a resource. Generally, any inconsistencies of this type last only a few seconds.
     */
    suspend fun updateRegexPatternSet(block: UpdateRegexPatternSetRequest.Builder.() -> Unit) = updateRegexPatternSet(UpdateRegexPatternSetRequest.Builder().apply(block).build())

    /**
     * Updates the specified RuleGroup.
     *
     * This operation completely replaces the mutable specifications that you already have for the rule group with the ones that you provide to this call. To modify the rule group, retrieve it by calling GetRuleGroup, update the settings as needed, and then provide the complete rule group specification to this call.
     *
     * When you make changes to web ACLs or web ACL components, like rules and rule groups, WAF propagates the changes everywhere that the web ACL and its components are stored and used. Your changes are applied within seconds, but there might be a brief period of inconsistency when the changes have arrived in some places and not in others. So, for example, if you change a rule action setting, the action might be the old action in one area and the new action in another area. Or if you add an IP address to an IP set used in a blocking rule, the new address might briefly be blocked in one area while still allowed in another. This temporary inconsistency can occur when you first associate a web ACL with an Amazon Web Services resource and when you change a web ACL that is already associated with a resource. Generally, any inconsistencies of this type last only a few seconds.
     *
     *  A rule group defines a collection of rules to inspect and control web requests that you can use in a WebACL. When you create a rule group, you define an immutable capacity limit. If you update a rule group, you must stay within the capacity. This allows others to reuse the rule group with confidence in its capacity requirements.
     */
    suspend fun updateRuleGroup(input: UpdateRuleGroupRequest): UpdateRuleGroupResponse

    /**
     * Updates the specified RuleGroup.
     *
     * This operation completely replaces the mutable specifications that you already have for the rule group with the ones that you provide to this call. To modify the rule group, retrieve it by calling GetRuleGroup, update the settings as needed, and then provide the complete rule group specification to this call.
     *
     * When you make changes to web ACLs or web ACL components, like rules and rule groups, WAF propagates the changes everywhere that the web ACL and its components are stored and used. Your changes are applied within seconds, but there might be a brief period of inconsistency when the changes have arrived in some places and not in others. So, for example, if you change a rule action setting, the action might be the old action in one area and the new action in another area. Or if you add an IP address to an IP set used in a blocking rule, the new address might briefly be blocked in one area while still allowed in another. This temporary inconsistency can occur when you first associate a web ACL with an Amazon Web Services resource and when you change a web ACL that is already associated with a resource. Generally, any inconsistencies of this type last only a few seconds.
     *
     *  A rule group defines a collection of rules to inspect and control web requests that you can use in a WebACL. When you create a rule group, you define an immutable capacity limit. If you update a rule group, you must stay within the capacity. This allows others to reuse the rule group with confidence in its capacity requirements.
     */
    suspend fun updateRuleGroup(block: UpdateRuleGroupRequest.Builder.() -> Unit) = updateRuleGroup(UpdateRuleGroupRequest.Builder().apply(block).build())

    /**
     * Updates the specified WebACL. While updating a web ACL, WAF provides continous coverage to the resources that you have associated with the web ACL.
     *
     * When you make changes to web ACLs or web ACL components, like rules and rule groups, WAF propagates the changes everywhere that the web ACL and its components are stored and used. Your changes are applied within seconds, but there might be a brief period of inconsistency when the changes have arrived in some places and not in others. So, for example, if you change a rule action setting, the action might be the old action in one area and the new action in another area. Or if you add an IP address to an IP set used in a blocking rule, the new address might briefly be blocked in one area while still allowed in another. This temporary inconsistency can occur when you first associate a web ACL with an Amazon Web Services resource and when you change a web ACL that is already associated with a resource. Generally, any inconsistencies of this type last only a few seconds.
     *
     * This operation completely replaces the mutable specifications that you already have for the web ACL with the ones that you provide to this call. To modify the web ACL, retrieve it by calling GetWebACL, update the settings as needed, and then provide the complete web ACL specification to this call.
     *
     *  A web ACL defines a collection of rules to use to inspect and control web requests. Each rule has an action defined (allow, block, or count) for requests that match the statement of the rule. In the web ACL, you assign a default action to take (allow, block) for any request that does not match any of the rules. The rules in a web ACL can be a combination of the types Rule, RuleGroup, and managed rule group. You can associate a web ACL with one or more Amazon Web Services resources to protect. The resources can be an Amazon CloudFront distribution, an Amazon API Gateway REST API, an Application Load Balancer, or an AppSync GraphQL API.
     */
    suspend fun updateWebAcl(input: UpdateWebAclRequest): UpdateWebAclResponse

    /**
     * Updates the specified WebACL. While updating a web ACL, WAF provides continous coverage to the resources that you have associated with the web ACL.
     *
     * When you make changes to web ACLs or web ACL components, like rules and rule groups, WAF propagates the changes everywhere that the web ACL and its components are stored and used. Your changes are applied within seconds, but there might be a brief period of inconsistency when the changes have arrived in some places and not in others. So, for example, if you change a rule action setting, the action might be the old action in one area and the new action in another area. Or if you add an IP address to an IP set used in a blocking rule, the new address might briefly be blocked in one area while still allowed in another. This temporary inconsistency can occur when you first associate a web ACL with an Amazon Web Services resource and when you change a web ACL that is already associated with a resource. Generally, any inconsistencies of this type last only a few seconds.
     *
     * This operation completely replaces the mutable specifications that you already have for the web ACL with the ones that you provide to this call. To modify the web ACL, retrieve it by calling GetWebACL, update the settings as needed, and then provide the complete web ACL specification to this call.
     *
     *  A web ACL defines a collection of rules to use to inspect and control web requests. Each rule has an action defined (allow, block, or count) for requests that match the statement of the rule. In the web ACL, you assign a default action to take (allow, block) for any request that does not match any of the rules. The rules in a web ACL can be a combination of the types Rule, RuleGroup, and managed rule group. You can associate a web ACL with one or more Amazon Web Services resources to protect. The resources can be an Amazon CloudFront distribution, an Amazon API Gateway REST API, an Application Load Balancer, or an AppSync GraphQL API.
     */
    suspend fun updateWebAcl(block: UpdateWebAclRequest.Builder.() -> Unit) = updateWebAcl(UpdateWebAclRequest.Builder().apply(block).build())
}
