// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.wafv2.model



/**
 * Specifies that WAF should block the request and optionally defines additional custom handling for the response to the web request.
 *
 * This is used in the context of other settings, for example to specify values for RuleAction and web ACL DefaultAction.
 */
class BlockAction private constructor(builder: Builder) {
    /**
     * Defines a custom response for the web request.
     *
     * For information about customizing web requests and responses, see [Customizing web requests and responses in WAF](https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html) in the [WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
     */
    val customResponse: aws.sdk.kotlin.services.wafv2.model.CustomResponse? = builder.customResponse

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.wafv2.model.BlockAction = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("BlockAction(")
        append("customResponse=$customResponse)")
    }

    override fun hashCode(): kotlin.Int {
        var result = customResponse?.hashCode() ?: 0
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as BlockAction

        if (customResponse != other.customResponse) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.wafv2.model.BlockAction = Builder(this).apply(block).build()

    class Builder {
        /**
         * Defines a custom response for the web request.
         *
         * For information about customizing web requests and responses, see [Customizing web requests and responses in WAF](https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html) in the [WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
         */
        var customResponse: aws.sdk.kotlin.services.wafv2.model.CustomResponse? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.wafv2.model.BlockAction) : this() {
            this.customResponse = x.customResponse
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.wafv2.model.BlockAction = BlockAction(this)

        /**
         * construct an [aws.sdk.kotlin.services.wafv2.model.CustomResponse] inside the given [block]
         */
        fun customResponse(block: aws.sdk.kotlin.services.wafv2.model.CustomResponse.Builder.() -> kotlin.Unit) {
            this.customResponse = aws.sdk.kotlin.services.wafv2.model.CustomResponse.invoke(block)
        }
    }
}
