// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.wafv2.model



/**
 * A rule statement that defines a string match search for WAF to apply to web requests. The byte match statement provides the bytes to search for, the location in requests that you want WAF to search, and other settings. The bytes to search for are typically a string that corresponds with ASCII characters. In the WAF console and the developer guide, this is refered to as a string match statement.
 */
class ByteMatchStatement private constructor(builder: Builder) {
    /**
     * The part of the web request that you want WAF to inspect. For more information, see FieldToMatch.
     */
    val fieldToMatch: aws.sdk.kotlin.services.wafv2.model.FieldToMatch? = builder.fieldToMatch
    /**
     * The area within the portion of the web request that you want WAF to search for `SearchString`. Valid values include the following:
     *
     * **CONTAINS**
     *
     * The specified part of the web request must include the value of `SearchString`, but the location doesn't matter.
     *
     * **CONTAINS_WORD**
     *
     * The specified part of the web request must include the value of `SearchString`, and `SearchString` must contain only alphanumeric characters or underscore (A-Z, a-z, 0-9, or _). In addition, `SearchString` must be a word, which means that both of the following are true:
     * + `SearchString` is at the beginning of the specified part of the web request or is preceded by a character other than an alphanumeric character or underscore (_). Examples include the value of a header and `;BadBot`.
     * + `SearchString` is at the end of the specified part of the web request or is followed by a character other than an alphanumeric character or underscore (_), for example, `BadBot;` and `-BadBot;`.
     *
     * **EXACTLY**
     *
     * The value of the specified part of the web request must exactly match the value of `SearchString`.
     *
     * **STARTS_WITH**
     *
     * The value of `SearchString` must appear at the beginning of the specified part of the web request.
     *
     * **ENDS_WITH**
     *
     * The value of `SearchString` must appear at the end of the specified part of the web request.
     */
    val positionalConstraint: aws.sdk.kotlin.services.wafv2.model.PositionalConstraint? = builder.positionalConstraint
    /**
     * A string value that you want WAF to search for. WAF searches only in the part of web requests that you designate for inspection in FieldToMatch. The maximum length of the value is 50 bytes.
     *
     * Valid values depend on the component that you specify for inspection in `FieldToMatch`:
     * + `Method`: The HTTP method that you want WAF to search for. This indicates the type of operation specified in the request.
     * + `UriPath`: The value that you want WAF to search for in the URI path, for example, `/images/daily-ad.jpg`.
     *
     * If `SearchString` includes alphabetic characters A-Z and a-z, note that the value is case sensitive.
     *
     * **If you're using the WAF API**
     *
     * Specify a base64-encoded version of the value. The maximum length of the value before you base64-encode it is 50 bytes.
     *
     * For example, suppose the value of `Type` is `HEADER` and the value of `Data` is `User-Agent`. If you want to search the `User-Agent` header for the value `BadBot`, you base64-encode `BadBot` using MIME base64-encoding and include the resulting value, `QmFkQm90`, in the value of `SearchString`.
     *
     * **If you're using the CLI or one of the Amazon Web Services SDKs**
     *
     * The value that you want WAF to search for. The SDK automatically base64 encodes the value.
     */
    val searchString: kotlin.ByteArray? = builder.searchString
    /**
     * Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. If you specify one or more transformations in a rule statement, WAF performs all transformations on the content of the request component identified by `FieldToMatch`, starting from the lowest priority setting, before inspecting the content for a match.
     */
    val textTransformations: List<TextTransformation>? = builder.textTransformations

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.wafv2.model.ByteMatchStatement = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ByteMatchStatement(")
        append("fieldToMatch=$fieldToMatch,")
        append("positionalConstraint=$positionalConstraint,")
        append("searchString=$searchString,")
        append("textTransformations=$textTransformations)")
    }

    override fun hashCode(): kotlin.Int {
        var result = fieldToMatch?.hashCode() ?: 0
        result = 31 * result + (positionalConstraint?.hashCode() ?: 0)
        result = 31 * result + (searchString?.contentHashCode() ?: 0)
        result = 31 * result + (textTransformations?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ByteMatchStatement

        if (fieldToMatch != other.fieldToMatch) return false
        if (positionalConstraint != other.positionalConstraint) return false
        if (searchString != null) {
            if (other.searchString == null) return false
            if (!searchString.contentEquals(other.searchString)) return false
        } else if (other.searchString != null) return false
        if (textTransformations != other.textTransformations) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.wafv2.model.ByteMatchStatement = Builder(this).apply(block).build()

    class Builder {
        /**
         * The part of the web request that you want WAF to inspect. For more information, see FieldToMatch.
         */
        var fieldToMatch: aws.sdk.kotlin.services.wafv2.model.FieldToMatch? = null
        /**
         * The area within the portion of the web request that you want WAF to search for `SearchString`. Valid values include the following:
         *
         * **CONTAINS**
         *
         * The specified part of the web request must include the value of `SearchString`, but the location doesn't matter.
         *
         * **CONTAINS_WORD**
         *
         * The specified part of the web request must include the value of `SearchString`, and `SearchString` must contain only alphanumeric characters or underscore (A-Z, a-z, 0-9, or _). In addition, `SearchString` must be a word, which means that both of the following are true:
         * + `SearchString` is at the beginning of the specified part of the web request or is preceded by a character other than an alphanumeric character or underscore (_). Examples include the value of a header and `;BadBot`.
         * + `SearchString` is at the end of the specified part of the web request or is followed by a character other than an alphanumeric character or underscore (_), for example, `BadBot;` and `-BadBot;`.
         *
         * **EXACTLY**
         *
         * The value of the specified part of the web request must exactly match the value of `SearchString`.
         *
         * **STARTS_WITH**
         *
         * The value of `SearchString` must appear at the beginning of the specified part of the web request.
         *
         * **ENDS_WITH**
         *
         * The value of `SearchString` must appear at the end of the specified part of the web request.
         */
        var positionalConstraint: aws.sdk.kotlin.services.wafv2.model.PositionalConstraint? = null
        /**
         * A string value that you want WAF to search for. WAF searches only in the part of web requests that you designate for inspection in FieldToMatch. The maximum length of the value is 50 bytes.
         *
         * Valid values depend on the component that you specify for inspection in `FieldToMatch`:
         * + `Method`: The HTTP method that you want WAF to search for. This indicates the type of operation specified in the request.
         * + `UriPath`: The value that you want WAF to search for in the URI path, for example, `/images/daily-ad.jpg`.
         *
         * If `SearchString` includes alphabetic characters A-Z and a-z, note that the value is case sensitive.
         *
         * **If you're using the WAF API**
         *
         * Specify a base64-encoded version of the value. The maximum length of the value before you base64-encode it is 50 bytes.
         *
         * For example, suppose the value of `Type` is `HEADER` and the value of `Data` is `User-Agent`. If you want to search the `User-Agent` header for the value `BadBot`, you base64-encode `BadBot` using MIME base64-encoding and include the resulting value, `QmFkQm90`, in the value of `SearchString`.
         *
         * **If you're using the CLI or one of the Amazon Web Services SDKs**
         *
         * The value that you want WAF to search for. The SDK automatically base64 encodes the value.
         */
        var searchString: kotlin.ByteArray? = null
        /**
         * Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. If you specify one or more transformations in a rule statement, WAF performs all transformations on the content of the request component identified by `FieldToMatch`, starting from the lowest priority setting, before inspecting the content for a match.
         */
        var textTransformations: List<TextTransformation>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.wafv2.model.ByteMatchStatement) : this() {
            this.fieldToMatch = x.fieldToMatch
            this.positionalConstraint = x.positionalConstraint
            this.searchString = x.searchString
            this.textTransformations = x.textTransformations
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.wafv2.model.ByteMatchStatement = ByteMatchStatement(this)

        /**
         * construct an [aws.sdk.kotlin.services.wafv2.model.FieldToMatch] inside the given [block]
         */
        fun fieldToMatch(block: aws.sdk.kotlin.services.wafv2.model.FieldToMatch.Builder.() -> kotlin.Unit) {
            this.fieldToMatch = aws.sdk.kotlin.services.wafv2.model.FieldToMatch.invoke(block)
        }
    }
}
