// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.wafv2.model



class CreateRuleGroupRequest private constructor(builder: Builder) {
    /**
     * The web ACL capacity units (WCUs) required for this rule group.
     *
     * When you create your own rule group, you define this, and you cannot change it after creation. When you add or modify the rules in a rule group, WAF enforces this limit. You can check the capacity for a set of rules using CheckCapacity.
     *
     * WAF uses WCUs to calculate and control the operating resources that are used to run your rules, rule groups, and web ACLs. WAF calculates capacity differently for each rule type, to reflect the relative cost of each rule. Simple rules that cost little to run use fewer WCUs than more complex rules that use more processing power. Rule group capacity is fixed at creation, which helps users plan their web ACL WCU usage when they use a rule group. The WCU limit for web ACLs is 1,500.
     */
    val capacity: kotlin.Long = builder.capacity
    /**
     * A map of custom response keys and content bodies. When you create a rule with a block action, you can send a custom response to the web request. You define these for the rule group, and then use them in the rules that you define in the rule group.
     *
     * For information about customizing web requests and responses, see [Customizing web requests and responses in WAF](https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html) in the [WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
     *
     * For information about the limits on count and size for custom request and response settings, see [WAF quotas](https://docs.aws.amazon.com/waf/latest/developerguide/limits.html) in the [WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
     */
    val customResponseBodies: Map<String, CustomResponseBody>? = builder.customResponseBodies
    /**
     * A description of the rule group that helps with identification.
     */
    val description: kotlin.String? = builder.description
    /**
     * The name of the rule group. You cannot change the name of a rule group after you create it.
     */
    val name: kotlin.String? = builder.name
    /**
     * The Rule statements used to identify the web requests that you want to allow, block, or count. Each rule includes one top-level statement that WAF uses to identify matching web requests, and parameters that govern how WAF handles them.
     */
    val rules: List<Rule>? = builder.rules
    /**
     * Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API.
     *
     * To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows:
     * + CLI - Specify the Region when you use the CloudFront scope: `--scope=CLOUDFRONT --region=us-east-1`.
     * + API and SDKs - For all calls, use the Region endpoint us-east-1.
     */
    val scope: aws.sdk.kotlin.services.wafv2.model.Scope? = builder.scope
    /**
     * An array of key:value pairs to associate with the resource.
     */
    val tags: List<Tag>? = builder.tags
    /**
     * Defines and enables Amazon CloudWatch metrics and web request sample collection.
     */
    val visibilityConfig: aws.sdk.kotlin.services.wafv2.model.VisibilityConfig? = builder.visibilityConfig

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.wafv2.model.CreateRuleGroupRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateRuleGroupRequest(")
        append("capacity=$capacity,")
        append("customResponseBodies=$customResponseBodies,")
        append("description=$description,")
        append("name=$name,")
        append("rules=$rules,")
        append("scope=$scope,")
        append("tags=$tags,")
        append("visibilityConfig=$visibilityConfig)")
    }

    override fun hashCode(): kotlin.Int {
        var result = capacity.hashCode()
        result = 31 * result + (customResponseBodies?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (rules?.hashCode() ?: 0)
        result = 31 * result + (scope?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (visibilityConfig?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateRuleGroupRequest

        if (capacity != other.capacity) return false
        if (customResponseBodies != other.customResponseBodies) return false
        if (description != other.description) return false
        if (name != other.name) return false
        if (rules != other.rules) return false
        if (scope != other.scope) return false
        if (tags != other.tags) return false
        if (visibilityConfig != other.visibilityConfig) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.wafv2.model.CreateRuleGroupRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The web ACL capacity units (WCUs) required for this rule group.
         *
         * When you create your own rule group, you define this, and you cannot change it after creation. When you add or modify the rules in a rule group, WAF enforces this limit. You can check the capacity for a set of rules using CheckCapacity.
         *
         * WAF uses WCUs to calculate and control the operating resources that are used to run your rules, rule groups, and web ACLs. WAF calculates capacity differently for each rule type, to reflect the relative cost of each rule. Simple rules that cost little to run use fewer WCUs than more complex rules that use more processing power. Rule group capacity is fixed at creation, which helps users plan their web ACL WCU usage when they use a rule group. The WCU limit for web ACLs is 1,500.
         */
        var capacity: kotlin.Long = 0L
        /**
         * A map of custom response keys and content bodies. When you create a rule with a block action, you can send a custom response to the web request. You define these for the rule group, and then use them in the rules that you define in the rule group.
         *
         * For information about customizing web requests and responses, see [Customizing web requests and responses in WAF](https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html) in the [WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
         *
         * For information about the limits on count and size for custom request and response settings, see [WAF quotas](https://docs.aws.amazon.com/waf/latest/developerguide/limits.html) in the [WAF Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
         */
        var customResponseBodies: Map<String, CustomResponseBody>? = null
        /**
         * A description of the rule group that helps with identification.
         */
        var description: kotlin.String? = null
        /**
         * The name of the rule group. You cannot change the name of a rule group after you create it.
         */
        var name: kotlin.String? = null
        /**
         * The Rule statements used to identify the web requests that you want to allow, block, or count. Each rule includes one top-level statement that WAF uses to identify matching web requests, and parameters that govern how WAF handles them.
         */
        var rules: List<Rule>? = null
        /**
         * Specifies whether this is for an Amazon CloudFront distribution or for a regional application. A regional application can be an Application Load Balancer (ALB), an Amazon API Gateway REST API, or an AppSync GraphQL API.
         *
         * To work with CloudFront, you must also specify the Region US East (N. Virginia) as follows:
         * + CLI - Specify the Region when you use the CloudFront scope: `--scope=CLOUDFRONT --region=us-east-1`.
         * + API and SDKs - For all calls, use the Region endpoint us-east-1.
         */
        var scope: aws.sdk.kotlin.services.wafv2.model.Scope? = null
        /**
         * An array of key:value pairs to associate with the resource.
         */
        var tags: List<Tag>? = null
        /**
         * Defines and enables Amazon CloudWatch metrics and web request sample collection.
         */
        var visibilityConfig: aws.sdk.kotlin.services.wafv2.model.VisibilityConfig? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.wafv2.model.CreateRuleGroupRequest) : this() {
            this.capacity = x.capacity
            this.customResponseBodies = x.customResponseBodies
            this.description = x.description
            this.name = x.name
            this.rules = x.rules
            this.scope = x.scope
            this.tags = x.tags
            this.visibilityConfig = x.visibilityConfig
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.wafv2.model.CreateRuleGroupRequest = CreateRuleGroupRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.wafv2.model.VisibilityConfig] inside the given [block]
         */
        fun visibilityConfig(block: aws.sdk.kotlin.services.wafv2.model.VisibilityConfig.Builder.() -> kotlin.Unit) {
            this.visibilityConfig = aws.sdk.kotlin.services.wafv2.model.VisibilityConfig.invoke(block)
        }
    }
}
